/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.monitor.resource.response;

import de.virtimo.bpc.module.monitor.resource.response.MonitorTimeseriesAggregationData;
import de.virtimo.bpc.module.monitor.resource.response.MonitorTimeseriesAggregationDataField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.bucket.terms.Terms;

public class MonitorTimeseriesAggregationDataImpl
implements MonitorTimeseriesAggregationData {
    private final List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
    private final Set<MonitorTimeseriesAggregationDataField> fields = new HashSet<MonitorTimeseriesAggregationDataField>();

    public MonitorTimeseriesAggregationDataImpl(SearchResponse sr, SearchResponse allBeforeStartDateResponse, SearchResponse allAfterEndDateResponse) {
        if (allBeforeStartDateResponse != null) {
            Terms beforeStartDateFieldAgg = (Terms)allBeforeStartDateResponse.getAggregations().get("distinctValues");
            HashMap beforeStartDateFieldRecord = new HashMap();
            beforeStartDateFieldRecord.put("date", "beforestart");
            for (Terms.Bucket entry : beforeStartDateFieldAgg.getBuckets()) {
                beforeStartDateFieldRecord.put((String)entry.getKey(), entry.getDocCount());
                this.fields.add(this.getField(entry.getKeyAsString(), entry.getDocCount()));
            }
            this.data.add(beforeStartDateFieldRecord);
        }
        Histogram agg = (Histogram)sr.getAggregations().get("tsAgg");
        for (Histogram.Bucket entry : agg.getBuckets()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            record.put("date", entry.getKeyAsString());
            record.put("totalCount", entry.getDocCount());
            Terms fieldAgg = (Terms)entry.getAggregations().get("fieldAgg");
            for (Terms.Bucket fieldBucket : fieldAgg.getBuckets()) {
                Object key = fieldBucket.getKey();
                if (key instanceof String) {
                    record.put((String)key, fieldBucket.getDocCount());
                    continue;
                }
                record.put(String.valueOf(key), fieldBucket.getDocCount());
            }
            this.data.add((Map<String, Object>)record);
        }
        if (allAfterEndDateResponse != null) {
            Terms afterEndDateFieldAgg = (Terms)allAfterEndDateResponse.getAggregations().get("distinctValues");
            HashMap<String, Object> afterEndDateFieldRecord = new HashMap<String, Object>();
            afterEndDateFieldRecord.put("date", "afterend");
            for (Terms.Bucket entry : afterEndDateFieldAgg.getBuckets()) {
                afterEndDateFieldRecord.put((String)entry.getKey(), entry.getDocCount());
                this.fields.add(this.getField(entry.getKeyAsString(), entry.getDocCount()));
            }
            this.data.add(afterEndDateFieldRecord);
        }
        Terms fieldAgg = (Terms)sr.getAggregations().get("distinctValues");
        for (Terms.Bucket entry : fieldAgg.getBuckets()) {
            this.fields.add(this.getField(entry.getKeyAsString(), entry.getDocCount()));
        }
    }

    private MonitorTimeseriesAggregationDataField getField(String name, Long totalCount) {
        return new MonitorTimeseriesAggregationDataField(name, totalCount);
    }

    @Override
    public List<Map<String, Object>> getData() {
        return this.data;
    }

    @Override
    public Set<MonitorTimeseriesAggregationDataField> getFields() {
        return this.fields;
    }
}

