/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.module.forms;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.module.forms.Form;
import de.virtimo.bpc.module.forms.Module;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="/")
@ApplicationPath(value="cxf/bpc-forms")
@Tag(name="Forms API")
public class RestInterface {
    private static final Logger LOGGER = LogManager.getLogger(RestInterface.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public RestInterface(BundleContext bundleContext) {
        LOGGER.info("RestInterface bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll((Object)this);
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms")
    @BpcRoleOrRightRequired(right="FORMS_READ_ALL", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    @OperationDescription(summary="Get all forms listed in the forms repository.", description="Get all forms listed in the forms repository.\nOnly the latest version of each form is returned.\n")
    @ReturnDescription(value="List of all forms in forms repository as JSON. Each object has form configuration in config entry and other meta data.\n\nHTTP Status Code\n\n- 200 : OK\n- 401 : Unauthorized\n")
    public Response getFormsList() {
        try {
            Set<Form> forms = Module.getInstance().getManager().getForms();
            return Response.ok(forms).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Add a new form to the forms repository with specified id.", description="Add a new form to the forms repository with specified id.\nIf a form with the specified id already exists, the form is updated.\nExample:\n[source,json]\n----\n{\n     \"name\": \"Name of Form\",\n     \"config\": {\n         \"metaData\": {\n             \"id\": \"form_id\",\n             \"version\": 1\n         },\n         \"configuration\": {},\n         \"components\": [\n             {\n                 \"type\": \"textfield\",\n                 \"label\": \"Textfeld\"\n             }\n         ]\n     }\n}\n----\n")
    @ReturnDescription(value="Created form as JSON. Object has form configuration in config entry and other meta data.\n\nHTTP Status Code\n\n- 200 : OK\n- 400 : Form validation failed or structure of provided form is wrong\n- 401 : Unauthorized\n")
    @Produces(value={"application/json"})
    @POST
    @Path(value="/forms/{formId}")
    @BpcRoleOrRightRequired(right="FORMS_ADD", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response addForm(@Parameter(description="id of the new form.") @PathParam(value="formId") String formId, Map<String, Object> formInput) {
        try {
            Form form = Module.getInstance().getManager().addForm(formId, (String)formInput.get("name"), (Map)formInput.get("config"));
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Update a form in the forms repository.", description="Update a form in the forms repository.\nThe version is automatically incremented.\nIf no form with specified id exists, the form is created with version 1.\nExample:\n[source,json]\n----\n{\n     \"name\": \"Name of Form\",\n     \"config\": {\n         \"metaData\": {\n             \"id\": \"form_id\",\n             \"version\": 2\n         },\n         \"configuration\": {},\n         \"components\": [\n             {\n                 \"type\": \"textfield\",\n                 \"label\": \"Textfeld\"\n             }\n         ]\n     }\n}\n----\n")
    @ReturnDescription(value="Created form as JSON. Object has form configuration in config entry and other meta data.\n\nHTTP Status Code\n\n- 200 : OK\n- 400 : Form validation failed or structure of provided form is wrong\n- 401 : Unauthorized\n")
    @Produces(value={"application/json"})
    @PUT
    @Path(value="/forms/{formId}/{version}")
    @BpcRoleOrRightRequired(right="FORMS_UPDATE", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    public Response updateForm(@Parameter(description="id of the form. The old and new form have the same id.") @PathParam(value="formId") String formId, @Parameter(description="version of the new form.") @PathParam(value="version") String version, Map<String, Object> formInput) {
        try {
            Form form = Module.getInstance().getManager().addForm(formId, (String)formInput.get("name"), (Map)formInput.get("config"));
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms/{formId}")
    @BpcUserSessionRequired
    @OperationDescription(summary="Get a specific form with latest version of the forms repository.", description="Get a specific form with latest version of the forms repository.")
    @ReturnDescription(value="Specified form as JSON. Object has form configuration in config entry and other meta data.\n\nHTTP Status Code\n\n- 200 : OK\n- 401 : Unauthorized\n")
    public Response getForm(@Parameter(description="id of the form.") @PathParam(value="formId") String formId) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId);
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/forms/{formId}/{version}")
    @BpcUserSessionRequired
    @OperationDescription(summary="Get a specific form with specific version of the forms repository.", description="Get a specific form with specific version of the forms repository.\nIf the version does not exist, the latest version is returned.\n")
    @ReturnDescription(value="Specified form as JSON. Object has form configuration in config entry and other meta data.\n\nHTTP Status Code\n\n- 200 : OK\n- 401 : Unauthorized\n")
    public Response getFormVersion(@Parameter(description="id of the form.") @PathParam(value="formId") String formId, @Parameter(description="version of the form.") @PathParam(value="version") String version) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId, Integer.parseInt(version));
            return Response.ok((Object)form).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/history/{formId}")
    @BpcRoleOrRightRequired(right="FORMS_READ_HISTORY", role="FORMS_ADMIN")
    @BpcUserSessionRequired
    @OperationDescription(summary="Get all versions of a form in the forms repository.", description="Get all versions of a form in the forms repository.")
    @ReturnDescription(value="List of all form versions with specified id in forms repository as JSON. Each object has form configuration in config entry and other meta data.\n\nHTTP Status Code\n\n- 200 : OK\n- 401 : Unauthorized\n")
    public Response getFormHistory(@Parameter(description="id of the form.") @PathParam(value="formId") String formId) {
        try {
            Set<Form> forms = Module.getInstance().getManager().getFormHistory(formId);
            return Response.ok(forms).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/config/{formId}")
    @BpcUserSessionRequired
    @OperationDescription(summary="Get the configuration of a specific form with latest version of the forms repository.", description="Get the configuration of a specific form with latest version of the forms repository.")
    @ReturnDescription(value="Configuration of specified form as JSON.\n\nHTTP Status Code\n\n- 200 : OK\n- 401 : Unauthorized\n")
    public Response getFormConfig(@Parameter(description="id of the form.") @PathParam(value="formId") String formId) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId);
            return Response.ok(form.getConfig()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    @Path(value="/config/{formId}/{version}")
    @BpcUserSessionRequired
    @OperationDescription(summary="Get the configuration of a specific form with specified version of the forms repository.", description="Get the configuration of a specific form with specified version of the forms repository.\nIf the version does not exist, the configuration of the latest version is returned.\n")
    @ReturnDescription(value="Configuration of specified form as JSON.\n\nHTTP Status Code\n\n- 200 : OK\n- 401 : Unauthorized\n")
    public Response getFormVersionConfig(@Parameter(description="id of the form.") @PathParam(value="formId") String formId, @Parameter(description="version of the form.") @PathParam(value="version") String version) {
        try {
            Form form = Module.getInstance().getManager().getForm(formId, Integer.parseInt(version));
            return Response.ok(form.getConfig()).build();
        }
        catch (Exception ex) {
            return ErrorResponse.forException((Exception)ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

