/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.bytes;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.opensearch.core.common.bytes.AbstractBytesReference;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.util.ByteArray;

public class PagedBytesReference
extends AbstractBytesReference {
    public static final int PAGE_SIZE_IN_BYTES = 16384;
    private final ByteArray byteArray;
    private final int offset;
    private final int length;

    PagedBytesReference(ByteArray byteArray, int from, int length) {
        assert (!byteArray.hasArray()) : "use BytesReference#fromByteArray";
        this.byteArray = byteArray;
        this.offset = from;
        this.length = length;
    }

    @Override
    public byte get(int index) {
        return this.byteArray.get(this.offset + index);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        if (from < 0 || from + length > this.length()) {
            throw new IllegalArgumentException("can't slice a buffer with length [" + this.length() + "], with slice parameters from [" + from + "], length [" + length + "]");
        }
        return new PagedBytesReference(this.byteArray, this.offset + from, length);
    }

    @Override
    public BytesRef toBytesRef() {
        BytesRef bref = new BytesRef();
        this.byteArray.get(this.offset, this.length, bref);
        return bref;
    }

    @Override
    public final BytesRefIterator iterator() {
        final int offset = this.offset;
        final int length = this.length;
        final int initialFragmentSize = offset != 0 ? 16384 - offset % 16384 : 16384;
        return new BytesRefIterator(){
            int position = 0;
            int nextFragmentSize = Math.min(length, initialFragmentSize);
            final BytesRef slice = new BytesRef();
            final /* synthetic */ PagedBytesReference this$0;
            {
                this.this$0 = this$0;
            }

            public BytesRef next() throws IOException {
                if (this.nextFragmentSize != 0) {
                    boolean materialized = this.this$0.byteArray.get(offset + this.position, this.nextFragmentSize, this.slice);
                    assert (!materialized) : "iteration should be page aligned but array got materialized";
                    this.position += this.nextFragmentSize;
                    int remaining = length - this.position;
                    this.nextFragmentSize = Math.min(remaining, 16384);
                    return this.slice;
                }
                assert (this.nextFragmentSize == 0) : "fragmentSize expected [0] but was: [" + this.nextFragmentSize + "]";
                return null;
            }
        };
    }

    @Override
    public long ramBytesUsed() {
        return this.byteArray.ramBytesUsed();
    }
}

