/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.BackupSettingFactory;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupSetting {
    private static final Logger LOGGER = LogManager.getLogger(BackupSetting.class);
    public static final boolean DEFAULT_ENABLED = true;
    public static final long DEFAULT_INTERVAL_IN_SECONDS = 86400L;
    public static final long DEFAULT_KEEP_BACKUPS_DURATION_IN_SECONDS = 2592000L;
    private final boolean enabled;
    private final long intervalInSeconds;
    private final long keepBackupsDurationInSeconds;
    private final Set<String> indicesToBackup;

    @Deprecated(since="4.1.0", forRemoval=true)
    public static BackupSetting buildFrom(Setting backupSetting, String[] indices) {
        return BackupSettingFactory.createFrom(backupSetting, indices);
    }

    public static Map<String, Object> asMap(BackupSetting backupSetting) {
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Map map = (Map)mapper.convertValue((Object)backupSetting, (TypeReference)new TypeReference<Map<String, Object>>(){});
            return map;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    public static BackupSetting createFrom(Map<String, Object> backupSettingAsMap) {
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            BackupSetting backupSetting = (BackupSetting)mapper.convertValue(backupSettingAsMap, BackupSetting.class);
            return backupSetting;
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    private BackupSetting() {
        this.enabled = true;
        this.intervalInSeconds = 86400L;
        this.keepBackupsDurationInSeconds = 2592000L;
        this.indicesToBackup = Collections.emptySet();
    }

    private BackupSetting(BackupSettingBuilder builder) {
        LOGGER.info("BackupSetting builder={}", (Object)builder);
        this.enabled = builder.enabled;
        this.intervalInSeconds = builder.intervalInSeconds;
        this.keepBackupsDurationInSeconds = builder.keepBackupsDurationInSeconds;
        this.indicesToBackup = builder.indicesToBackup;
    }

    public static BackupSettingBuilder copyOf(BackupSetting backupSetting) {
        return BackupSettingBuilder.newInstance().copyOf(backupSetting);
    }

    public static BackupSettingBuilder withEnabled(boolean enabled) {
        return BackupSettingBuilder.newInstance().withEnabled(enabled);
    }

    public static BackupSettingBuilder withIntervalInSeconds(long intervalInSeconds) {
        return BackupSettingBuilder.newInstance().withIntervalInSeconds(intervalInSeconds);
    }

    public static BackupSettingBuilder withKeepBackupsDurationInSeconds(long keepBackupsDurationInSeconds) {
        return BackupSettingBuilder.newInstance().withKeepBackupsDurationInSeconds(keepBackupsDurationInSeconds);
    }

    public static BackupSettingBuilder withIndicesToBackup(String ... indicesToBackup) {
        return BackupSettingBuilder.newInstance().withIndicesToBackup(indicesToBackup);
    }

    public static BackupSettingBuilder withIndicesToBackup(Set<String> indicesToBackup) {
        return BackupSettingBuilder.newInstance().withIndicesToBackup(indicesToBackup);
    }

    @JsonProperty(value="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="intervalInSeconds")
    public long getIntervalInSeconds() {
        return this.intervalInSeconds;
    }

    @JsonProperty(value="keepBackupsDurationInSeconds")
    public long getKeepBackupsDurationInSeconds() {
        return this.keepBackupsDurationInSeconds;
    }

    @JsonProperty(value="indicesToBackup")
    public Set<String> getIndicesToBackup() {
        return this.indicesToBackup;
    }

    @JsonIgnore
    public String getIndicesToBackupNamesAsKey() {
        return StringUtil.implode("_", this.indicesToBackup);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupSetting that = (BackupSetting)o;
        return this.enabled == that.enabled && this.intervalInSeconds == that.intervalInSeconds && this.keepBackupsDurationInSeconds == that.keepBackupsDurationInSeconds && Objects.equals(this.indicesToBackup, that.indicesToBackup);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.intervalInSeconds, this.keepBackupsDurationInSeconds, this.indicesToBackup);
    }

    public String toString() {
        return "BackupSetting{enabled=" + this.enabled + ", intervalInSeconds=" + this.intervalInSeconds + ", keepBackupsDurationInSeconds=" + this.keepBackupsDurationInSeconds + ", indicesToBackup=" + String.valueOf(this.indicesToBackup) + "}";
    }

    public static class BackupSettingBuilder {
        private boolean enabled = true;
        private long intervalInSeconds = 86400L;
        private long keepBackupsDurationInSeconds = 2592000L;
        private final Set<String> indicesToBackup = new HashSet<String>();

        private BackupSettingBuilder() {
        }

        private static BackupSettingBuilder newInstance() {
            return new BackupSettingBuilder();
        }

        public BackupSettingBuilder copyOf(BackupSetting backupSetting) {
            this.enabled = backupSetting.enabled;
            this.intervalInSeconds = backupSetting.intervalInSeconds;
            this.keepBackupsDurationInSeconds = backupSetting.keepBackupsDurationInSeconds;
            if (backupSetting.indicesToBackup != null) {
                this.indicesToBackup.addAll(backupSetting.indicesToBackup);
            }
            return this;
        }

        public BackupSettingBuilder withEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public BackupSettingBuilder withIntervalInSeconds(long intervalInSeconds) {
            this.intervalInSeconds = intervalInSeconds;
            return this;
        }

        public BackupSettingBuilder withKeepBackupsDurationInSeconds(long keepBackupsDurationInSeconds) {
            this.keepBackupsDurationInSeconds = keepBackupsDurationInSeconds;
            return this;
        }

        public BackupSettingBuilder withIndicesToBackup(String ... indicesToBackup) {
            this.indicesToBackup.clear();
            if (indicesToBackup != null) {
                Collections.addAll(this.indicesToBackup, indicesToBackup);
            }
            return this;
        }

        public BackupSettingBuilder withIndicesToBackup(Set<String> indicesToBackup) {
            this.indicesToBackup.clear();
            if (indicesToBackup != null) {
                this.indicesToBackup.addAll(indicesToBackup);
            }
            return this;
        }

        public BackupSetting build() {
            return new BackupSetting(this);
        }
    }
}

