/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BackupSetting;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.util.MapUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackupSettingFactory {
    private static final Logger LOGGER = LogManager.getLogger(BackupSettingFactory.class);
    private static final String ENABLED = "enabled";
    private static final String INTERVAL_IN_SECONDS = "intervalInSeconds";
    private static final String KEEP_BACKUPS_DURATION_IN_SECONDS = "keepBackupsDurationInSeconds";

    public static BackupSetting createFrom(Setting backupSetting, String[] indices) {
        return BackupSettingFactory.createFrom(backupSetting, (Set<String>)(indices == null ? null : new HashSet<String>(Arrays.asList(indices))));
    }

    public static BackupSetting createFrom(Setting backupSetting, Set<String> indices) {
        if (backupSetting == null) {
            return BackupSettingFactory.createFrom(null, indices);
        }
        return BackupSettingFactory.createFrom(backupSetting.getValue(), indices);
    }

    public static BackupSetting createFrom(Object backupSettingValuesObject, Collection<String> indices) {
        if (backupSettingValuesObject instanceof Map) {
            Map valueMap = (Map)backupSettingValuesObject;
            return BackupSetting.withEnabled(MapUtil.getValueAsBoolean(valueMap, ENABLED, true)).withIntervalInSeconds(MapUtil.getValueAsLong(valueMap, INTERVAL_IN_SECONDS, 86400L)).withKeepBackupsDurationInSeconds(MapUtil.getValueAsLong(valueMap, KEEP_BACKUPS_DURATION_IN_SECONDS, 2592000L)).withIndicesToBackup(indices == null ? null : Set.copyOf(indices)).build();
        }
        LOGGER.error("The backup setting must be a JSON object. Using the defaults.");
        return BackupSetting.withIndicesToBackup(indices == null ? null : Set.copyOf(indices)).build();
    }

    public static Map<String, Object> asBackupJobSettingValue(BackupSetting backupSetting) {
        return Map.of("settings", MapUtil.mapOf(ENABLED, backupSetting.isEnabled(), INTERVAL_IN_SECONDS, backupSetting.getIntervalInSeconds(), KEEP_BACKUPS_DURATION_IN_SECONDS, backupSetting.getKeepBackupsDurationInSeconds()), "indices", backupSetting.getIndicesToBackup());
    }
}

