/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.EventFilter;
import de.virtimo.bpc.api.WebsocketRecipients;
import de.virtimo.bpc.api.apikey.APIKeyException;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.IdentityProvider;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import java.net.HttpCookie;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import org.eclipse.jetty.websocket.api.Session;

public interface ClientSessionManager {
    public boolean existsSession(String var1);

    @Deprecated(since="4.1.21, 4.2.9", forRemoval=true)
    public String getSessionId(HttpHeaders var1);

    public String getSessionId(HttpServletRequest var1);

    public String getSessionId(List<HttpCookie> var1);

    public String getSessionIdFromNonHijackableSessionId(String var1);

    public String getNonHijackableSessionIdFromSessionId(String var1);

    public UserSession getUserSession(String var1);

    @Deprecated(since="4.1.21, 4.2.9", forRemoval=true)
    public UserSession getUserSession(HttpHeaders var1) throws APIKeyException;

    public UserSession getUserSession(HttpServletRequest var1) throws APIKeyException;

    public List<UserSession> findUserSessionByCustomData(String var1, Object var2);

    public List<UserSession> findUserSessionBySensitiveCustomData(String var1, Object var2);

    public void addSession(String var1, Session var2);

    public void addSession(String var1, UserSession var2);

    public void removeAllSessions(boolean var1) throws ModuleNotFoundException, ServiceNotFoundException;

    public void removeAllSessions(boolean var1, IdentityProvider var2);

    public void removeSession(String var1, boolean var2) throws ModuleNotFoundException, ServiceNotFoundException;

    public void removeSession(String var1, boolean var2, IdentityProvider var3);

    public void removeSession(String var1, Session var2);

    public int getSessionCount();

    public List<ClientSession> getAllSessions();

    public void transferWebsocketConnections(UserSession var1, UserSession var2);

    public int getOpenWebsocketConnectionsCount();

    public void sendByWebsocket(ClientSession var1, String var2);

    public void sendByWebsocket(String var1, String var2);

    public void sendToUserRolesByWebsocket(Set<String> var1, String var2);

    public void sendToUserRolesByWebsocketAsync(Set<String> var1, String var2, Map<String, Object> var3);

    public void sendToUserRolesByWebsocketAsync(Set<String> var1, String var2, List<Map<String, Object>> var3);

    public void broadcastMessage(String var1);

    public void broadcastMessage(String var1, WebsocketRecipients var2);

    public void addBlacklistEventFilter(EventFilter var1);
}

