/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class ErrorResponse {
    public static ErrorResponseBuilder forException(Exception ex) {
        return ErrorResponseBuilder.newInstance().forException(ex);
    }

    public static ErrorResponseBuilder usingTracker(BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker) {
        return ErrorResponseBuilder.newInstance().usingTracker(errorResponseServiceTracker);
    }

    public static ErrorResponseBuilder languageFrom(HttpHeaders httpHeaders) {
        return ErrorResponseBuilder.newInstance().languageFrom(httpHeaders);
    }

    public static ErrorResponseBuilder language(String language) {
        return ErrorResponseBuilder.newInstance().language(language);
    }

    public static ErrorResponseBuilder redirectBrowsersToIdpLogin(String requestUri, HttpHeaders httpHeaders) {
        return ErrorResponseBuilder.newInstance().redirectBrowsersToIdpLogin(requestUri, httpHeaders);
    }

    public static SystemException reconstructSystemException(BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker, Response response, List<Class<? extends Enum<?>>> errorCodeEnumClasses) {
        Objects.requireNonNull(errorResponseServiceTracker, "errorResponseServiceTracker must not be null");
        Objects.requireNonNull(response, "response must not be null");
        try {
            return errorResponseServiceTracker.getService().reconstructSystemException(response, errorCodeEnumClasses);
        }
        catch (ServiceNotFoundException snfex) {
            return null;
        }
    }

    public static SystemException reconstructSystemException(Response response, List<Class<? extends Enum<?>>> errorCodeEnumClasses) {
        Objects.requireNonNull(response, "response must not be null");
        try {
            return ErrorResponse.getErrorResponseService().reconstructSystemException(response, errorCodeEnumClasses);
        }
        catch (ServiceNotFoundException snfex) {
            return null;
        }
    }

    private static ErrorResponseService getErrorResponseService() throws ServiceNotFoundException {
        BundleContext bundleContext = FrameworkUtil.getBundle(ErrorResponse.class).getBundleContext();
        try (BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(bundleContext, ErrorResponseService.class);){
            ErrorResponseService errorResponseService = errorResponseServiceTracker.getService();
            return errorResponseService;
        }
    }

    private static boolean isAgentAWebBrowser(HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            return false;
        }
        String userAgent = httpHeaders.getHeaderString("User-Agent");
        if (StringUtil.isNullOrEmpty(userAgent)) {
            return false;
        }
        String userAgentLowerCase = userAgent.toLowerCase();
        String[] browserSignatures = new String[]{"chrome", "firefox", "safari", "edge", "trident", "msie", "opera", "gecko", "mozilla"};
        return Arrays.stream(browserSignatures).filter(userAgentLowerCase::contains).count() >= 2L;
    }

    public static class ErrorResponseBuilder {
        private Exception ex = null;
        private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker = null;
        private HttpHeaders httpHeaders = null;
        private String language = null;
        private String requestUri;
        private NewCookie[] cookies = null;

        private ErrorResponseBuilder() {
        }

        private static ErrorResponseBuilder newInstance() {
            return new ErrorResponseBuilder();
        }

        public ErrorResponseBuilder forException(Exception ex) {
            this.ex = ex;
            return this;
        }

        public ErrorResponseBuilder usingTracker(BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker) {
            this.errorResponseServiceTracker = errorResponseServiceTracker;
            return this;
        }

        public ErrorResponseBuilder languageFrom(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public ErrorResponseBuilder language(String language) {
            this.language = language;
            return this;
        }

        public ErrorResponseBuilder redirectBrowsersToIdpLogin(String requestUri, HttpHeaders httpHeaders) {
            if (ErrorResponse.isAgentAWebBrowser(httpHeaders)) {
                this.requestUri = requestUri;
            }
            return this;
        }

        public ErrorResponseBuilder cookies(NewCookie[] cookies) {
            this.cookies = cookies;
            return this;
        }

        public Response build() {
            try {
                ErrorResponseService errorResponseService = this.errorResponseServiceTracker != null ? this.errorResponseServiceTracker.getService() : ErrorResponse.getErrorResponseService();
                ErrorResponseService.ResponseForExceptionOptions options = new ErrorResponseService.ResponseForExceptionOptions(this.language, this.httpHeaders, this.cookies, this.requestUri);
                return errorResponseService.responseForException(this.ex, options);
            }
            catch (ServiceNotFoundException snfex) {
                return this.shouldNotHappenWorkaroundResponse();
            }
        }

        private Response shouldNotHappenWorkaroundResponse() {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("application/json").entity(Map.of("error", Map.of("code", 1, "name", "UNEXPECTED", "message", "Failed to get the mandatory error response service."))).build();
        }
    }
}

