/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.auditlog;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.auditlog.AuditLogLevel;
import de.virtimo.bpc.api.auditlog.AuditLogService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class AuditLog {
    private static final Logger LOGGER = LogManager.getLogger(AuditLog.class);

    public static synchronized void log(AuditLogLevel level, String originator, String action, String description, Object oldValues, Object newValues) {
        LOGGER.info("log level={}, originator={}, action={}, description={}, oldValues=..., newValues=...", (Object)level, (Object)originator, (Object)action, (Object)description);
        BundleContext bundleContext = FrameworkUtil.getBundle(AuditLog.class).getBundleContext();
        try (BpcServicesTracker<AuditLogService> auditLogServiceTracker = new BpcServicesTracker<AuditLogService>(bundleContext, AuditLogService.class);){
            AuditLogService auditLogService = auditLogServiceTracker.getService();
            auditLogService.log(level, originator, action, description, oldValues, newValues);
        }
        catch (Exception ex) {
            LOGGER.error("Could not perform the audit logging.", (Throwable)ex);
        }
    }
}

