/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.api.service;

import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.util.StringUtil;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

public interface ErrorResponseService {
    public static String getBpcLanguage(HttpHeaders headers) {
        String language;
        String string = language = headers == null ? null : headers.getHeaderString("X-BPC-Language");
        if (StringUtil.isNullOrEmpty(language)) {
            language = "en";
        }
        return language;
    }

    public static String getBpcLanguage(ResponseForExceptionOptions options) {
        if (options == null) {
            return "en";
        }
        if (!StringUtil.isNullOrEmpty(options.language())) {
            return options.language();
        }
        return ErrorResponseService.getBpcLanguage(options.httpHeaders());
    }

    public Response responseForException(Exception var1);

    public Response responseForException(Exception var1, ResponseForExceptionOptions var2);

    @Deprecated(since="5.0.0", forRemoval=true)
    public Response responseForException(Exception var1, NewCookie[] var2);

    @Deprecated(since="5.0.0", forRemoval=true)
    public Response responseForException(HttpHeaders var1, Exception var2);

    @Deprecated(since="5.0.0", forRemoval=true)
    public Response responseForException(HttpHeaders var1, Exception var2, NewCookie[] var3);

    @Deprecated(since="5.0.0", forRemoval=true)
    public Response responseForException(String var1, Exception var2);

    @Deprecated(since="5.0.0", forRemoval=true)
    public Response responseForException(String var1, Exception var2, NewCookie[] var3);

    public SystemException reconstructSystemException(Response var1, List<Class<? extends Enum<?>>> var2);

    public SystemException createSystemExceptionFromErrorResponse(Map<String, Object> var1, List<Class<? extends Enum<?>>> var2);

    public Map<String, Object> asMap(Response var1);

    public record ResponseForExceptionOptions(String language, HttpHeaders httpHeaders, NewCookie[] cookies, String requestUri) {
        public static ResponseForExceptionOptions defaultOptions() {
            return new ResponseForExceptionOptions(null, null, null, null);
        }
    }
}

