/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.apikey;

import de.virtimo.bpc.core.apikey.APIKey;
import de.virtimo.bpc.core.auth.AbstractUserSession;
import java.util.Date;

public class APIKeySession
extends AbstractUserSession {
    private final APIKey apiKey;

    public APIKeySession(APIKey apiKey) {
        this.apiKey = apiKey;
        this.organisations.addAll(apiKey.getAssignedOrganisations());
        this.roles.addAll(apiKey.getAssignedRoles());
        this.rights.addAll(apiKey.getAssignedRights());
    }

    @Override
    public String getSessionId() {
        return this.apiKey.getKey();
    }

    @Override
    public String getFirstName() {
        return "API";
    }

    @Override
    public String getLastName() {
        return "Key";
    }

    @Override
    public String getLoginName() {
        return this.apiKey.getId();
    }

    @Override
    public String getEmail() {
        return null;
    }

    @Override
    public Date getExpirationDate() {
        return this.apiKey.getExpirationDate();
    }

    @Override
    public String toString() {
        return "APIKeySession{apiKey=" + String.valueOf(this.apiKey) + "}";
    }
}

