/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.backendconnections.BackendConnections;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class IdentityProviderBackendConnectionValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(IdentityProviderBackendConnectionValidator.class);
    private BundleContext bundleContext;

    public IdentityProviderBackendConnectionValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "_core".equalsIgnoreCase(moduleId);
    }

    @Override
    public boolean canValidate(Setting setting) {
        if ("_core".equalsIgnoreCase(setting.getModuleId())) {
            List<String> settingsToValidate = Arrays.asList("identityProviderBackendConnection");
            return settingsToValidate.contains(setting.getName());
        }
        return false;
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        String idpBackendConnectionIdOrName;
        LOGGER.info("validate setting:{}", (Object)setting);
        if (setting.getName().equalsIgnoreCase("identityProviderBackendConnection") && !StringUtil.isNullOrEmpty(idpBackendConnectionIdOrName = (String)setting.getValue())) {
            try {
                IdentityProviderConfiguration identityProviderConfiguration = BackendConnections.getIdentityProviderConfiguration(this.bundleContext, idpBackendConnectionIdOrName);
            }
            catch (Exception ex) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Unknown identity provider backend connection: ${value}", MapUtil.mapOf("field", "identityProviderBackendConnection", "value", idpBackendConnectionIdOrName));
            }
        }
        return null;
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings:...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        return null;
    }
}

