/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.oidc.OidcIdentityProvider;
import de.virtimo.bpc.core.auth.oidc.OidcUri;
import de.virtimo.bpc.module.simple.SimpleSettingValueImpl;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class IdentityProviderSettingsValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(IdentityProviderSettingsValidator.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;

    public IdentityProviderSettingsValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "backendconnection".equalsIgnoreCase(moduleId) && "identity_provider".equalsIgnoreCase(instanceType);
    }

    @Override
    public boolean canValidate(Setting setting) {
        if ("identity_provider".equalsIgnoreCase(setting.getInstanceType())) {
            List<String> settingsToValidate = Arrays.asList("identityProvider", "identityProvider_mappings", "identityProvider_sessionExpirationMinutes", "identityProvider_jdbc_dataSource", "identityProvider_oidc_clientId", "identityProvider_oidc_clientSecret", "identityProvider_oidc_scope", "identityProvider_oidc_claimNameRights", "identityProvider_oidc_claimNameRoles", "identityProvider_oidc_claimNameOrganisations", "identityProvider_oidc_metadataDiscoveryUri", "identityProvider_oidc_postAuthenticationRedirectUri", "identityProvider_oidc_postLogoutRedirectUri");
            return settingsToValidate.contains(setting.getName());
        }
        return false;
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        Object idpMappingsObject;
        LOGGER.info("validate setting:{}", (Object)setting);
        if (setting.getName().equalsIgnoreCase("identityProvider")) {
            String identityProvider = (String)setting.getValue();
            if (StringUtil.isNullOrEmpty(identityProvider)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_MISSING_IDENTITY_PROVIDER", MapUtil.mapOf("field", "identityProvider"));
            }
            List<String> knownIdentityProviders = Arrays.asList("local", "karaf", "jdbc", "keycloak", "oidc");
            if (!knownIdentityProviders.contains(identityProvider)) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_UNKNOWN_IDENTITY_PROVIDER", MapUtil.mapOf("field", "identityProvider", "identityProvider", identityProvider, "supportedIdentityProviders", knownIdentityProviders));
            }
        }
        if (setting.getName().equalsIgnoreCase("identityProvider_sessionExpirationMinutes")) {
            if (setting.getValue() == null) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_SETTING_MISSING", MapUtil.mapOf("field", "identityProvider_sessionExpirationMinutes"));
            }
            if (setting.getSettingValue().asInt(-1) <= 0) {
                throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_MIN_NUMERIC_VALUE", MapUtil.mapOf("field", "identityProvider_sessionExpirationMinutes", "minValue", 0));
            }
        }
        if (setting.getName().equalsIgnoreCase("identityProvider_mappings") && (idpMappingsObject = setting.getValue()) instanceof Map) {
            this.validateIdentityProviderMappings((Map)idpMappingsObject);
        }
        return null;
    }

    private void validateIdentityProviderMappings(Map<String, Object> mappings) throws ValidationException {
        LOGGER.info("validateIdentityProviderMappings mappings={}", mappings);
        Set<String> validTopLevelKeys = SetUtil.setOf("organisations", "roles", "rights", "users");
        for (String topLevelKey : mappings.keySet()) {
            if (validTopLevelKeys.contains(topLevelKey.toLowerCase())) continue;
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_INVALID_TOP_LEVEL_KEY_IN_MAPPINGS", MapUtil.mapOf("topLevelKey", topLevelKey, "field", "identityProvider_mappings"));
        }
        ArrayList<String> assignedOrganisations = new ArrayList<String>();
        ArrayList<String> assignedRoles = new ArrayList<String>();
        ArrayList<String> assignedRights = new ArrayList<String>();
        this.caseSensitiveValuesCheck(mappings, assignedOrganisations, "assignedOrganisations");
        this.caseSensitiveValuesCheck(mappings, assignedRoles, "assignedRoles");
        this.caseSensitiveValuesCheck(mappings, assignedRights, "assignedRights");
    }

    private void caseSensitiveValuesCheck(Object mappings, List<String> alreadyAssignedValues, String assignedValuesKey) throws ValidationException {
        if (mappings instanceof Map) {
            Map m = (Map)mappings;
            for (Object mk : m.keySet()) {
                if (mk instanceof String && assignedValuesKey.equals(mk)) {
                    List assignedValues = (List)m.get(assignedValuesKey);
                    for (String assignedValue : assignedValues) {
                        this.checkIfValueExistsAlreadyInOtherCaseSensitivity(alreadyAssignedValues, assignedValue, assignedValuesKey);
                        alreadyAssignedValues.add(assignedValue);
                    }
                    continue;
                }
                this.caseSensitiveValuesCheck(m.get(mk), alreadyAssignedValues, assignedValuesKey);
            }
        }
    }

    private void checkIfValueExistsAlreadyInOtherCaseSensitivity(List<String> containerValues, String value, String assignedType) throws ValidationException {
        for (String containerValue : containerValues) {
            if (!containerValue.equalsIgnoreCase(value) || containerValue.equals(value)) continue;
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_INVALID_MAPPINGS_VALUE", MapUtil.mapOf("field", "identityProvider_mappings", "assignedType", assignedType, "value", value, "otherValue", containerValue));
        }
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        String identityProvider;
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings=...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        switch (identityProvider = (String)settings.get("identityProvider").getValue()) {
            case "jdbc": {
                this.validateJdbc(settings);
                break;
            }
            case "oidc": {
                this.validateOidc(settings, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_OIDC");
                break;
            }
            case "keycloak": {
                this.validateOidc(settings, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_KEYCLOAK");
            }
        }
        return null;
    }

    private void validateJdbc(Map<String, Setting> settings) throws ValidationException {
        LOGGER.info("validateJdbc settings=...");
        String datasourceName = (String)settings.get("identityProvider_jdbc_dataSource").getValue();
        if (StringUtil.isNullOrEmpty(datasourceName)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_JDBC_DATASOURCE_MISSING", MapUtil.mapOf("field", "identityProvider_jdbc_dataSource"));
        }
        try {
            DatabaseManager databaseManager = this.databaseManagerTracker.getService();
            databaseManager.getDataSource(datasourceName);
        }
        catch (ServiceNotFoundException e) {
            throw new ValidationException((ErrorCode)BpcErrorCode.SERVICE_NOT_FOUND, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_JDBC_DATABASE_MANAGER_MISSING", MapUtil.mapOf("field", "identityProvider_jdbc_dataSource", "dataSource", datasourceName));
        }
        catch (DataSourceNotFoundException e) {
            throw new ValidationException((ErrorCode)BpcErrorCode.DATABASE_DATASOURCE_NOT_FOUND, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_JDBC_DATASOURCE_DOES_NOT_EXIST", MapUtil.mapOf("field", "identityProvider_jdbc_dataSource", "dataSource", datasourceName));
        }
    }

    private void validateOidc(Map<String, Setting> settings, String validationErrorMessageKey) throws ValidationException {
        LOGGER.info("validateOidc settings=...");
        try {
            IdentityProviderConfiguration idpConfig = new IdentityProviderConfiguration(settings);
            OidcIdentityProvider.checkOidcConfiguration(idpConfig);
        }
        catch (Exception e) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, validationErrorMessageKey, MapUtil.mapOf("error", e.getMessage()), (Throwable)e);
        }
        this.validateOidcUriSetting(settings, "identityProvider_oidc_metadataDiscoveryUri");
        this.validateOidcUriSetting(settings, "identityProvider_oidc_postAuthenticationRedirectUri");
        this.validateOidcUriSetting(settings, "identityProvider_oidc_postLogoutRedirectUri");
    }

    private void validateOidcUriSetting(Map<String, Setting> settings, String settingName) throws ValidationException {
        LOGGER.debug("validateOidcUriSetting settings=..., settingName={}", (Object)settingName);
        try {
            Setting oidcUriSetting = settings.get(settingName);
            SimpleSettingValueImpl oidcUriSettingValue = new SimpleSettingValueImpl(oidcUriSetting);
            List oidcUriConfigValue = oidcUriSettingValue.asList();
            OidcUri oidcUri = new OidcUri(oidcUriConfigValue);
            if (oidcUri.isSingle()) {
                URI oidcURI = oidcUri.getURIs().iterator().next();
                this.validateUrl(oidcURI.toString(), settingName, true);
            } else {
                for (URI oidcURI : oidcUri.getURIs()) {
                    this.validateUrl(oidcURI.toString(), settingName, false);
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_SYNTAX_RELATED", MapUtil.mapOf("field", settingName, "error", ex.getMessage()));
        }
    }

    private void validateUrl(String url, String fieldName, boolean checkResponseCode) throws ValidationException {
        LOGGER.debug("validateUrl url={}, fieldName={}, checkResponseCode={}", (Object)url, (Object)fieldName, (Object)checkResponseCode);
        if (StringUtil.isNullOrEmpty(url)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_MISSING", MapUtil.mapOf("field", fieldName));
        }
        try {
            URL u = new URL(url);
            URI i = u.toURI();
            HttpURLConnection conn = (HttpURLConnection)u.openConnection();
            conn.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(20L));
            conn.setReadTimeout((int)TimeUnit.SECONDS.toMillis(10L));
            BpcTrustStore.getInstance().setTo(conn);
            if (checkResponseCode) {
                int responseCode = conn.getResponseCode();
                if (responseCode < 200 || responseCode >= 400) {
                    throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_UNEXPECTED_RESPONSE_CODE", MapUtil.mapOf("field", fieldName, "url", url, "responseCode", responseCode));
                }
            } else {
                conn.connect();
            }
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_SYNTAX_RELATED", MapUtil.mapOf("field", fieldName, "url", url, "error", ex.getMessage()));
        }
        catch (SSLException ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL_SSL_RELATED", MapUtil.mapOf("field", fieldName, "url", url, "error", ex.getMessage()));
        }
        catch (Exception ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "CORE_ERROR_IDENTITY_PROVIDER_VALIDATION_URL", MapUtil.mapOf("field", fieldName, "url", url, "error", ex.getMessage()));
        }
    }
}

