/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth;

import de.virtimo.bpc.api.auth.InactiveOrganisation;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.core.auth.InactiveOrganisationImpl;
import de.virtimo.bpc.core.auth.OrganisationImpl;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OrganisationFactory {
    public static Organisation getDefaultOrganisation() {
        return OrganisationFactory.getOrganisation("DEFAULT");
    }

    public static Organisation getOrganisation(Principal principal) {
        return OrganisationFactory.getOrganisation(principal.getName());
    }

    public static Organisation getOrganisation(String organisationName) {
        return new OrganisationImpl(organisationName);
    }

    public static Set<Organisation> getOrganisations(Collection<String> organisationNames) {
        HashSet<Organisation> result = new HashSet<Organisation>();
        if (organisationNames != null) {
            for (String organisationName : organisationNames) {
                result.add(OrganisationFactory.getOrganisation(organisationName));
            }
        }
        return result;
    }

    public static InactiveOrganisation getDefaultInactiveOrganisation() {
        return OrganisationFactory.getInactiveOrganisation("DEFAULT");
    }

    public static InactiveOrganisation getInactiveOrganisation(Principal principal) {
        return OrganisationFactory.getInactiveOrganisation(principal.getName());
    }

    public static InactiveOrganisation getInactiveOrganisation(String name) {
        return new InactiveOrganisationImpl(name);
    }
}

