/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.idp;

import de.virtimo.bpc.api.auth.idp.UserSessionRequest;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;

public class HttpUserSessionRequest
implements UserSessionRequest {
    private HttpServletRequest httpServletRequest;
    private MultivaluedMap<String, String> additionalParams;

    public HttpUserSessionRequest(HttpServletRequest httpServletRequest, MultivaluedMap<String, String> additionalParams) {
        this.httpServletRequest = httpServletRequest;
        this.additionalParams = additionalParams;
    }

    public HttpUserSessionRequest(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, (MultivaluedMap<String, String>)new MultivaluedHashMap());
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public String getCookieValue(String cookieName) {
        Cookie[] cookies = this.httpServletRequest.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equalsIgnoreCase(cookieName)) continue;
            return cookie.getValue();
        }
        return null;
    }

    public String getFormParam(String formParamName) {
        if (this.additionalParams != null && this.additionalParams.containsKey((Object)formParamName)) {
            return (String)this.additionalParams.getFirst((Object)formParamName);
        }
        return this.httpServletRequest.getParameter(formParamName);
    }

    public URI getUri() throws URISyntaxException {
        String uri = this.httpServletRequest.getScheme() + "://" + this.httpServletRequest.getServerName() + (String)("http".equals(this.httpServletRequest.getScheme()) && this.httpServletRequest.getServerPort() == 80 || "https".equals(this.httpServletRequest.getScheme()) && this.httpServletRequest.getServerPort() == 443 ? "" : ":" + this.httpServletRequest.getServerPort()) + this.httpServletRequest.getRequestURI() + (String)(this.httpServletRequest.getQueryString() != null ? "?" + this.httpServletRequest.getQueryString() : "");
        return new URI(uri);
    }
}

