/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.jaas;

import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.User;
import de.virtimo.bpc.api.auth.jaas.BpcCallbackHandler;
import de.virtimo.bpc.api.auth.jaas.SessionToken;
import de.virtimo.bpc.core.auth.AbstractUserSession;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.jaas.RightPrincipal;
import de.virtimo.bpc.util.UUIDGenerator;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.karaf.jaas.boot.principal.GroupPrincipal;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JaasSession
extends AbstractUserSession {
    private static final Logger LOGGER = LogManager.getLogger(JaasSession.class);
    private String sessionId;
    private String username;
    private String firstName;
    private String lastName;
    private String email;
    private Date expirationDate;
    private LoginContext loginContext;
    private BpcCallbackHandler bpcCallbackHandler;

    public JaasSession(LoginContext loginContext, BpcCallbackHandler bpcCallbackHandler, BackingEngine backingEngine, int expirationInMinutes) {
        Set<SessionToken> sessionTokens;
        this.bpcCallbackHandler = bpcCallbackHandler;
        this.loginContext = loginContext;
        this.username = JaasSession.extractUsername(loginContext);
        this.firstName = "";
        this.lastName = "";
        this.email = "";
        if (backingEngine != null) {
            try {
                Method getUserMethod = backingEngine.getClass().getDeclaredMethod("getUser", String.class);
                Object getUserResultObject = getUserMethod.invoke((Object)backingEngine, this.username);
                if (getUserResultObject instanceof User) {
                    User user = (User)getUserResultObject;
                    this.firstName = user.getFirstName();
                    this.lastName = user.getLastName();
                    this.email = user.getEmail();
                }
            }
            catch (Exception getUserMethod) {
                // empty catch block
            }
        }
        this.sessionId = (sessionTokens = loginContext.getSubject().getPrivateCredentials(SessionToken.class)).isEmpty() ? UUIDGenerator.randomUUID() : sessionTokens.iterator().next().get();
        String tenantString = bpcCallbackHandler.getTenant();
        HashSet tenantList = new HashSet();
        if (tenantString != null) {
            tenantList.addAll(Arrays.asList(tenantString.split(",")).stream().map(String::trim).collect(Collectors.toList()));
        }
        for (Principal p : loginContext.getSubject().getPrincipals()) {
            LOGGER.debug("got principal: {} ({})", (Object)p.getName(), (Object)p.getClass().getName());
            if (p instanceof RolePrincipal) {
                LOGGER.debug("add role {}", (Object)p.getName());
                this.roles.add(RolesFactory.getRole(p));
                continue;
            }
            if (p instanceof GroupPrincipal || p instanceof Organisation) {
                if (tenantList.isEmpty() || tenantList.contains(p.getName())) {
                    LOGGER.debug("add organisation {}", (Object)p.getName());
                    this.organisations.add(OrganisationFactory.getOrganisation(p));
                    continue;
                }
                LOGGER.debug("add inactiveOrganisation {}", (Object)p.getName());
                this.inactiveOrganisations.add(OrganisationFactory.getInactiveOrganisation(p));
                continue;
            }
            if (p instanceof RightPrincipal) {
                LOGGER.debug("add right {}", (Object)p.getName());
                this.rights.add(RightFactory.getRight(p));
                continue;
            }
            LOGGER.debug("add principal {}", (Object)p.getName());
            String principalClass = p.getClass().getName();
            if (!this.principals.containsKey(principalClass)) {
                this.principals.put(principalClass, new ArrayList());
            }
            ((List)this.principals.get(principalClass)).add(p.getName());
        }
        if (tenantList.contains("DEFAULT")) {
            this.organisations.add(OrganisationFactory.getDefaultOrganisation());
        } else {
            this.inactiveOrganisations.add(OrganisationFactory.getDefaultInactiveOrganisation());
        }
        this.expirationDate = new Date(System.currentTimeMillis() + (long)(expirationInMinutes * 60 * 1000));
    }

    private static String extractUsername(LoginContext loginContext) {
        Set<UserPrincipal> usernames;
        Subject subject = loginContext.getSubject();
        if (subject != null && !(usernames = subject.getPrincipals(UserPrincipal.class)).isEmpty()) {
            String username = usernames.iterator().next().getName();
            LOGGER.debug("Found username: {}", (Object)username);
            return username;
        }
        LOGGER.warn("Missing UserPrincipal");
        return "unknown";
    }

    @Override
    public void destroy() {
        LOGGER.debug("destroy");
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (LoginException e) {
            LOGGER.warn("destroy exception", (Throwable)e);
        }
    }

    protected BpcCallbackHandler getBpcCallbackHandler() {
        return this.bpcCallbackHandler;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public String getLoginName() {
        return this.username;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }
}

