/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.keycloak;

import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.auth.UserNotFoundException;
import de.virtimo.bpc.core.auth.keycloak.KeycloakApi;
import de.virtimo.bpc.core.auth.keycloak.KeycloakException;
import de.virtimo.bpc.core.utils.RestWebServiceClientInitException;
import de.virtimo.bpc.util.MapUtil;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeycloakAccountApi {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakAccountApi.class);

    public static void updateUserAttributes(String oidcDiscoveryUrl, UserSession userSession, String userId, Map<String, Object> userAttributes) throws UserNotFoundException, KeycloakException, ExecutionException, InterruptedException, RestWebServiceClientInitException, TimeoutException {
        LOGGER.info("updateUserAttributes oidcDiscoveryUrl={}, userSession={}, userId={}, userAttributes={}", (Object)oidcDiscoveryUrl, (Object)userSession, (Object)userId, userAttributes);
        KeycloakApi.doPostRequest(userSession, KeycloakAccountApi.getServerUrlFromOidcDiscoveryUrl(oidcDiscoveryUrl), null, MapUtil.mapOf("attributes", userAttributes, "firstName", userSession.getFirstName(), "lastName", userSession.getLastName(), "email", userSession.getEmail()));
    }

    static String getServerUrlFromOidcDiscoveryUrl(String oidcDiscoveryUrl) {
        return oidcDiscoveryUrl.substring(0, oidcDiscoveryUrl.indexOf("/realms/")) + "/realms/" + KeycloakApi.getRealmFromOidcDiscoveryUrl(oidcDiscoveryUrl) + "/account/";
    }
}

