/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.AccessTokenType;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.DPoPAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.LogoutRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import de.virtimo.bpc.api.ConnectionTestException;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.auth.InactiveOrganisation;
import de.virtimo.bpc.api.auth.Organisation;
import de.virtimo.bpc.api.auth.Right;
import de.virtimo.bpc.api.auth.Role;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.auth.idp.UserFlowIdentityProvider;
import de.virtimo.bpc.api.auth.idp.UserSessionRequest;
import de.virtimo.bpc.api.auth.jaas.BpcCallbackHandler;
import de.virtimo.bpc.api.exception.IdentityProviderException;
import de.virtimo.bpc.core.auth.IdentityProviderConfiguration;
import de.virtimo.bpc.core.auth.OrganisationFactory;
import de.virtimo.bpc.core.auth.RightFactory;
import de.virtimo.bpc.core.auth.RolesFactory;
import de.virtimo.bpc.core.auth.UnsupportedIdentityProviderOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.UserSessionImpl;
import de.virtimo.bpc.core.auth.idp.HttpUserSessionRequest;
import de.virtimo.bpc.core.auth.idp.IdentityProviderWithUnsupportedOperationsFallbackHandler;
import de.virtimo.bpc.core.auth.oidc.ClaimNameSplitter;
import de.virtimo.bpc.core.auth.oidc.OidcProviderMetadata;
import de.virtimo.bpc.core.auth.oidc.OidcUri;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.BpcTrustStore;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.UUIDGenerator;
import de.virtimo.bpc.util.UriQueryUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

public class OidcIdentityProvider
implements UserFlowIdentityProvider,
IdentityProviderWithUnsupportedOperationsFallbackHandler {
    private static final Logger LOGGER = LogManager.getLogger(OidcIdentityProvider.class);
    public static final String CONFIG_KEY = "oidc";
    public static final String USER_INFO_JWT_KEY = "oidcUserInfoJWT";
    public static final String USER_ID_JWT_KEY = "oidcUserIdJWT";
    public static final String OIDC_ACCESS_TOKEN = "oidc.accessToken";
    public static final String OIDC_TOKENS_REQUESTED_TIMESTAMP = "oidc.tokensRequestedTimestamp";
    public static final String OIDC_ID_TOKEN = "oidc.idToken";
    public static final String OIDC_ACCESS_TOKEN_EXPIRES_IN_SEC = "oidc.accessTokenExpiresInSec";
    public static final String OIDC_REFRESH_TOKEN = "oidc.refreshToken";
    public static final String OIDC_REFRESH_TOKEN_EXPIRES_IN_SEC = "oidc.refreshTokenExpiresInSec";
    public static final String CUSTOM_DATA_OIDC_USER_INFO = "oidc.userInfo";
    public static final String CUSTOM_DATA_OIDC_CLAIMS_SETS = "oidc.claimsSets";
    public static final String OIDC_PROVIDER_METADATA = "oidc.providerMetadata";
    private static State authState = new State();
    protected BundleContext bundleContext;
    private final OidcUri postAuthenticationRedirectUri;
    private final OidcUri postLogoutRedirectUri;
    protected final OidcProviderMetadata providerMetadata;
    private final ClientID clientID;
    private final Secret clientSecret;
    private final String scope;
    private final String claimNameRoles;
    private final String claimNameOrganisations;
    private final String claimNameRights;
    private final int sessionExpirationMinutes;
    protected UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler;

    public static void checkOidcConfiguration(IdentityProviderConfiguration configuration) throws IllegalArgumentException {
        if (configuration.getOidcMetadataDiscoveryUri() == null || configuration.getOidcMetadataDiscoveryUri().isEmpty()) {
            throw new IllegalArgumentException("Missing configuration 'identityProvider_oidc_metadataDiscoveryUri'");
        }
        if (configuration.getOidcPostAuthenticationRedirectUri() == null || configuration.getOidcPostAuthenticationRedirectUri().isEmpty()) {
            throw new IllegalArgumentException("Missing configuration 'identityProvider_oidc_postAuthenticationRedirectUri'");
        }
        if (configuration.getOidcPostLogoutRedirectUri() == null || configuration.getOidcPostLogoutRedirectUri().isEmpty()) {
            throw new IllegalArgumentException("Missing configuration 'identityProvider_oidc_postLogoutRedirectUri'");
        }
        if (StringUtil.isNullOrEmpty(configuration.getOidcClientId())) {
            throw new IllegalArgumentException("Missing configuration 'identityProvider_oidc_clientId'");
        }
        if (StringUtil.isNullOrEmpty(configuration.getOidcClientSecret())) {
            throw new IllegalArgumentException("Missing configuration 'identityProvider_oidc_clientSecret'");
        }
        if (StringUtil.isNullOrEmpty(configuration.getOidcScope())) {
            throw new IllegalArgumentException("Missing configuration 'identityProvider_oidc_scope'");
        }
        if (StringUtil.isNullOrEmpty(configuration.getOidcClaimNameRoles())) {
            throw new IllegalArgumentException("Missing configuration 'identityProvider_oidc_claimNameRoles'");
        }
    }

    public OidcIdentityProvider(BundleContext bundleContext, IdentityProviderConfiguration configuration, int sessionExpirationMinutes) throws URISyntaxException, IdentityProviderException, IllegalArgumentException {
        LOGGER.info("OidcIdentityProvider bundleContext=..., configuration={}, sessionExpirationMinutes={}", (Object)configuration, (Object)sessionExpirationMinutes);
        this.bundleContext = bundleContext;
        OidcIdentityProvider.checkOidcConfiguration(configuration);
        this.sessionExpirationMinutes = sessionExpirationMinutes;
        this.postAuthenticationRedirectUri = new OidcUri(configuration.getOidcPostAuthenticationRedirectUri());
        this.postLogoutRedirectUri = new OidcUri(configuration.getOidcPostLogoutRedirectUri());
        this.providerMetadata = new OidcProviderMetadata(configuration.getOidcMetadataDiscoveryUri());
        this.clientID = new ClientID(configuration.getOidcClientId());
        this.clientSecret = new Secret(configuration.getOidcClientSecret());
        this.scope = configuration.getOidcScope();
        this.claimNameRoles = configuration.getOidcClaimNameRoles();
        this.claimNameOrganisations = configuration.getOidcClaimNameOrganisations();
        this.claimNameRights = configuration.getOidcClaimNameRights();
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
    }

    @Override
    public void setUnsupportedIdentityProviderOperationsFallbackHandler(UnsupportedIdentityProviderOperationsFallbackHandler unsupportedIdentityProviderOperationsFallbackHandler) {
        this.unsupportedIdentityProviderOperationsFallbackHandler = unsupportedIdentityProviderOperationsFallbackHandler;
    }

    @Override
    public UnsupportedIdentityProviderOperationsFallbackHandler getUnsupportedIdentityProviderOperationsFallbackHandler() {
        return this.unsupportedIdentityProviderOperationsFallbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOwner(UserSession userSession) {
        if (userSession != null) {
            Map<String, Object> sensitiveCustomData;
            Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
            synchronized (map) {
                return sensitiveCustomData.containsKey(OIDC_PROVIDER_METADATA);
            }
        }
        return false;
    }

    @Override
    public UserSession checkSession(UserSession userSession, long sessionCheckIntervalInSeconds) throws IdentityProviderException {
        LOGGER.debug("checkSession userSession=..., sessionCheckIntervalInSeconds={}", (Object)sessionCheckIntervalInSeconds);
        this.refreshTokensWithFocusOnExpiredRefreshToken(userSession, sessionCheckIntervalInSeconds);
        return userSession;
    }

    @Override
    public UserSession login(String tenant, String username, String password) throws IdentityProviderException {
        return null;
    }

    @Override
    public UserSession login(BpcCallbackHandler bpcCallbackHandler) throws IdentityProviderException {
        return null;
    }

    @Override
    public UserSession updateSession(UserSession oldSession, String newTenant) throws IdentityProviderException {
        LOGGER.debug("updateSession oldSession=..., newTenant={}", (Object)newTenant);
        Organisation newTenantOrganisation = OrganisationFactory.getOrganisation(newTenant);
        if (oldSession.hasOrganisation(newTenant) || oldSession.getInactiveOrganisations().contains(newTenantOrganisation)) {
            HashSet<Organisation> organisationWhichShouldBeInactive = new HashSet<Organisation>();
            organisationWhichShouldBeInactive.addAll(oldSession.getOrganisations());
            organisationWhichShouldBeInactive.addAll(oldSession.getInactiveOrganisations());
            organisationWhichShouldBeInactive.remove(newTenantOrganisation);
            UserInfo userInfo = (UserInfo)oldSession.getSensitiveCustomData().get(CUSTOM_DATA_OIDC_USER_INFO);
            Set claimsSets = (Set)oldSession.getSensitiveCustomData().get(CUSTOM_DATA_OIDC_CLAIMS_SETS);
            UserSession userSession = this.createUserSession(oldSession.getSessionId(), userInfo, claimsSets, organisationWhichShouldBeInactive, newTenantOrganisation);
            userSession.getCustomData().putAll(oldSession.getCustomData());
            userSession.getSensitiveCustomData().putAll(oldSession.getSensitiveCustomData());
            return userSession;
        }
        return null;
    }

    @Override
    public void logout(String sessionId) throws IdentityProviderException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI createLogoutURI(UserSession userSession, HttpServletRequest request) throws IdentityProviderException {
        LOGGER.info("createLogoutURI userSession=..., request={}", (Object)request);
        String requestUrl = request.getRequestURL().toString();
        OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(requestUrl);
        URI endSessionEndpoint = oidcProviderMetadata.getEndSessionEndpointURI();
        JWT idToken = null;
        if (userSession != null) {
            Map<String, Object> sensitiveCustomData;
            Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
            synchronized (map) {
                idToken = (JWT)sensitiveCustomData.get(OIDC_ID_TOKEN);
            }
        }
        URI postRedirectUri = this.postLogoutRedirectUri.getURIforRequestUrl(requestUrl);
        String bpcLanguageFromHeader = request.getHeader("X-BPC-Language");
        if (!StringUtil.isNullOrEmpty(bpcLanguageFromHeader)) {
            postRedirectUri = UriBuilder.fromUri((URI)postRedirectUri).queryParam("oidc_login_lang", new Object[]{bpcLanguageFromHeader}).build(new Object[0]);
        }
        ArrayList<LangTag> langTags = new ArrayList<LangTag>();
        try {
            langTags.add(LangTag.parse((String)bpcLanguageFromHeader));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to parse bpc language header to Nimbus LangTag", (Throwable)e);
        }
        LogoutRequest logoutRequest = new LogoutRequest(endSessionEndpoint, idToken, null, null, postRedirectUri, null, langTags);
        return logoutRequest.toURI();
    }

    @Override
    public boolean canUpdateUserPasswords() throws IdentityProviderException {
        return false;
    }

    @Override
    public void updateUserPassword(String userName, String oldPassword, String newPassword) throws IdentityProviderException {
        throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_UNSUPPORTED_OPERATION, "CORE_ERROR_IDENTITY_PROVIDER_UNSUPPORTED_OPERATION");
    }

    @Override
    public UserSession requestUserSession(UserSessionRequest userSessionRequest) throws IdentityProviderException {
        UserSession userSession;
        block3: {
            LOGGER.debug("requestUserSession userSessionRequest=...");
            if (!(userSessionRequest instanceof HttpUserSessionRequest)) {
                throw new IllegalArgumentException("only support HttpUserSessionRequest");
            }
            HttpUserSessionRequest httpUserSessionRequest = (HttpUserSessionRequest)userSessionRequest;
            userSession = null;
            try {
                userSession = this.checkAuthenticationResponse(httpUserSessionRequest.getUri());
            }
            catch (IdentityProviderException | URISyntaxException e) {
                LOGGER.info("failed to check oidp redirected uri", (Throwable)e);
                if (!(e instanceof IdentityProviderException)) break block3;
                IdentityProviderException ie = (IdentityProviderException)e;
                if (!ie.isErrorCode(CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR)) break block3;
                throw ie;
            }
        }
        return userSession;
    }

    @Override
    public URI createAuthenticationRequestURI(String requestUrl) throws IdentityProviderException {
        LOGGER.info("createAuthenticationRequestURI requestUrl={}", (Object)requestUrl);
        return this._createAuthenticationRequestURI(this.postAuthenticationRedirectUri.getURIforRequestUrl(requestUrl), requestUrl);
    }

    @Override
    public URI createAuthenticationRequestURIWithRedirect(String requestUrl) throws IdentityProviderException {
        LOGGER.info("createAuthenticationRequestURIWithRedirect requestUrl={}", (Object)requestUrl);
        URI redirectUri = this.postAuthenticationRedirectUri.getURIforRequestUrl(requestUrl);
        if (redirectUri.getScheme().equals("https") && requestUrl.startsWith("http://")) {
            requestUrl = requestUrl.replaceFirst("http://", "https://");
        }
        if (requestUrl.startsWith(redirectUri.toString())) {
            try {
                redirectUri = new URIBuilder(redirectUri).setParameter("redirectPostAuth", requestUrl).build();
            }
            catch (URISyntaxException uriEx) {
                LOGGER.error("Failed setting up redirectPostAuth param. Proceed without setting up a redirect", (Throwable)uriEx);
            }
        } else {
            LOGGER.warn("Cannot set up redirectPostAuth param as redirect URL ({}) does not seem to be a BPC url. (Base BPC redirect url: {})", (Object)requestUrl, (Object)redirectUri);
        }
        return this._createAuthenticationRequestURI(redirectUri, requestUrl);
    }

    private URI _createAuthenticationRequestURI(URI postAuthRedirectUri, String requestUrl) throws IdentityProviderException {
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(this.providerMetadata.getOIDCProviderMetadataForRequestUrl(requestUrl).getAuthorizationEndpointURI(), new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), Scope.parse((String)this.scope), this.clientID, postAuthRedirectUri, authState, new Nonce());
        return authenticationRequest.toURI();
    }

    @Override
    public UserSession checkAuthenticationResponse(URI responseUri) throws IdentityProviderException {
        LOGGER.info("checkAuthenticationResponse responseURI=...");
        OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(responseUri.toString());
        AuthorizationCode authCode = this.extractAuthCode(responseUri);
        OIDCTokenResponse accessTokenResponse = this.fetchAccessTokenByUsingAuthorizationCode(authCode, responseUri, oidcProviderMetadata);
        return this.createUserSession(accessTokenResponse, oidcProviderMetadata);
    }

    private AuthorizationCode extractAuthCode(URI responseURI) throws IdentityProviderException {
        LOGGER.info("extractAuthCode responseURI=...");
        try {
            AuthenticationResponse authResp = AuthenticationResponseParser.parse((URI)responseURI);
            if (authResp instanceof AuthenticationErrorResponse) {
                LOGGER.warn("Found AuthenticationErrorResponse");
                ErrorObject error = ((AuthenticationErrorResponse)authResp).getErrorObject();
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "Auth response error: " + error.getCode() + " - " + error.getDescription());
            }
            AuthenticationSuccessResponse authSuccessResponse = (AuthenticationSuccessResponse)authResp;
            if (authSuccessResponse.getState() == null || !authSuccessResponse.getState().equals((Object)authState)) {
                LOGGER.warn("Found auth state mismatch. Expected state: " + String.valueOf(authState) + " - received state: " + String.valueOf(authSuccessResponse.getState()));
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_AUTH_FLOW_ERROR, "State not valid");
            }
            return authSuccessResponse.getAuthorizationCode();
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_RESPONSE_INVALID, "Failed to parse the authentication response.", e);
        }
    }

    private OIDCTokenResponse fetchAccessTokenByUsingAuthorizationCode(AuthorizationCode authCode, URI responseURI, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOGGER.info("fetchAccessTokenByUsingAuthorizationCode authCode=..., responseURI=..., oidcProviderMetadata=...");
        URI redirectUriToCheck = this.postAuthenticationRedirectUri.getURIforRequestUrl(responseURI.toString());
        try {
            String themeName = UriQueryUtil.getQueryParams(responseURI).get("theme");
            if (!StringUtil.isNullOrEmpty(themeName)) {
                redirectUriToCheck = new URIBuilder(redirectUriToCheck).setParameter("theme", themeName).build();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to perform the BPC-5215 theme hack. Should not happen, but I must catch the exceptions.", (Throwable)ex);
        }
        try {
            String language = UriQueryUtil.getQueryParams(responseURI).get("language");
            if (!StringUtil.isNullOrEmpty(language)) {
                redirectUriToCheck = new URIBuilder(redirectUriToCheck).setParameter("language", language).build();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to perform the BPC-5656 language hack. Should not happen, but I must catch the exceptions.", (Throwable)ex);
        }
        try {
            String postAuthRedirectUri = UriQueryUtil.getQueryParams(responseURI).get("redirectPostAuth");
            if (!StringUtil.isNullOrEmpty(postAuthRedirectUri)) {
                redirectUriToCheck = new URIBuilder(redirectUriToCheck).setParameter("redirectPostAuth", postAuthRedirectUri).build();
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to perform the BPC-7723 setting up redirectPostAuth param", (Throwable)ex);
        }
        return this._fetchAccessToken((AuthorizationGrant)new AuthorizationCodeGrant(authCode, redirectUriToCheck), oidcProviderMetadata);
    }

    private OIDCTokenResponse fetchAccessTokenByUsingRefreshToken(RefreshToken refreshToken, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOGGER.info("fetchAccessTokenByUsingRefreshToken refreshToken=..., oidcProviderMetadata=...");
        return this._fetchAccessToken((AuthorizationGrant)new RefreshTokenGrant(refreshToken), oidcProviderMetadata);
    }

    protected OIDCTokenResponse _fetchAccessToken(AuthorizationGrant tokenGrant, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOGGER.info("_fetchAccessToken tokenGrant=..., oidcProviderMetadata=...");
        try {
            TokenRequest tokenReq = new TokenRequest(oidcProviderMetadata.getTokenEndpointURI(), (ClientAuthentication)new ClientSecretBasic(this.clientID, this.clientSecret), tokenGrant);
            HTTPRequest tokenHttpRequest = tokenReq.toHTTPRequest();
            try {
                BpcTrustStore.getInstance().setTo(tokenHttpRequest);
            }
            catch (Exception ex) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_VIRTIMO_TRUSTSTORE_ERROR, "Failed to use the BPC trust store.", ex);
            }
            HTTPResponse tokenHTTPResp = tokenHttpRequest.send();
            LOGGER.info("Token response:...");
            TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenHTTPResp);
            if (tokenResponse instanceof TokenErrorResponse) {
                LOGGER.info("Found TokenErrorResponse");
                ErrorObject error = ((TokenErrorResponse)tokenResponse).getErrorObject();
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "Token response error: " + error.getCode() + " - " + error.getDescription());
            }
            return (OIDCTokenResponse)tokenResponse;
        }
        catch (SerializeException | IOException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "Failed to perform token request.", e);
        }
        catch (com.nimbusds.oauth2.sdk.ParseException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_TOKEN_ERROR, "Failed to parse the token response.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTokensWithFocusOnExpiredAccessToken(UserSession userSession) throws IdentityProviderException {
        Map<String, Object> sensitiveCustomData;
        LOGGER.info("refreshTokensWithFocusOnExpiredAccessToken userSession=...");
        Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
        synchronized (map) {
            long tokenRequestedTimestamp = (Long)sensitiveCustomData.get(OIDC_TOKENS_REQUESTED_TIMESTAMP);
            Number accessTokenExpiresInSec = (Number)sensitiveCustomData.get(OIDC_ACCESS_TOKEN_EXPIRES_IN_SEC);
            if (this.willTokenExpireSoon(tokenRequestedTimestamp, accessTokenExpiresInSec, 15L)) {
                this.refreshAccessToken(userSession);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTokensWithFocusOnExpiredRefreshToken(UserSession userSession, long sessionCheckIntervallInSeconds) throws IdentityProviderException {
        Map<String, Object> sensitiveCustomData;
        LOGGER.info("refreshTokensWithFocusOnExpiredRefreshToken userSession=..., sessionCheckIntervallInSeconds={}", (Object)sessionCheckIntervallInSeconds);
        Map<String, Object> map = sensitiveCustomData = userSession.getSensitiveCustomData();
        synchronized (map) {
            long tokenRequestedTimestamp = (Long)sensitiveCustomData.get(OIDC_TOKENS_REQUESTED_TIMESTAMP);
            Number refreshTokenExpiresInSec = (Number)sensitiveCustomData.get(OIDC_REFRESH_TOKEN_EXPIRES_IN_SEC);
            if (this.willTokenExpireSoon(tokenRequestedTimestamp, refreshTokenExpiresInSec, 15L + sessionCheckIntervallInSeconds)) {
                this.refreshAccessToken(userSession);
            }
        }
    }

    private boolean willTokenExpireSoon(long tokenRequestedTimestamp, Number tokenExpiresInSeconds, long bufferInSeconds) {
        return System.currentTimeMillis() + bufferInSeconds * 1000L >= tokenRequestedTimestamp + tokenExpiresInSeconds.longValue() * 1000L;
    }

    private void refreshAccessToken(UserSession userSession) throws IdentityProviderException {
        LOGGER.info("refreshAccessToken userSession=...");
        Map<String, Object> sensitiveCustomData = userSession.getSensitiveCustomData();
        OIDCProviderMetadata oidcProviderMetadata = (OIDCProviderMetadata)sensitiveCustomData.get(OIDC_PROVIDER_METADATA);
        RefreshToken refreshToken = (RefreshToken)sensitiveCustomData.get(OIDC_REFRESH_TOKEN);
        OIDCTokenResponse tokenResponse = this.fetchAccessTokenByUsingRefreshToken(refreshToken, oidcProviderMetadata);
        this.keepTokenResponseInUserSession(userSession, tokenResponse);
    }

    protected UserSession createUserSession(OIDCTokenResponse accessTokenResponse, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOGGER.info("createUserSession accessTokenResponse=..., oidcProviderMetadata=...");
        AccessToken accessToken = accessTokenResponse.getTokens().getAccessToken();
        return this.createUserSession(accessToken, accessTokenResponse, oidcProviderMetadata);
    }

    protected UserSession createUserSession(AccessToken accessToken, OIDCTokenResponse accessTokenResponse, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOGGER.info("createUserSession accessToken=..., sessionId=..., accessTokenResponse=..., oidcProviderMetadata=...");
        String sessionId = UUIDGenerator.randomUUID();
        UserInfoSuccessResponse userInfoResponse = this.fetchUserInfo(accessToken, oidcProviderMetadata);
        UserInfo userInfo = this.extractUserInfo(userInfoResponse);
        JWT idToken = null;
        if (accessTokenResponse != null) {
            idToken = accessTokenResponse.getTokens().toOIDCTokens().getIDToken();
        }
        HashSet<JWTClaimsSet> claimsSets = new HashSet<JWTClaimsSet>();
        try {
            if (accessToken != null) {
                claimsSets.add(JWTParser.parse((String)accessToken.getValue()).getJWTClaimsSet());
            }
            if (idToken != null) {
                claimsSets.add(idToken.getJWTClaimsSet());
            }
        }
        catch (ParseException e) {
            LOGGER.info("failed to parse token claims", (Throwable)e);
        }
        UserSession userSession = this.createUserSession(sessionId, userInfo, claimsSets, null, null);
        userSession.getSensitiveCustomData().put(OIDC_PROVIDER_METADATA, oidcProviderMetadata);
        userSession.getSensitiveCustomData().put(CUSTOM_DATA_OIDC_USER_INFO, userInfo);
        userSession.getSensitiveCustomData().put(CUSTOM_DATA_OIDC_CLAIMS_SETS, claimsSets);
        if (accessTokenResponse != null) {
            this.keepTokenResponseInUserSession(userSession, accessTokenResponse);
        }
        this.keepUserInfoAsJWTInUserSession(userSession, userInfo, userInfoResponse);
        return userSession;
    }

    @NotNull
    private UserSession createUserSession(String sessionId, UserInfo userInfo, Set<JWTClaimsSet> claimsSets, Set<Organisation> organisationsWhichShouldBeInactive, Organisation explicitActiveOrganisation) {
        LOGGER.info("Create UserSession");
        Date expirationDate = this.getSessionExpirationDate();
        Set<Role> roles = this.extractRoles(this.claimNameRoles, userInfo, claimsSets);
        Set<Organisation> organisations = this.extractOrganisations(this.claimNameOrganisations, userInfo, claimsSets);
        if (explicitActiveOrganisation != null) {
            organisations.add(explicitActiveOrganisation);
        }
        HashSet<InactiveOrganisation> inactiveOrganisations = new HashSet<InactiveOrganisation>();
        if (organisationsWhichShouldBeInactive != null && !organisationsWhichShouldBeInactive.isEmpty()) {
            for (Organisation organisationWhichShouldBeInactive : organisationsWhichShouldBeInactive) {
                inactiveOrganisations.add(OrganisationFactory.getInactiveOrganisation(organisationWhichShouldBeInactive.getName()));
                organisations.remove(organisationWhichShouldBeInactive);
            }
        }
        Set<Right> rights = this.extractRights(this.claimNameRights, userInfo, claimsSets);
        HashMap<String, List<String>> principals = new HashMap<String, List<String>>();
        String loginName = this.getUsername(userInfo);
        UserSessionImpl userSession = UserSessionImpl.UserSessionImplBuilder.newInstance().withSessionId(sessionId).withFirstName(userInfo.getGivenName()).withLastName(userInfo.getFamilyName()).withLoginName(loginName).withEmail(userInfo.getEmailAddress()).withExpirationDate(expirationDate).withOrganisations(organisations).withInactiveOrganisations(inactiveOrganisations).withRoles(roles).withRights(rights).withPrincipals(principals).build();
        userSession.getCustomData().put("locale", userInfo.getLocale());
        userSession.getCustomData().put("picture", userInfo.getPicture());
        return userSession;
    }

    private UserInfoSuccessResponse fetchUserInfo(AccessToken accessToken, OIDCProviderMetadata oidcProviderMetadata) throws IdentityProviderException {
        LOGGER.info("fetchUserInfo accessToken=..., oidcProviderMetadata=...");
        try {
            UserInfoRequest userInfoReq = new UserInfoRequest(oidcProviderMetadata.getUserInfoEndpointURI(), accessToken);
            HTTPRequest userInfoHttpRequest = userInfoReq.toHTTPRequest();
            try {
                BpcTrustStore.getInstance().setTo(userInfoHttpRequest);
            }
            catch (Exception ex) {
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_VIRTIMO_TRUSTSTORE_ERROR, "Failed to use the Virtimo trust store.", ex);
            }
            HTTPResponse userInfoHTTPResp = userInfoHttpRequest.send();
            LOGGER.info("User info response: {}", (Object)userInfoHTTPResp.getContent());
            UserInfoResponse userInfoResponse = UserInfoResponse.parse((HTTPResponse)userInfoHTTPResp);
            if (userInfoResponse instanceof UserInfoErrorResponse) {
                LOGGER.info("Found UserInfoErrorResponse");
                ErrorObject error = ((UserInfoErrorResponse)userInfoResponse).getErrorObject();
                throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_UNAUTHORIZED, "User info response error: " + error.getCode() + " - " + error.getDescription());
            }
            return (UserInfoSuccessResponse)userInfoResponse;
        }
        catch (com.nimbusds.oauth2.sdk.ParseException ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_RESPONSE_INVALID, "Failed to parse the user info response.", ex);
        }
        catch (SerializeException | IOException e) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.IDENTITY_PROVIDER_AUTH_FLOW_ERROR, "Failed to perform the user info request.", e);
        }
    }

    private UserInfo extractUserInfo(UserInfoSuccessResponse userInfoSuccessResponse) throws IdentityProviderException {
        LOGGER.info("extractUserInfo userInfoSuccessResponse=...");
        try {
            UserInfo userInfo = userInfoSuccessResponse.getUserInfo();
            if (userInfo == null && userInfoSuccessResponse.getUserInfoJWT() != null) {
                userInfo = new UserInfo(userInfoSuccessResponse.getUserInfoJWT().getJWTClaimsSet());
            }
            return userInfo;
        }
        catch (ParseException ex) {
            throw new IdentityProviderException((ErrorCode)CoreErrorCode.AUTHENTICATION_RESPONSE_INVALID, "Failed to parse the user info success response.", ex);
        }
    }

    private void keepTokenResponseInUserSession(UserSession userSession, OIDCTokenResponse accessTokenResponse) {
        LOGGER.info("keepTokenResponseInUserSession userSession=..., accessTokenResponse=...");
        long tokensRequestedTimestamp = System.currentTimeMillis();
        JWT idToken = accessTokenResponse.getOIDCTokens().getIDToken();
        AccessToken accessToken = accessTokenResponse.getTokens().getAccessToken();
        Number accessTokenExpiresInSeconds = accessTokenResponse.toJSONObject().getAsNumber("expires_in");
        RefreshToken refreshToken = accessTokenResponse.getTokens().getRefreshToken();
        Number refreshTokenExpiresInSeconds = accessTokenResponse.toJSONObject().getAsNumber("refresh_expires_in");
        Map<String, Object> sensitiveCustomData = userSession.getSensitiveCustomData();
        sensitiveCustomData.put(OIDC_ID_TOKEN, idToken);
        sensitiveCustomData.put(OIDC_TOKENS_REQUESTED_TIMESTAMP, tokensRequestedTimestamp);
        sensitiveCustomData.put(OIDC_ACCESS_TOKEN, accessToken);
        sensitiveCustomData.put(OIDC_ACCESS_TOKEN_EXPIRES_IN_SEC, accessTokenExpiresInSeconds);
        sensitiveCustomData.put(OIDC_REFRESH_TOKEN, refreshToken);
        sensitiveCustomData.put(OIDC_REFRESH_TOKEN_EXPIRES_IN_SEC, refreshTokenExpiresInSeconds);
        try {
            Object impersonatorClaimObject = SignedJWT.parse((String)accessToken.getValue()).getJWTClaimsSet().getClaim("impersonator");
            if (impersonatorClaimObject instanceof Map) {
                userSession.getCustomData().put("impersonator", new HashMap((Map)impersonatorClaimObject));
            } else if (impersonatorClaimObject != null) {
                LOGGER.error("When you see this log message, then please inform the BPC developers that the 'impersonatorClaimObject' type has been changed and must be adjusted.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set the impersonator ... {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void keepUserInfoAsJWTInUserSession(UserSession userSession, UserInfo userInfo, UserInfoSuccessResponse userInfoSuccessResponse) {
        if (userInfoSuccessResponse.getUserInfoJWT() != null) {
            userSession.getCustomData().put(USER_INFO_JWT_KEY, userInfoSuccessResponse.getUserInfoJWT().serialize());
        } else {
            try {
                userSession.getCustomData().put(USER_INFO_JWT_KEY, new PlainJWT(userInfo.toJWTClaimsSet()).serialize());
            }
            catch (com.nimbusds.oauth2.sdk.ParseException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Set<Role> extractRoles(String claimNameRolesToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOGGER.info("extractRoles claimNameRolesToExtract={}, userInfo=...", (Object)claimNameRolesToExtract);
        HashSet<Role> roles = new HashSet<Role>();
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            roles.addAll(this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRoles(this.getUsername(userInfo)));
        }
        for (String roleName : OidcIdentityProvider.extractFromClaim(claimNameRolesToExtract, userInfo, claimsSets)) {
            roles.add(RolesFactory.getRole(roleName));
        }
        return roles;
    }

    private Set<Organisation> extractOrganisations(String claimNameOrganisationsToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOGGER.info("extractOrganisations claimNameOrganisationsToExtract={}, userInfo=...", (Object)claimNameOrganisationsToExtract);
        HashSet<Organisation> organisations = new HashSet<Organisation>();
        organisations.add(OrganisationFactory.getDefaultOrganisation());
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            organisations.addAll(this.unsupportedIdentityProviderOperationsFallbackHandler.getUserOrganisations(this.getUsername(userInfo)));
        }
        for (String orgName : OidcIdentityProvider.extractFromClaim(claimNameOrganisationsToExtract, userInfo, claimsSets)) {
            organisations.add(OrganisationFactory.getOrganisation(orgName));
        }
        return organisations;
    }

    private Set<Right> extractRights(String claimNameRightsToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOGGER.info("extractRights claimNameRightsToExtract={}, userInfo=...", (Object)claimNameRightsToExtract);
        HashSet<Right> rights = new HashSet<Right>();
        if (this.unsupportedIdentityProviderOperationsFallbackHandler != null) {
            rights.addAll(this.unsupportedIdentityProviderOperationsFallbackHandler.getUserRights(this.getUsername(userInfo)));
        }
        for (String rightName : OidcIdentityProvider.extractFromClaim(claimNameRightsToExtract, userInfo, claimsSets)) {
            rights.add(RightFactory.getRight(rightName));
        }
        return rights;
    }

    protected static Set<String> extractFromClaim(String claimNameToExtract, UserInfo userInfo, Set<JWTClaimsSet> claimsSets) {
        LOGGER.info("extractFromClaim claimNameToExtract={}, userInfo=..., claimsSets=...", (Object)claimNameToExtract);
        HashSet<String> values = new HashSet<String>();
        List<String> claimNames = StringUtil.explode(claimNameToExtract, ",");
        if (claimNames != null) {
            for (String claimName : claimNames) {
                List<String> splittedClaimNames = ClaimNameSplitter.splitClaimNameWithDots(claimName);
                if (userInfo != null) {
                    Object current = null;
                    for (String splittedClaimName : splittedClaimNames) {
                        List<String> claimValues;
                        if (current == null) {
                            current = userInfo.getClaim(splittedClaimName);
                            if (current == null) {
                                break;
                            }
                        } else if (current instanceof JSONObject) {
                            JSONObject jsonObject = (JSONObject)current;
                            current = jsonObject.get((Object)splittedClaimName);
                        }
                        if (current instanceof JSONArray) {
                            claimValues = JSONArrayUtils.toStringList((JSONArray)((JSONArray)current));
                            values.addAll((Collection<String>)claimValues);
                            continue;
                        }
                        if (!(current instanceof String)) continue;
                        claimValues = StringUtil.explode((String)current, ",");
                        values.addAll(claimValues);
                    }
                }
                if (claimsSets == null) continue;
                block2: for (JWTClaimsSet claimSet : claimsSets) {
                    Object current = null;
                    for (String splittedClaimName : splittedClaimNames) {
                        if (current == null) {
                            current = claimSet.getClaim(splittedClaimName);
                            if (current == null) {
                                continue block2;
                            }
                        } else if (current instanceof Map) {
                            Map jsonObject = (Map)current;
                            current = jsonObject.get(splittedClaimName);
                        }
                        if (current instanceof List) {
                            for (Object roleName : (List)current) {
                                values.add(roleName.toString());
                            }
                            continue;
                        }
                        if (!(current instanceof String)) continue;
                        List<String> claimValues = StringUtil.explode((String)current, ",");
                        values.addAll(claimValues);
                    }
                }
            }
        }
        return values;
    }

    @Override
    public URI getPostAuthenticationRedirectUri(String requestUrl) {
        LOGGER.info("getPostAuthenticationRedirectUri requestUrl={}", (Object)requestUrl);
        return this.postAuthenticationRedirectUri.getURIforRequestUrl(requestUrl);
    }

    protected Date getSessionExpirationDate() {
        LOGGER.info("getSessionExpirationDate");
        return this.getSessionExpirationDateFromIdpBackendConnectionSetting();
    }

    protected Date getSessionExpirationDateFromIdpBackendConnectionSetting() {
        LOGGER.info("Using the idp backend connection session expiration value: {} minutes", (Object)this.sessionExpirationMinutes);
        return Timestamp.valueOf(LocalDateTime.now().plusMinutes(this.sessionExpirationMinutes));
    }

    private String getUsername(UserInfo userInfo) {
        String loginName = userInfo.getPreferredUsername();
        if (loginName == null) {
            if (userInfo.getEmailAddress() != null) {
                LOGGER.warn("Didn't got a preferred_username from IdP - Using email address");
                loginName = userInfo.getEmailAddress();
            } else if (userInfo.getStringClaim("sub") != null && userInfo.getStringClaim("sub").length() > 0) {
                LOGGER.warn("Didn't got a preferred_username or email from IdP - Using sub");
                loginName = userInfo.getStringClaim("sub");
            } else {
                LOGGER.error("Didn't got a any id for the user from IdP - this should never happen!");
                loginName = Integer.toString(userInfo.hashCode());
            }
        }
        return loginName;
    }

    public UserSession getUserInfo(HttpServletRequest req, String accessTokenType, String accessToken) throws IdentityProviderException {
        LOGGER.info("getUserInfo req=..., accessTokenType={}, accessToken=...", (Object)accessTokenType);
        Object token = AccessTokenType.BEARER.getValue().equalsIgnoreCase(accessTokenType) ? new BearerAccessToken(accessToken) : (AccessTokenType.DPOP.getValue().equalsIgnoreCase(accessTokenType) ? new DPoPAccessToken(accessToken) : new TypelessAccessToken(accessToken));
        OIDCProviderMetadata oidcProviderMetadata = this.providerMetadata.getOIDCProviderMetadataForRequestUrl(req.getRequestURL().toString());
        return this.createUserSession((AccessToken)token, null, oidcProviderMetadata);
    }

    public void performConnectionTest() throws ConnectionTestException {
        LOGGER.info("performConnectionTest");
    }
}

