/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.auth.oidc;

import de.virtimo.bpc.core.auth.oidc.OidcUriPattern;
import de.virtimo.bpc.util.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OidcUri {
    private final URI single;
    private final List<OidcUriPattern> patterns;

    public OidcUri(Object configValue) throws URISyntaxException {
        if (configValue instanceof List) {
            Object e;
            List configValueAsList = (List)configValue;
            if (configValueAsList.size() == 1 && (e = configValueAsList.get(0)) instanceof Map) {
                Map patternMap = (Map)e;
                this.single = new URI(String.valueOf(patternMap.get("uri")));
                this.patterns = null;
            } else {
                this.single = null;
                this.patterns = this.createOidcRedirectPatterns(configValueAsList);
            }
        } else {
            this.single = new URI(String.valueOf(configValue).trim());
            this.patterns = null;
        }
    }

    public boolean isSingle() {
        return this.single != null;
    }

    public Set<URI> getURIs() {
        HashSet<URI> result = new HashSet<URI>();
        if (this.single != null) {
            result.add(this.single);
        } else if (this.patterns != null) {
            for (OidcUriPattern pattern : this.patterns) {
                result.add(pattern.getURI());
            }
        }
        return result;
    }

    private List<OidcUriPattern> createOidcRedirectPatterns(List<?> patterns) throws URISyntaxException {
        ArrayList<OidcUriPattern> result = new ArrayList<OidcUriPattern>();
        for (Object patternObject : patterns) {
            Map patternMap;
            if (!(patternObject instanceof Map) || !(patternMap = (Map)patternObject).containsKey("pattern") || !patternMap.containsKey("uri")) continue;
            result.add(new OidcUriPattern(String.valueOf(patternMap.get("pattern")), String.valueOf(patternMap.get("uri"))));
        }
        return result;
    }

    public URI getURIforRequestUrl(String url) {
        if (this.patterns != null) {
            if (!StringUtil.isNullOrEmpty(url)) {
                for (OidcUriPattern pattern : this.patterns) {
                    if (!url.matches(pattern.getRegEx())) continue;
                    return pattern.getURI();
                }
            }
        } else {
            return this.single;
        }
        return null;
    }
}

