/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.backup;

import de.virtimo.bpc.api.backup.BackupSnapshotInfo;
import de.virtimo.bpc.api.backup.SnapshotName;
import de.virtimo.bpc.core.opensearch.migration.BpcIndicesMigrator;
import de.virtimo.bpc.opensearch.plugin.dto.BackupSnapshotInfoDTO;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotState;

public class BackupSnapshotInfoImpl
implements BackupSnapshotInfo {
    private final SnapshotName snapshotName;
    private final Instant startTime;
    private final SnapshotState state;
    private final List<String> indices;
    private final boolean bpcConfigurationIndex;
    private Integer indexModelVersion;

    public BackupSnapshotInfoImpl(SnapshotInfo snapshotInfo) {
        this.snapshotName = SnapshotName.parse(snapshotInfo.snapshotId().getName());
        this.startTime = this.snapshotName.getCreatedDate();
        this.state = snapshotInfo.state();
        this.indices = snapshotInfo.indices();
        this.bpcConfigurationIndex = snapshotInfo.indices() != null && snapshotInfo.indices().size() == 1 && snapshotInfo.indices().get(0).startsWith("bpc-configuration");
        this.indexModelVersion = null;
    }

    public BackupSnapshotInfoImpl(SnapshotName snapshotName, Instant startTime, SnapshotState state, List<String> indices, boolean bpcConfigurationIndex) {
        this.snapshotName = snapshotName;
        this.startTime = startTime;
        this.state = state;
        this.indices = indices;
        this.bpcConfigurationIndex = bpcConfigurationIndex;
        this.indexModelVersion = null;
    }

    public BackupSnapshotInfoImpl(BackupSnapshotInfoDTO backupSnapshotInfoDTO) {
        this.snapshotName = SnapshotName.parse(backupSnapshotInfoDTO.getSnapshotName());
        this.startTime = backupSnapshotInfoDTO.getStartTime();
        this.state = backupSnapshotInfoDTO.getState();
        this.indices = backupSnapshotInfoDTO.getIndices();
        this.bpcConfigurationIndex = backupSnapshotInfoDTO.isBpcConfigurationIndex();
        this.indexModelVersion = null;
    }

    @Override
    public SnapshotName getSnapshotName() {
        return this.snapshotName;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public long getStartTimeInMillis() {
        return this.startTime.toEpochMilli();
    }

    @Override
    public SnapshotState getState() {
        return this.state;
    }

    @Override
    public List<String> getIndices() {
        return this.indices;
    }

    @Override
    public boolean isBpcConfigurationIndex() {
        return this.bpcConfigurationIndex;
    }

    @Override
    public boolean hasIndexModelVersion() {
        return this.indexModelVersion != null;
    }

    @Override
    public Integer getIndexModelVersion() {
        return this.indexModelVersion;
    }

    @Override
    public void setIndexModelVersion(Integer indexModelVersion) {
        this.indexModelVersion = indexModelVersion;
    }

    @Override
    public Boolean isBpcConfigurationIndexRestorable() {
        if (!this.isBpcConfigurationIndex()) {
            return null;
        }
        if (!this.hasIndexModelVersion()) {
            return false;
        }
        if (this.getIndexModelVersion() < BpcIndicesMigrator.getLowestSupportedModelVersionOfBpcConfigurationIndex()) {
            return false;
        }
        if (this.getIndexModelVersion() > BpcIndicesMigrator.getCurrentModelVersionOfBpcConfigurationIndex()) {
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BackupSnapshotInfoImpl that = (BackupSnapshotInfoImpl)o;
        return this.bpcConfigurationIndex == that.bpcConfigurationIndex && Objects.equals(this.snapshotName, that.snapshotName) && Objects.equals(this.startTime, that.startTime) && this.state == that.state && Objects.equals(this.indices, that.indices) && Objects.equals(this.indexModelVersion, that.indexModelVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotName, this.startTime, this.state, this.indices, this.bpcConfigurationIndex, this.indexModelVersion});
    }

    public String toString() {
        return "BackupSnapshotInfoImpl{snapshotName=" + String.valueOf(this.snapshotName) + ", startTime=" + String.valueOf(this.startTime) + ", state=" + String.valueOf((Object)this.state) + ", indices=" + String.valueOf(this.indices) + ", bpcConfigurationIndex=" + this.bpcConfigurationIndex + ", indexModelVersion=" + this.indexModelVersion + "}";
    }
}

