/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.datalock;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.util.MapUtil;

public class DataLockItemNotFoundException
extends SystemException {
    private final String itemId;
    private final String indexName;

    public DataLockItemNotFoundException(String itemId, String indexName) {
        super((ErrorCode)CoreErrorCode.DATA_LOCK_ITEM_NOT_FOUND, "Did not find the data lock item '${itemId}' in the index '${indexName}'.", MapUtil.mapOf("itemId", itemId, "indexName", indexName));
        this.itemId = itemId;
        this.indexName = indexName;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getIndexName() {
        return this.indexName;
    }
}

