/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.fewrapper;

import de.virtimo.bpc.api.ModuleConfiguration;
import de.virtimo.bpc.api.ModuleInstance;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.core.fewrapper.FeWrapperModuleInstance;
import de.virtimo.bpc.module.AbstractInstantiableModule;
import de.virtimo.bpc.module.ModuleConfigurationBuilder;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;

public class FeWrapperModule
extends AbstractInstantiableModule {
    private static final Logger LOGGER = LogManager.getLogger(FeWrapperModule.class);
    private final Bundle frontendBundle;
    private final String id;
    private final String name;
    private final String[] supportedInstanceTypes;

    public FeWrapperModule(ModuleManager moduleManager, Bundle frontendBundle) {
        super(moduleManager);
        LOGGER.debug("FeWrapperModule");
        if (!FeWrapperModule.isFeOnlyBundle(frontendBundle).booleanValue()) {
            LOGGER.error("Missing Bundle header BPC-Bundle-Type=fe-only");
            throw new IllegalArgumentException("Bundle is no BPC Frontend only bundle: " + frontendBundle.getSymbolicName());
        }
        this.id = frontendBundle.getHeaders().get("BPC-Bundle-Id") != null ? (String)frontendBundle.getHeaders().get("BPC-Bundle-Id") : String.valueOf(frontendBundle.getBundleId());
        LOGGER.debug("ID: {}", (Object)this.id);
        this.name = frontendBundle.getHeaders().get("Bundle-Name") != null ? String.valueOf(frontendBundle.getHeaders().get("Bundle-Name")) : frontendBundle.getSymbolicName();
        LOGGER.debug("Name: {}", (Object)this.name);
        if (frontendBundle.getHeaders().get("BPC-Instance-Types") != null) {
            this.supportedInstanceTypes = String.valueOf(frontendBundle.getHeaders().get("BPC-Instance-Types")).split(",");
            LOGGER.debug("Found some instance types:{}", (Object)Arrays.toString(this.supportedInstanceTypes));
        } else {
            this.supportedInstanceTypes = null;
        }
        this.frontendBundle = frontendBundle;
        this.setModuleBundle(frontendBundle);
    }

    @Override
    public ModuleConfiguration getDefaultConfiguration() {
        LOGGER.debug("getDefaultConfiguration");
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).addSettingsFromFile(this.getModuleBundle(), "resources/defaults/default_module_settings.json").build();
    }

    @Override
    public String getModuleId() {
        LOGGER.debug("getModuleId");
        return this.id;
    }

    @Override
    public String getModuleName() {
        LOGGER.debug("getModuleName");
        return this.name;
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration() {
        LOGGER.debug("getDefaultInstanceConfiguration");
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).addSettingsFromFile(this.getModuleBundle(), "resources/defaults/default_instance_settings.json").build();
    }

    @Override
    public ModuleConfiguration getDefaultInstanceConfiguration(String instanceType) {
        LOGGER.debug("getDefaultInstanceConfiguration instanceType={}", (Object)instanceType);
        Object settingsFilePath = StringUtil.isNullOrEmpty(instanceType) || "none".equalsIgnoreCase(instanceType) ? "resources/defaults/default_instance_settings.json" : "resources/defaults/default_instance_settings_" + instanceType + ".json";
        return ModuleConfigurationBuilder.newInstance().withModuleId(this.getModuleId()).withInstanceId(null).withInstanceType(instanceType).addSettingsFromFile(this.getModuleBundle(), (String)settingsFilePath).build();
    }

    @Override
    public Class<? extends ModuleInstance> getModuleInstanceClass() {
        LOGGER.debug("getModuleInstanceClass");
        return FeWrapperModuleInstance.class;
    }

    @Override
    public String[] getSupportedInstanceTypes() {
        LOGGER.debug("getSupportedInstanceTypes");
        return this.supportedInstanceTypes;
    }

    public static Boolean isFeOnlyBundle(Bundle bundle) {
        LOGGER.debug("isFeOnlyBundle");
        if (bundle == null) {
            return false;
        }
        return "fe-only".equalsIgnoreCase(String.valueOf(bundle.getHeaders().get("BPC-Bundle-Type")));
    }
}

