/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.core.filestorage.FileStorageConfiguration;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;

public class FileStorageSettingValidator
implements SettingValidator {
    private static final Logger LOGGER = LogManager.getLogger(FileStorageSettingValidator.class);
    private BundleContext bundleContext;

    public FileStorageSettingValidator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public void destroy() {
        LOGGER.info("destroy");
    }

    @Override
    public boolean canValidate(String moduleId, String moduleInstanceId, String instanceType) {
        return "backendconnection".equalsIgnoreCase(moduleId) && "file_storage".equalsIgnoreCase(instanceType);
    }

    @Override
    public boolean canValidate(Setting setting) {
        if (!"file_storage".equalsIgnoreCase(setting.getInstanceType())) {
            return false;
        }
        List<String> settingsToValidate = Arrays.asList("fileStorageEndpointUrl");
        return settingsToValidate.contains(setting.getName());
    }

    @Override
    public List<FrontendWarningException> validate(Setting setting) throws ValidationException {
        LOGGER.info("validate setting:{}", (Object)setting);
        if (!setting.getName().equalsIgnoreCase("fileStorageEndpointUrl")) {
            return null;
        }
        String s3BaseUrl = (String)setting.getValue();
        if (StringUtil.isNullOrEmpty(s3BaseUrl)) {
            return null;
        }
        if (s3BaseUrl.matches("^https?://([a-zA-Z0-9\\-.]+)(:\\d{1,5})?$")) {
            return null;
        }
        throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "${field}: The File Storage Endpoint must either me empty or of format (http|https)://url(:PORT).", MapUtil.mapOf("field", "fileStorageEndpointUrl"));
    }

    @Override
    public List<FrontendWarningException> validate(String moduleId, String moduleInstanceId, String instanceType, Map<String, Setting> settings) throws ValidationException {
        LOGGER.info("validate moduleId={}, moduleInstanceId={}, instanceType={}, settings:...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        FileStorageConfiguration configuration = new FileStorageConfiguration(settings);
        String endpoint = configuration.getEndpoint();
        String region = configuration.getRegion();
        if (StringUtil.isNullOrEmpty(endpoint) && StringUtil.isNullOrEmpty(region)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_MISSING_INPUT, "At least one of the following information needs to be provided: {fieldEndpoint} or {fieldRegion}", MapUtil.mapOf("fieldEndpoint", "fileStorageEndpointUrl", "fieldRegion", "fileStorageCloudRegion"));
        }
        try (S3Client s3Client = configuration.buildS3Client();){
            ListBucketsResponse listBucketsResponse = s3Client.listBuckets();
        }
        catch (Throwable ex) {
            throw new ValidationException((ErrorCode)BpcErrorCode.FILE_STORAGE_CONNECTION_VALIDATION_FAILED, "Could not connect to S3 (compatible) storage:\n{message}", MapUtil.mapOf("message", ex.getMessage()));
        }
        return null;
    }
}

