/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.filestorage;

import de.virtimo.bpc.api.filestorage.FileStoreItem;
import de.virtimo.bpc.api.filestorage.FileStoreItemPutDto;
import de.virtimo.bpc.api.filestorage.ObjectStoreReference;
import de.virtimo.bpc.core.ItemRestrictionFactory;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.time.ZonedDateTime;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileStoreItemFactory {
    private FileStoreItemFactory() {
    }

    public static FileStoreItem create(String id, Map<String, Object> openSearchSource) {
        ZonedDateTime creationDate = null;
        Object creationDateEntry = openSearchSource.get("creationDate");
        if (creationDateEntry instanceof String) {
            String strCreationDate = (String)creationDateEntry;
            creationDate = ZonedDateTime.parse(strCreationDate);
        }
        ZonedDateTime modificationDate = null;
        Object modificationDateEntry = openSearchSource.get("modificationDate");
        if (modificationDateEntry instanceof String) {
            String strModificationDate = (String)modificationDateEntry;
            modificationDate = ZonedDateTime.parse(strModificationDate);
        }
        return FileStoreItem.withId(id).withFilename(MapUtil.getValueAsString(openSearchSource, "filename", null)).withContentType(MapUtil.getValueAsString(openSearchSource, "contentType", null)).withChecksumCrc32(MapUtil.getValueAsString(openSearchSource, "checksumCrc32", null)).withFilesize(MapUtil.getValueAsLong(openSearchSource, "filesize", 0L)).withCreationDate(creationDate).withModificationDate(modificationDate).withCreator(MapUtil.getValueAsString(openSearchSource, "creator", null)).withCreatorServiceId(MapUtil.getValueAsString(openSearchSource, "creatorServiceId", null)).withObjectStoreReference(ObjectStoreReferenceFactory.create(MapUtil.getValueAsMap(openSearchSource, "objectStoreReference", null))).withReadRestriction(ItemRestrictionFactory.create(MapUtil.getValueAsMap(openSearchSource, "readRestriction", null))).withWriteRestriction(ItemRestrictionFactory.create(MapUtil.getValueAsMap(openSearchSource, "writeRestriction", null))).build();
    }

    public static FileStoreItem createUpdatedFileItem(@NotNull FileStoreItem fileStoreItem, FileStoreItemPutDto putDto) {
        if (putDto == null) {
            return fileStoreItem;
        }
        FileStoreItem.FileStoreItemBuilder builder = FileStoreItem.withId(fileStoreItem.getId()).withFilesize(fileStoreItem.getFilesize()).withContentType(fileStoreItem.getContentType()).withChecksumCrc32(fileStoreItem.getChecksumCrc32()).withCreationDate(fileStoreItem.getCreationDate()).withModificationDate(ZonedDateTime.now()).withCreator(fileStoreItem.getCreator()).withCreatorServiceId(fileStoreItem.getCreatorServiceId()).withObjectStoreReference(fileStoreItem.getObjectStoreReference());
        builder = StringUtil.isNullOrEmpty(putDto.filename) ? builder.withFilename(fileStoreItem.getFilename()) : builder.withFilename(putDto.filename);
        builder = putDto.readRestriction == null ? builder.withReadRestriction(fileStoreItem.getReadRestriction()) : builder.withReadRestriction(putDto.readRestriction);
        builder = putDto.writeRestriction == null ? builder.withWriteRestriction(fileStoreItem.getWriteRestriction()) : builder.withWriteRestriction(putDto.writeRestriction);
        return builder.build();
    }

    public static FileStoreItem createUpdatedFileItem(@NotNull FileStoreItem fileStoreItem, String filename, String contentType, long fileSize, String crc32) {
        FileStoreItem.FileStoreItemBuilder builder = FileStoreItem.withId(fileStoreItem.getId()).withCreationDate(fileStoreItem.getCreationDate()).withCreator(fileStoreItem.getCreator()).withCreatorServiceId(fileStoreItem.getCreatorServiceId()).withObjectStoreReference(fileStoreItem.getObjectStoreReference()).withReadRestriction(fileStoreItem.getReadRestriction()).withWriteRestriction(fileStoreItem.getWriteRestriction()).withFilename(filename).withContentType(contentType).withModificationDate(ZonedDateTime.now()).withFilesize(fileSize).withChecksumCrc32(crc32);
        return builder.build();
    }

    static final class Field {
        static final String Filename = "filename";
        static final String ContentType = "contentType";
        static final String ChecksumCrc32 = "checksumCrc32";
        static final String Filesize = "filesize";
        static final String CreationDate = "creationDate";
        static final String ModificationDate = "modificationDate";
        static final String Creator = "creator";
        static final String CreatorServiceId = "creatorServiceId";
        static final String ObjectStoreReference = "objectStoreReference";
        static final String ReadRestriction = "readRestriction";
        static final String WriteRestriction = "writeRestriction";

        Field() {
        }
    }

    private static class ObjectStoreReferenceFactory {
        private ObjectStoreReferenceFactory() {
        }

        public static ObjectStoreReference create(Map<String, Object> source) {
            if (source == null) {
                return null;
            }
            String connectionId = MapUtil.getValueAsString(source, "backendConnectionId", null);
            String bucket = MapUtil.getValueAsString(source, "bucket", null);
            String fileKey = MapUtil.getValueAsString(source, "fileKey", null);
            return new ObjectStoreReference(connectionId, bucket, fileKey);
        }

        static final class Field {
            static final String FileStorageBackendConnectionId = "backendConnectionId";
            static final String Bucket = "bucket";
            static final String FileKey = "fileKey";

            Field() {
            }
        }
    }
}

