/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.httpproxy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.action.ActionPayload;
import de.virtimo.bpc.api.action.ActionResult;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.HttpProxyException;
import de.virtimo.bpc.api.exception.ModuleInstanceNotFoundException;
import de.virtimo.bpc.api.exception.ModuleNotFoundException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.ActionService;
import de.virtimo.bpc.api.service.HttpProxyService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class HttpProxyActionServiceImpl
implements ActionService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(HttpProxyActionServiceImpl.class);
    private final BundleContext bundleContext;
    private final BpcServicesTracker<HttpProxyService> httpProxyServiceTracker;

    public HttpProxyActionServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.httpProxyServiceTracker = new BpcServicesTracker<HttpProxyService>(bundleContext, HttpProxyService.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ActionResult startAction(String actionIdentifier, String bpcUrl, UserSession userSession, ActionPayload payload, HttpHeaders headers) throws ServiceNotFoundException, JsonProcessingException, ModuleNotFoundException, ModuleInstanceNotFoundException, HttpProxyException {
        String proxyInstanceId = this.extractFromUrl(bpcUrl, ExtractionMode.INSTANCE_ID);
        String targetPath = this.extractFromUrl(bpcUrl, ExtractionMode.REMAINING_PATH);
        ObjectMapper objectMapper = new ObjectMapper();
        byte[] body = objectMapper.writeValueAsBytes((Object)payload);
        try (Response response = this.httpProxyServiceTracker.getService().doPost(proxyInstanceId, targetPath, null, null, headers, userSession, body);){
            String msg;
            Map json = (Map)objectMapper.readValue((InputStream)response.getEntity(), Map.class);
            String string = json.get("message") != null ? json.get("message").toString() : (msg = json.get("msg") != null ? json.get("msg").toString() : "");
            if (response.getStatus() >= 200 && response.getStatus() < 300) {
                ActionResult actionResult2 = ActionResult.success(msg, json);
                return actionResult2;
            }
            ActionResult actionResult = ActionResult.failure(msg);
            return actionResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ActionResult stopAction(String referenceId, UserSession userSession, JsonNode payload) {
        return null;
    }

    private String extractFromUrl(String bpcUrl, ExtractionMode mode) {
        if (bpcUrl == null || bpcUrl.isBlank()) {
            throw new IllegalArgumentException("Missing bpcUrl.");
        }
        Pattern pattern = Pattern.compile("bpc://[^/]+/([^/]+)(?:/(.*))?");
        Matcher matcher = pattern.matcher(bpcUrl);
        if (matcher.find()) {
            switch (mode.ordinal()) {
                case 0: {
                    return matcher.group(1);
                }
                case 1: {
                    return matcher.group(2) != null ? matcher.group(2) : "";
                }
            }
            throw new IllegalArgumentException("Unsupported ExtractionMode: " + String.valueOf((Object)mode));
        }
        throw new IllegalArgumentException("Invalid bpcUrl: " + bpcUrl);
    }

    private static enum ExtractionMode {
        INSTANCE_ID,
        REMAINING_PATH;

    }
}

