/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.multipart;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.virtimo.bpc.api.multipart.MimeMultipartData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class MimeMultipartDataImpl
implements MimeMultipartData {
    private String boundary;
    private byte[] bodyBytes;

    private MimeMultipartDataImpl() {
    }

    @JsonIgnore
    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getBoundary() {
        return this.boundary;
    }

    @Override
    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    @Override
    @JsonIgnore
    public String getContentType() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    public static class Builder {
        private String boundary;
        private Charset charset = StandardCharsets.UTF_8;
        private List<MimedFile> files = new ArrayList<MimedFile>();
        private Map<String, String> texts = new LinkedHashMap<String, String>();

        private Builder() {
            this.boundary = new BigInteger(128, new Random()).toString();
        }

        public Builder withCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder withBoundary(String boundary) {
            this.boundary = boundary;
            return this;
        }

        public Builder addFile(String name, Path path, String mimeType) {
            this.files.add(new MimedFile(name, path, mimeType));
            return this;
        }

        public Builder addText(String name, String text) {
            this.texts.put(name, text);
            return this;
        }

        public MimeMultipartData build() throws IOException {
            MimeMultipartDataImpl mimeMultipartData = new MimeMultipartDataImpl();
            mimeMultipartData.boundary = this.boundary;
            byte[] newline = "\r\n".getBytes(this.charset);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            for (MimedFile mimedFile : this.files) {
                byteArrayOutputStream.write(("--" + this.boundary).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(("Content-Disposition: form-data; name=\"" + mimedFile.name + "\"; filename=\"" + String.valueOf(mimedFile.path.getFileName()) + "\"").getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(("Content-Type: " + mimedFile.mimeType).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(Files.readAllBytes(mimedFile.path));
                byteArrayOutputStream.write(newline);
            }
            for (Map.Entry entry : this.texts.entrySet()) {
                byteArrayOutputStream.write(("--" + this.boundary).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"").getBytes(this.charset));
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(newline);
                byteArrayOutputStream.write(((String)entry.getValue()).getBytes(this.charset));
                byteArrayOutputStream.write(newline);
            }
            byteArrayOutputStream.write(("--" + this.boundary + "--").getBytes(this.charset));
            mimeMultipartData.bodyBytes = byteArrayOutputStream.toByteArray();
            return mimeMultipartData;
        }

        public class MimedFile {
            public final String name;
            public final Path path;
            public final String mimeType;

            public MimedFile(String name, Path path, String mimeType) {
                this.name = name;
                this.path = path;
                this.mimeType = mimeType;
            }
        }
    }
}

