/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.core.notification.NotificationData;
import de.virtimo.bpc.core.notification.dtos.NotificationGetDto;
import de.virtimo.bpc.core.notification.dtos.NotificationPostDto;
import de.virtimo.bpc.util.SetUtil;
import de.virtimo.bpc.util.StringUtil;
import de.virtimo.bpc.util.ZonedDateTimeSerializer;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;

public class Notification {
    public static final String TYPE_INFO = "info";
    public static final String TYPE_LINK = "link";
    public static final String RECIPIENTS_TYPE_USER = "user";
    public static final String RECIPIENTS_TYPE_ROLE = "role";
    public static final String RECIPIENTS_TYPE_ORGANISATION = "organisation";
    public static final Set<String> ValidRecipientsTypes = SetUtil.setOf("user", "role", "organisation");
    private final String id;
    private final long version;
    private final int priority;
    private final ZonedDateTime date;
    private final ZonedDateTime validUntil;
    private final String subject;
    private final String message;
    private final Set<String> recipients;
    private final String recipientsType;
    private final String originator;
    private final String icon;
    private final String type;
    private final Map<String, Object> linkData;
    private final Set<String> readByUserIds;
    private final String topic;

    private Notification(Builder notificationBuilder) {
        this.id = notificationBuilder.id;
        this.version = notificationBuilder.version;
        this.priority = notificationBuilder.priority;
        this.date = notificationBuilder.date;
        this.validUntil = notificationBuilder.validUntil;
        this.subject = notificationBuilder.subject;
        this.message = notificationBuilder.message;
        this.recipients = notificationBuilder.recipients;
        this.recipientsType = notificationBuilder.recipientsType;
        this.originator = notificationBuilder.originator;
        this.icon = notificationBuilder.icon;
        this.type = notificationBuilder.type;
        this.linkData = notificationBuilder.linkData;
        this.readByUserIds = notificationBuilder.readByUserIds;
        this.topic = notificationBuilder.topic;
    }

    public String getId() {
        return this.id;
    }

    public long getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority;
    }

    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    public ZonedDateTime getDate() {
        return this.date;
    }

    @JsonSerialize(using=ZonedDateTimeSerializer.class)
    public ZonedDateTime getValidUntil() {
        return this.validUntil;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<String> getRecipients() {
        return this.recipients;
    }

    public String getRecipientsType() {
        return this.recipientsType;
    }

    public String getOriginator() {
        return this.originator;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getType() {
        return this.type;
    }

    public Map<String, Object> getLinkData() {
        return this.linkData;
    }

    public Set<String> getReadByUserIds() {
        return this.readByUserIds;
    }

    public boolean isReadByUser(String userId) {
        return this.readByUserIds.contains(userId);
    }

    public void setReadByUser(String userId, boolean read) {
        if (read) {
            this.addReadByUser(userId);
        } else {
            this.removeReadByUser(userId);
        }
    }

    public void addReadByUser(String userId) {
        this.readByUserIds.add(userId);
    }

    public void removeReadByUser(String userId) {
        this.readByUserIds.remove(userId);
    }

    public String getTopic() {
        return this.topic;
    }

    @JsonIgnore
    public boolean hasAccessRight(UserSession userSession) {
        if (userSession != null) {
            if (RECIPIENTS_TYPE_USER.equals(this.recipientsType)) {
                for (String recipient : this.recipients) {
                    if (!recipient.equalsIgnoreCase(userSession.getLoginName())) continue;
                    return true;
                }
                return false;
            }
            if (RECIPIENTS_TYPE_ROLE.equals(this.recipientsType)) {
                return userSession.hasAnyRole(this.recipients);
            }
            if (RECIPIENTS_TYPE_ORGANISATION.equals(this.recipientsType)) {
                return userSession.hasAnyOrganisation(this.recipients);
            }
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "Notification{id='" + this.id + "', version=" + this.version + ", priority=" + this.priority + ", date=" + String.valueOf(this.date) + ", validUntil=" + String.valueOf(this.validUntil) + ", subject='" + this.subject + "', message='" + this.message + "', recipients='" + String.valueOf(this.recipients) + "', recipientsType='" + this.recipientsType + "', originator='" + this.originator + "', icon='" + this.icon + "', type='" + this.type + "', linkData=" + String.valueOf(this.linkData) + ", readByUserIds=" + String.valueOf(this.readByUserIds) + ", topic='" + this.topic + "'}";
    }

    public NotificationGetDto toGetDto() {
        NotificationGetDto getDto = new NotificationGetDto();
        getDto.id = this.id;
        getDto.version = this.version;
        getDto.priority = this.priority;
        getDto.date = this.date;
        getDto.validUntil = this.validUntil;
        getDto.subject = this.subject;
        getDto.message = this.message;
        getDto.recipients = new HashSet<String>(this.recipients);
        getDto.recipientsType = this.recipientsType;
        getDto.originator = this.originator;
        getDto.icon = this.icon;
        getDto.type = this.type;
        getDto.linkData = this.linkData;
        getDto.isRead = false;
        getDto.topic = this.topic;
        return getDto;
    }

    @JsonIgnore
    public NotificationGetDto toGetDto(String getterUserName) {
        NotificationGetDto getDto = this.toGetDto();
        getDto.isRead = this.readByUserIds.contains(getterUserName);
        if (Objects.equals(getDto.recipientsType, RECIPIENTS_TYPE_USER)) {
            getDto.recipients = new HashSet<String>();
        }
        return getDto;
    }

    @JsonIgnore
    public Notification getRedactedNotificationForBroadcasting() {
        if (!RECIPIENTS_TYPE_USER.equals(this.recipientsType)) {
            return this;
        }
        Builder builder = new Builder(this);
        builder.recipients = new HashSet<String>();
        return builder.build();
    }

    public static class Builder {
        private String id;
        private long version;
        private Integer priority;
        private ZonedDateTime date;
        private ZonedDateTime validUntil;
        private String subject;
        private String message;
        private Set<String> recipients;
        private String recipientsType;
        private Boolean sendOnlyToOnlineUsers;
        private List<ClientSession> clientSessions;
        private String originator;
        private String icon;
        private String type;
        private Map<String, Object> linkData;
        private Set<String> readByUserIds;
        private String topic;

        public Builder(Notification notification) {
            this.id = this.getNewIdIfNotSet(notification.id);
            this.version = this.getInitialVersionIfNotSet(notification.version);
            this.priority = notification.priority;
            this.date = this.getCurrentDateTimeIfNotSet(notification.date);
            this.validUntil = notification.validUntil;
            this.subject = notification.subject;
            this.message = notification.message;
            this.recipients = notification.recipients;
            this.recipientsType = notification.recipientsType;
            this.sendOnlyToOnlineUsers = false;
            this.originator = notification.originator;
            this.icon = notification.icon;
            this.type = this.getDefaultTypeIfNotSet(notification.type);
            this.linkData = notification.linkData == null ? null : new HashMap<String, Object>(notification.linkData);
            this.readByUserIds = notification.readByUserIds;
            this.topic = notification.topic;
        }

        public Builder(NotificationData notificationData) {
            this.id = this.getNewIdIfNotSet(notificationData.id);
            this.version = this.getInitialVersionIfNotSet(notificationData.version);
            this.priority = notificationData.priority;
            this.date = this.getCurrentDateTimeIfNotSet(notificationData.date);
            this.validUntil = notificationData.validUntil == null ? null : notificationData.validUntil;
            this.subject = notificationData.subject;
            this.message = notificationData.message;
            this.recipients = notificationData.recipients;
            this.recipientsType = notificationData.recipientsType;
            this.sendOnlyToOnlineUsers = false;
            this.originator = notificationData.originator;
            this.icon = notificationData.icon;
            this.type = this.getDefaultTypeIfNotSet(notificationData.type);
            this.linkData = notificationData.linkData == null ? null : new HashMap<String, Object>(notificationData.linkData);
            this.readByUserIds = notificationData.readByUserIds == null ? new HashSet() : notificationData.readByUserIds;
            this.topic = notificationData.topic;
        }

        public Builder(NotificationPostDto notificationPostDto) {
            this.id = this.getNewIdIfNotSet(notificationPostDto.id);
            this.version = this.getInitialVersionIfNotSet(0L);
            this.priority = notificationPostDto.priority;
            this.date = this.getCurrentDateTimeIfNotSet(null);
            this.validUntil = this.getValidUntilDateTimeIfSet(this.date, notificationPostDto.validitySeconds);
            this.subject = notificationPostDto.subject;
            this.message = notificationPostDto.message;
            this.recipients = notificationPostDto.recipients;
            this.recipientsType = notificationPostDto.recipientsType;
            this.sendOnlyToOnlineUsers = notificationPostDto.sendOnlyToOnlineUsers;
            this.originator = notificationPostDto.originator;
            this.icon = notificationPostDto.icon;
            this.type = this.getDefaultTypeIfNotSet(notificationPostDto.type);
            this.linkData = notificationPostDto.linkData == null ? null : new HashMap<String, Object>(notificationPostDto.linkData);
            this.readByUserIds = new HashSet<String>();
            this.topic = notificationPostDto.topic;
        }

        public Builder() {
            this.id = this.getNewIdIfNotSet(null);
            this.version = this.getInitialVersionIfNotSet(-1L);
            this.priority = null;
            this.date = this.getCurrentDateTimeIfNotSet(null);
            this.validUntil = null;
            this.originator = null;
            this.type = this.getDefaultTypeIfNotSet(null);
            this.topic = "";
            this.readByUserIds = new HashSet<String>();
            this.sendOnlyToOnlineUsers = false;
        }

        private String getNewIdIfNotSet(String id) {
            return StringUtil.isNullOrEmpty(id) ? UUID.randomUUID().toString() : id;
        }

        private String getDefaultTypeIfNotSet(String type) {
            return StringUtil.isNullOrEmpty(type) ? Notification.TYPE_INFO : type;
        }

        private long getInitialVersionIfNotSet(long version) {
            return version < 1L ? 1L : version;
        }

        private ZonedDateTime getCurrentDateTimeIfNotSet(ZonedDateTime date) {
            return date == null ? ZonedDateTime.now() : date;
        }

        private ZonedDateTime getValidUntilDateTimeIfSet(ZonedDateTime date, Long validitySeconds) {
            if (date == null || validitySeconds == null || validitySeconds == 0L) {
                return null;
            }
            return date.plusSeconds(validitySeconds);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder priority(Priority priority) {
            this.priority = priority.value;
            return this;
        }

        public Builder date(ZonedDateTime date) {
            this.date = date;
            return this;
        }

        public Builder validUntil(ZonedDateTime validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder recipients(Set<String> recipients, String recipientsType) {
            this.recipients = recipients;
            this.recipientsType = recipientsType;
            return this;
        }

        public Builder originator(String originator) {
            this.originator = originator;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public Builder type(String type, Map<String, Object> linkData) {
            this.type = type;
            this.linkData = linkData;
            return this;
        }

        public Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder clientSessions(List<ClientSession> clientSessions) {
            this.clientSessions = clientSessions;
            return this;
        }

        private void setRecipientsToOnlineUsers() {
            if (Boolean.FALSE.equals(this.sendOnlyToOnlineUsers)) {
                return;
            }
            if (this.clientSessions == null) {
                throw new IllegalStateException("If sendOnlyToOnlineUsers is set clientSessions must be set as well.");
            }
            HashSet<String> userNameMatches = new HashSet<String>();
            for (ClientSession clientSession : this.clientSessions) {
                UserSession userSession;
                if (clientSession.getWebsocketSessions().isEmpty() || (userSession = clientSession.getUserSession()) == null || !this.isRecipientFilterMatch(userSession)) continue;
                userNameMatches.add(userSession.getLoginName());
            }
            this.recipients = userNameMatches;
            this.recipientsType = Notification.RECIPIENTS_TYPE_USER;
        }

        private boolean isRecipientFilterMatch(UserSession userSession) {
            return switch (this.recipientsType) {
                case Notification.RECIPIENTS_TYPE_ROLE -> userSession.hasAnyRole(this.recipients);
                case Notification.RECIPIENTS_TYPE_ORGANISATION -> userSession.hasAnyOrganisation(this.recipients);
                case Notification.RECIPIENTS_TYPE_USER -> this.recipients.contains(userSession.getLoginName());
                default -> false;
            };
        }

        public Notification build() {
            if (this.originator == null) {
                throw new IllegalStateException("Originator must not be null.");
            }
            if (this.type == null) {
                throw new IllegalStateException("Type must not be null.");
            }
            if (this.subject == null) {
                throw new IllegalStateException("Subject must not be null.");
            }
            if (this.recipients == null || this.recipientsType == null) {
                throw new IllegalStateException("Recipients and recipients type must not be null.");
            }
            if (Boolean.TRUE.equals(this.sendOnlyToOnlineUsers)) {
                this.setRecipientsToOnlineUsers();
            }
            if (this.priority == null) {
                this.priority = Priority.TOAST.value;
            } else if (!SetUtil.setOf(Priority.SILENT.value, Priority.TOAST.value, Priority.POPUP.value).contains(this.priority)) {
                throw new IllegalStateException("Priority must be one of the following: " + Priority.SILENT.value + " (Silent), " + Priority.TOAST.value + " (Toast), " + Priority.POPUP.value + " (Popup)");
            }
            if (!ValidRecipientsTypes.contains(this.recipientsType.toLowerCase())) {
                throw new IllegalStateException("Recipients type must be one of the following: " + String.valueOf(ValidRecipientsTypes));
            }
            return new Notification(this);
        }
    }

    public static enum Priority {
        SILENT(0),
        TOAST(5),
        POPUP(10);

        public final int value;

        private Priority(int value) {
            this.value = value;
        }
    }
}

