/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.Notifications;
import de.virtimo.bpc.core.notification.dtos.NotificationPostDto;
import de.virtimo.bpc.core.notification.dtos.NotificationsMarkReadStatusPostDto;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.BpcUserSessionRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="notification")
@Tag(name="Notification API", description="These are the notification endpoints.")
public class NotificationEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(NotificationEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<NotificationManager> notificationManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerBpcServicesTracker;

    public NotificationEndpoint(BundleContext bundleContext) {
        LOGGER.info("NotificationEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.notificationManagerTracker = new BpcServicesTracker<NotificationManager>(this.bundleContext, NotificationManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.clientSessionManagerBpcServicesTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @OperationDescription(summary="Add a notification.", description="To add a notification, send a JSON message with the following structure:\n\n.Minimal example\n[source,json]\n----\n{\n   \"subject\": \"Replication problem\",\n   \"message\": \"The database 'postgresql' is not reachable\",\n   \"recipients\": [ \"bpcadmin\" ],\n   \"recipientsType\": \"role\"\n}\n----\n\n.More complex example\n[source,json]\n----\n{\n     \"priority\": 10,\n     \"subject\": \"API expires soon\",\n     \"message\": \"API Key API-39e889a expires soon. Please contact your administrator.\",\n     \"recipients\": [ \"bpcadmin\" ],\n     \"recipientsType\": \"role\",\n     \"validitySeconds\": 3600,\n     \"icon\": \"fa-file-certificate\",\n     \"type\": \"warning\",\n     \"linkData\": {\n         \"navigation\": \"/_nav/!-1&/module/_core/_core///_core/apiKeys/api/[\\\"API-39e889a\\\"]\"\n     },\n     \"topic\": \"TOPIC_APIKEY_EXPIRATION\"\n}\n----\n\n**Fields**\n\n`id` (optional) :: ID of the notification. A random UUID gets set when not given.\n`priority` (optional) :: Delivery priority of the notification. Can be one of the following values: 0 (Silent), 5 (Toast), 10 (Popup). 5 gets used when not given.\n`subject` (required) :: The subject of the notification.\n`message` (optional) :: The message of the notification.\n`recipients` (required) :: The recipients of the notification. Depends on the used `recipientsType`.\n`recipientsType` (required) :: The recipients type of the notification. Can be one of the following values: `user`, `role` or `organisation`.\n`originator` (optional) :: The originator of the notification. The login name of the user session gets used when not given.\n`validitySeconds` :: The number of seconds the notification is valid.\n`icon` (optional) :: The Font Awesome icon which should be used when showing the notification.\n`type` (optional) :: The type of the notification. The type 'info' gets used when not given. Other possibility are 'warn' and 'error'. Depending on the type, the notification is displayed accordingly in the GUI (see also xref:core:dev/notification_type_view.adoc[]).\n`linkData` (optional) :: Optionally specifies link information for navigation within BPC or to an external URL. You may provide either a `url` field for an external link or a `navigation` field containing the hash segment of a BPC URL.\n`topic` (optional) :: The notification topic\n")
    @ReturnDescription(value="The added notification as JSON. Contains additionally the 'date' and 'version' fields which get automatically set/updated.")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_ADD", message="Not allowed to add notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response addNotification(@Context HttpHeaders hh, @Context UserSession userSession, NotificationPostDto postData) {
        LOGGER.info("addNotification");
        try {
            Notification notification;
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification.Builder notificationBuilder = new Notification.Builder(postData).originator(postData.originator == null ? userSession.getLoginName() : postData.originator);
            if (Boolean.TRUE.equals(postData.sendOnlyToOnlineUsers)) {
                try {
                    ClientSessionManager sessionManager = this.clientSessionManagerBpcServicesTracker.getService();
                    List<ClientSession> allSessions = sessionManager.getAllSessions();
                    notificationBuilder.clientSessions(allSessions);
                }
                catch (Exception ex) {
                    LOGGER.error("Exception while getting the list of online users. (sendOnlyToOnlineUsers = true)", (Throwable)ex);
                    return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
                }
            }
            try {
                notification = notificationBuilder.build();
            }
            catch (Exception ex) {
                throw new SystemException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, ex.getMessage());
            }
            Notification addedNotification = notificationManager.addNotification(notification);
            return Response.ok((Object)addedNotification.toGetDto(userSession.getLoginName())).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to add notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Update a notification.", description="To update a notification, send a JSON message with the following structure:\n\n.Minimal example\n[source,json]\n----\n{\n   \"subject\": \"Replication problem\",\n   \"message\": \"The database 'postgresql' is not reachable\",\n   \"recipients\": [ \"bpcadmin\" ],\n   \"recipientsType\": \"role\"\n}\n----\n\n.More complex example\n[source,json]\n----\n{\n     \"priority\": 10,\n     \"subject\": \"API expires soon\",\n     \"message\": \"API Key API-39e889a expires soon. Please contact your administrator.\",\n     \"recipients\": [ \"bpcadmin\" ],\n     \"recipientsType\": \"role\",\n     \"icon\": \"fa-file-certificate\",\n     \"type\": \"warning\",\n     \"linkData\": {\n         \"navigation\": \"/_nav/!-1&/module/_core/_core///_core/apiKeys/api/[\\\"API-39e889a\\\"]\"\n     }\n}\n----\n\n**Fields**\n\n`priority` (optional) :: Delivery priority of the notification. Can be one of the following values: 0 (Silent), 5 (Toast), 10 (Popup). 5 gets used when not given.\n`subject` (required) :: The subject of the notification.\n`message` (optional) :: The message of the notification.\n`recipients` (required) :: The recipients of the notification. Depends on the used `recipientsType`.\n`recipientsType` (required) :: The recipients type of the notification. Can be one of the following values: `user`, `role` or `organisation`.\n`originator` (optional) :: The originator of the notification. The login name of the user session gets used when not given.\n`icon` (optional) :: The Font Awesome icon which should be used when showing the notification.\n`type` (optional) :: The type of the notification. The type 'info' gets used when not given. Other possibility are 'warn' and 'error'. Depending on the type, the notification is displayed accordingly in the GUI (see also xref:core:dev/notification_type_view.adoc[]).\n`linkData` (optional) :: Optionally specifies link information for navigation within BPC or to an external URL. You may provide either a `url` field for an external link or a `navigation` field containing the hash segment of a BPC URL.\n")
    @ReturnDescription(value="The updated notification as JSON. Contains additionally the 'date' and 'version' fields which get automatically set/updated.")
    @PUT
    @Path(value="/{notificationId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_UPDATE", message="Not allowed to update notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response updateNotification(@Parameter(description="the ID of the notification to update") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession, NotificationPostDto postData) {
        LOGGER.info("updateNotification notificationId={}", (Object)notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = new Notification.Builder(postData).id(notificationId).originator(postData.originator == null ? userSession.getLoginName() : postData.originator).build();
            Notification updatedNotification = notificationManager.updateNotification(notification);
            return Response.ok((Object)updatedNotification.toGetDto(userSession.getLoginName())).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to update notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_DELETE", message="Not allowed to delete notifications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* Required service was not found\n* Requested notification was not found\n"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="Delete a specific notification.", description="Delete a specific notification.")
    @ReturnDescription(value="The deleted notification as JSON.")
    public Response deleteNotification(@Parameter(description="the ID of the notification to delete") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("deleteNotification notificationId={}", (Object)notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification deletedNotification = notificationManager.deleteNotificationById(notificationId);
            return Response.ok((Object)deletedNotification.toGetDto(userSession.getLoginName())).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to delete notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="NOTIFICATION_ADMIN", right="NOTIFICATION_DELETE", message="Not allowed to delete notifications by topic")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Deletion successful"), @ApiResponse(responseCode="400", description="Topic is not specified"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="Delete notifications by topic.", description="Delete notifications by topic.")
    public Response deleteNotificationsByTopic(@Context HttpHeaders hh, @Context UserSession userSession, @Parameter(description="the topic for notifications to delete") @DefaultValue(value="") @QueryParam(value="topic") String topic, @Parameter(description="if true, the newest notification of this topic will be kept") @DefaultValue(value="false") @QueryParam(value="keepNewest") boolean keepNewest) {
        LOGGER.info("deleteNotificationsByTopic topic={}, keepNewest={}", (Object)topic, (Object)keepNewest);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            notificationManager.deleteNotificationsByTopic(topic, keepNewest);
            return Response.noContent().build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to delete notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{notificationId}")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Missing resource:\n\n* Required service was not found\n* Requested notification was not found or no access rights\n"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="Get the data of a notification.", description="Get the data of a notification.")
    @ReturnDescription(value="The data of the requested notification as JSON.")
    public Response getNotification(@Parameter(description="the ID of the notification to get the data for") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("getNotification notificationId={}", (Object)notificationId);
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notification notification = notificationManager.getNotification(notificationId);
            if (notification != null && notification.hasAccessRight(userSession)) {
                return Response.ok((Object)notification.toGetDto(userSession.getLoginName())).build();
            }
            throw new NotificationNotFoundException(notificationId);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get notification.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="Get the notification of the requesting user.", description="Get the notification of the requesting user.")
    @ReturnDescription(value="The requested notifications of the user as JSON.")
    public Response getNotifications(@Parameter(description="paging start parameter") @QueryParam(value="start") @DefaultValue(value="0") Integer start, @Parameter(description="number of notifications to get") @QueryParam(value="limit") @DefaultValue(value="1000") Integer limit, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("getNotifications");
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            Notifications notifications = notificationManager.getNotifications(userSession, start, limit);
            return Response.ok((Object)notifications).build();
        }
        catch (MaintenanceModeEnabledException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get notifications.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @POST
    @Path(value="/{notificationId}/read")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Mark as read was successful"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="marks the notification as read by the user.", description="marks the notification as read by the user.")
    public Response markNotificationAsRead(@Parameter(description="the ID of the notification to mark as read") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("markNotificationAsRead");
        return this.markNotificationReadStatus(notificationId, hh, userSession, true);
    }

    @POST
    @Path(value="/{notificationId}/unread")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Mark as unread was successful"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    @OperationDescription(summary="marks the notification as unread by the user.", description="marks the notification as unread by the user.")
    public Response markNotificationAsUnread(@Parameter(description="the ID of the notification to mark as unread") @PathParam(value="notificationId") String notificationId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("markNotificationAsUnread");
        return this.markNotificationReadStatus(notificationId, hh, userSession, false);
    }

    private Response markNotificationReadStatus(String notificationId, HttpHeaders hh, UserSession userSession, boolean newReadStatus) {
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            notificationManager.markNotificationReadStatus(notificationId, userSession, newReadStatus);
            return Response.noContent().build();
        }
        catch (MaintenanceModeEnabledException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to mark notification as read.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @OperationDescription(summary="Mark multiple notifications as read or unread by the user.", description="Mark multiple notifications as read or unread by the user.\n\nTo do so, send a JSON message with the following fields:\n\n`notificationIds` :: List of IDs of the notifications to mark as read or unread.\n`isRead` :: Read status to set, either true or false\n\n.example\n[source,json]\n----\n{\n   \"notificationIds\": [\"11111111-0000-9999-aaaa-bbbbccccdddd\",\"22222222-0000-9999-aaaa-bbbbccccdddd\"],\n   \"isRead\": true\n}\n----\nThis marks the two notifications (\"1111...\" and \"2222...\") as read.\n")
    @POST
    @Path(value="/read")
    @Produces(value={"application/json"})
    @BpcUserSessionRequired
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Mark as read was successful"), @ApiResponse(responseCode="404", description="Required service was not found"), @ApiResponse(responseCode="500", description="Unexpected backend error"), @ApiResponse(responseCode="503", description="Maintenance mode is active")})
    public Response markNotificationsReadStatus(@Context HttpHeaders hh, @Context UserSession userSession, NotificationsMarkReadStatusPostDto markReadStatusDto) {
        LOGGER.info("markNotificationsAsRead");
        try {
            NotificationManager notificationManager = this.notificationManagerTracker.getService();
            notificationManager.markNotificationsReadStatus(userSession, markReadStatusDto.notificationIds, markReadStatusDto.isRead);
            return Response.noContent().build();
        }
        catch (MaintenanceModeEnabledException ex) {
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to mark notifications as read.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

