/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.MaintenanceModeEnabledException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.CoreBundleService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.notification.Notification;
import de.virtimo.bpc.core.notification.NotificationException;
import de.virtimo.bpc.core.notification.NotificationManager;
import de.virtimo.bpc.core.notification.NotificationNotFoundException;
import de.virtimo.bpc.core.notification.NotificationPersistenceHandler;
import de.virtimo.bpc.core.notification.Notifications;
import de.virtimo.bpc.util.StringUtil;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class NotificationManagerImpl
implements NotificationManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(NotificationManagerImpl.class);
    private static final Object NOTIFICATION_INDEX_LOCK = new Object();
    private final BundleContext bundleContext;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<CoreBundleService> coreBundleServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;

    public NotificationManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.coreBundleServiceTracker = new BpcServicesTracker<CoreBundleService>(bundleContext, CoreBundleService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification addNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("addNotification notification={}", (Object)notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification createdNotification = persistenceHandler.saveNotification(notification);
            this.fireNotificationAddedEvent(createdNotification);
            return createdNotification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification updateNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("updateNotification notification={}", (Object)notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification existingNotification = persistenceHandler.loadNotification(notification.getId());
            Notification updatedNotification = persistenceHandler.saveNotification(notification);
            this.fireNotificationUpdatedEvent(existingNotification, updatedNotification);
            return updatedNotification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification deleteNotification(Notification notification) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("deleteNotification notification={}", (Object)notification);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            persistenceHandler.deleteNotification(notification.getId());
            this.fireNotificationDeletedEvent(notification);
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification deleteNotificationById(String notificationId) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("deleteNotificationById notificationId={}", (Object)notificationId);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification notification = persistenceHandler.loadNotification(notificationId);
            persistenceHandler.deleteNotification(notification.getId());
            this.fireNotificationDeletedEvent(notification);
            return notification;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNotificationsByTopic(String topic, boolean keepNewest) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException, ValidationException {
        LOGGER.info("deleteNotificationByTopic topic={}, keepNewest={}", (Object)topic, (Object)keepNewest);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        if (StringUtil.isNullOrEmpty(topic)) {
            throw new ValidationException((ErrorCode)BpcErrorCode.VALIDATION_INVALID_INPUT, "Topic cannot be empty");
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            List notificationsToDelete;
            List<String> delNotificationsIds;
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            List<Notification> notifications = persistenceHandler.loadNotificationsByTopic(topic);
            Stream<Object> notificationStream = notifications.stream();
            if (keepNewest) {
                notificationStream = notificationStream.sorted(Comparator.comparing(Notification::getDate).reversed()).skip(1L);
            }
            if ((delNotificationsIds = (notificationsToDelete = notificationStream.toList()).stream().map(Notification::getId).toList()).isEmpty()) {
                return;
            }
            persistenceHandler.deleteNotifications(delNotificationsIds);
            notificationsToDelete.forEach(this::fireNotificationDeletedEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notification getNotification(String notificationId) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, NotificationNotFoundException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("getNotification notificationId={}", (Object)notificationId);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            return persistenceHandler.loadNotification(notificationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Notifications getNotifications(UserSession userSession, Integer start, Integer limit) throws ServiceNotFoundException, MaintenanceModeEnabledException, NotificationException, OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("getNotifications userSession=..., start={}, limit={}", (Object)start, (Object)limit);
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            return persistenceHandler.loadNotifications(start, limit, userSession.getLoginName(), userSession.getRoles(), userSession.getOrganisations());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markNotificationReadStatus(String notificationId, UserSession userSession, boolean newReadStatus) throws NotificationException, NotificationNotFoundException, ServiceNotFoundException, OpenSearchIndexNotFoundException, OpenSearchRelatedException, MaintenanceModeEnabledException {
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            Notification existingNotification = persistenceHandler.loadNotification(notificationId);
            if (!existingNotification.hasAccessRight(userSession)) {
                return;
            }
            if (existingNotification.isReadByUser(userSession.getLoginName()) == newReadStatus) {
                return;
            }
            existingNotification.setReadByUser(userSession.getLoginName(), newReadStatus);
            persistenceHandler.saveNotification(existingNotification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markNotificationsReadStatus(UserSession userSession, List<String> notificationIds, boolean newReadStatus) throws MaintenanceModeEnabledException, ServiceNotFoundException, NotificationException, OpenSearchIndexNotFoundException, OpenSearchRelatedException {
        if (this.coreBundleServiceTracker.getService().isMaintenanceModeEnabled()) {
            throw new MaintenanceModeEnabledException();
        }
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        if (notificationIds.isEmpty()) {
            return;
        }
        Object object = NOTIFICATION_INDEX_LOCK;
        synchronized (object) {
            NotificationPersistenceHandler persistenceHandler = new NotificationPersistenceHandler(oss);
            persistenceHandler.createBpcNotificationIndexIfMissing();
            List<Notification> notificationsToMark = persistenceHandler.loadNotifications(notificationIds);
            notificationsToMark = notificationsToMark.stream().filter(n -> n.hasAccessRight(userSession)).filter(n -> n.isReadByUser(userSession.getLoginName()) != newReadStatus).toList();
            if (notificationsToMark.isEmpty()) {
                return;
            }
            notificationsToMark.forEach(n -> n.setReadByUser(userSession.getLoginName(), newReadStatus));
            persistenceHandler.bulkUpdateNotificationReadStatus(notificationsToMark);
        }
    }

    private void fireNotificationAddedEvent(Notification notification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationAdded", "notification", notification);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("Failed to send the notification added event.", (Throwable)ex);
        }
    }

    private void fireNotificationUpdatedEvent(Notification oldNotification, Notification newNotification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationUpdated", "notification", newNotification);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("Failed to send the notification updated event.", (Throwable)ex);
        }
    }

    private void fireNotificationDeletedEvent(Notification notification) {
        try {
            this.eventManagerTracker.getService().fireEvent("de/virtimo/bpc/core/notification/notificationDeleted", "notification", notification);
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("Failed to send the notification deleted event.", (Throwable)ex);
        }
    }
}

