/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.notification;

import de.virtimo.bpc.core.notification.dtos.NotificationGetDto;
import de.virtimo.bpc.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class Notifications {
    private final long start;
    private final long limit;
    private long totalCountFromSource;
    private final List<NotificationGetDto> data;
    private final List<String> idsWithErrors;

    public Notifications(Integer start, Integer limit) {
        this.start = start.intValue();
        this.limit = limit.intValue();
        this.totalCountFromSource = 0L;
        this.data = new ArrayList<NotificationGetDto>();
        this.idsWithErrors = new ArrayList<String>();
    }

    public long getStart() {
        return this.start;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getTotalCountFromSource() {
        return this.totalCountFromSource;
    }

    public void setTotalCountFromSource(long totalCountFromSource) {
        this.totalCountFromSource = totalCountFromSource;
    }

    public void addData(NotificationGetDto notification) {
        if (notification != null) {
            this.data.add(notification);
        }
    }

    public long getTotalCount() {
        return this.data.size();
    }

    public List<NotificationGetDto> getData() {
        return this.data;
    }

    public void addAsIdWithError(String idWithError) {
        if (!StringUtil.isNullOrEmpty(idWithError)) {
            this.idsWithErrors.add(idWithError);
        }
    }

    public long getTotalCountWithErrors() {
        return this.idsWithErrors.size();
    }

    public List<String> getIdsWithErrors() {
        return this.idsWithErrors;
    }
}

