/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch;

import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.SettingValidator;
import de.virtimo.bpc.api.Settings;
import de.virtimo.bpc.api.ValidationException;
import de.virtimo.bpc.api.exception.FrontendWarningException;
import de.virtimo.bpc.core.SettingsImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingValidators {
    private static final Logger LOGGER = LogManager.getLogger(SettingValidators.class);
    private final List<SettingValidator> settingValidators = new ArrayList<SettingValidator>();

    public void destroy() {
        LOGGER.info("destroy");
        for (SettingValidator settingValidator : this.settingValidators) {
            settingValidator.destroy();
        }
        this.settingValidators.clear();
    }

    public List<SettingValidator> getAll() {
        return new ArrayList<SettingValidator>(this.settingValidators);
    }

    public void set(SettingValidator settingValidator) {
        LOGGER.info("set settingValidator={}", (Object)settingValidator);
        if (settingValidator != null) {
            final String newSettingValidatorClassName = settingValidator.getClass().getName();
            this.settingValidators.removeIf(new Predicate<SettingValidator>(){

                @Override
                public boolean test(SettingValidator settingValidator) {
                    return newSettingValidatorClassName.equals(settingValidator.getClass().getName());
                }
            });
            this.settingValidators.add(settingValidator);
        }
    }

    public void remove(SettingValidator settingValidator) {
        LOGGER.info("remove settingValidator={}", (Object)settingValidator);
        if (settingValidator != null) {
            final String newSettingValidatorClassName = settingValidator.getClass().getName();
            this.settingValidators.removeIf(new Predicate<SettingValidator>(){

                @Override
                public boolean test(SettingValidator settingValidator) {
                    return newSettingValidatorClassName.equals(settingValidator.getClass().getName());
                }
            });
        }
    }

    public List<FrontendWarningException> validateModuleSettings(String moduleId, Collection<Setting> existingSettings, Collection<? extends Setting> settings) throws ValidationException {
        LOGGER.info("validateModuleSettings moduleId={}, existingSettings=...., settings=...", (Object)moduleId);
        return this.validateModuleInstanceSettings(moduleId, "noinstance", "none", existingSettings, settings);
    }

    public List<FrontendWarningException> validateModuleSettings(String moduleId, Settings existingSettings, Settings settings) throws ValidationException {
        LOGGER.info("validateModuleSettings moduleId={}, existingSettings=...., settings=...", (Object)moduleId);
        return this.validateModuleInstanceSettings(moduleId, "noinstance", "none", existingSettings, settings);
    }

    public List<FrontendWarningException> validateModuleInstanceSettings(String moduleId, String moduleInstanceId, String instanceType, Collection<Setting> existingSettings, Collection<? extends Setting> settings) throws ValidationException {
        LOGGER.info("validateModuleInstanceSettings moduleId={}, moduleInstanceId={}, instanceType={}, existingSettings=...., settings=...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        return this.validateModuleInstanceSettings(moduleId, moduleInstanceId, instanceType, new SettingsImpl(existingSettings), new SettingsImpl(settings));
    }

    public List<FrontendWarningException> validateModuleInstanceSettings(String moduleId, String moduleInstanceId, String instanceType, Settings existingSettings, Settings settings) throws ValidationException {
        LOGGER.info("validateModuleInstanceSettings moduleId={}, moduleInstanceId={}, instanceType={}, existingSettings=...., settings=...", (Object)moduleId, (Object)moduleInstanceId, (Object)instanceType);
        ArrayList<FrontendWarningException> frontendWarnings = new ArrayList<FrontendWarningException>();
        for (SettingValidator validator : this.getAll()) {
            for (Setting setting : settings) {
                List<FrontendWarningException> few;
                if (setting == null || !validator.canValidate(moduleId, moduleInstanceId, instanceType) || !validator.canValidate(setting) || (few = validator.validate(setting)) == null) continue;
                frontendWarnings.addAll(few);
            }
        }
        HashMap<String, Setting> tmpSettings = new HashMap<String, Setting>();
        if (existingSettings != null) {
            tmpSettings.putAll(existingSettings.asMap());
        }
        tmpSettings.putAll(settings.asMap());
        for (SettingValidator validator : this.getAll()) {
            List<FrontendWarningException> few;
            if (!validator.canValidate(moduleId, moduleInstanceId, instanceType) || (few = validator.validate(moduleId, moduleInstanceId, instanceType, tmpSettings)) == null) continue;
            frontendWarnings.addAll(few);
        }
        return frontendWarnings;
    }
}

