/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import de.virtimo.bpc.util.MapUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;

public class BpcConfigurationIndexMigrationFromModelVersion25To26
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion25To26.class);

    public BpcConfigurationIndexMigrationFromModelVersion25To26(OpenSearchService oss) {
        super(oss, 26);
    }

    @Override
    List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if (!hit.getId().equals(sourceValues.get("id"))) {
            LOGGER.warn("Skipping document with ID mismatch: {} != {}", (Object)hit.getId(), sourceValues.get("id"));
            return null;
        }
        RenamedSetting renamedEsDataViewLimitSetting = this.renameLogServiceModuleSetting(sourceValues, "es_data_view_limit", "openSearchDataViewLimit");
        if (renamedEsDataViewLimitSetting != null) {
            return this.createIndexRequests(newIndex, renamedEsDataViewLimitSetting);
        }
        RenamedSetting renamedEsDataCountLimitSetting = this.renameLogServiceModuleSetting(sourceValues, "es_data_count_limit", "openSearchDataCountLimit");
        if (renamedEsDataCountLimitSetting != null) {
            return this.createIndexRequests(newIndex, renamedEsDataCountLimitSetting);
        }
        RenamedSetting renamedMaintenanceEnabledSetting = this.renameLogServiceInstanceSetting(sourceValues, "maintenanceEnabled", "enabled");
        if (renamedMaintenanceEnabledSetting != null) {
            renamedMaintenanceEnabledSetting.getUpdatedSourceValues().put("value", !MapUtil.getValueAsBoolean(renamedMaintenanceEnabledSetting.getUpdatedSourceValues(), "value", false));
            return this.createIndexRequests(newIndex, renamedMaintenanceEnabledSetting);
        }
        List<IndexRequest> convertedOpenSearchIndexSetting = this.convertOpenSearchIndexSetting(newIndex, sourceValues);
        if (convertedOpenSearchIndexSetting != null) {
            return convertedOpenSearchIndexSetting;
        }
        List<IndexRequest> convertedKeysSetting = this.convertKeysSetting(newIndex, sourceValues);
        if (convertedKeysSetting != null) {
            return convertedKeysSetting;
        }
        List<IndexRequest> convertedRdmsSetting = this.convertRdmsSetting(newIndex, sourceValues);
        if (convertedRdmsSetting != null) {
            return convertedRdmsSetting;
        }
        List<IndexRequest> convertedFieldsSetting = this.convertFieldsSetting(newIndex, sourceValues);
        if (convertedFieldsSetting != null) {
            return convertedFieldsSetting;
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private RenamedSetting renameLogServiceModuleSetting(Map<String, Object> sourceValues, String oldSettingName, String newSettingName) {
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if (!"noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        if (!oldSettingName.equals(sourceValues.get("name"))) {
            return null;
        }
        return new RenamedSetting(newSettingName, sourceValues);
    }

    private RenamedSetting renameLogServiceInstanceSetting(Map<String, Object> sourceValues, String oldSettingName, String newSettingName) {
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if ("noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        if (!oldSettingName.equals(sourceValues.get("name"))) {
            return null;
        }
        return new RenamedSetting(newSettingName, sourceValues);
    }

    private List<IndexRequest> createIndexRequests(IndexToMigrate newIndex, RenamedSetting renamedSetting) {
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(renamedSetting.getNewId()).source(renamedSetting.getUpdatedSourceValues(), (MediaType)XContentType.JSON));
    }

    private List<IndexRequest> convertOpenSearchIndexSetting(IndexToMigrate newIndex, Map<String, Object> sourceValues) {
        Map childIndexMap;
        Object parentIndexSettingMap;
        Object parentIndexName;
        Map parentIndexMap;
        Object v;
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if ("noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        if (!"openSearch".equals(sourceValues.get("name"))) {
            return null;
        }
        Object object = sourceValues.get("value");
        if (!(object instanceof Map)) {
            return null;
        }
        Map valueMap = (Map)object;
        ArrayList<IndexRequest> requests = new ArrayList<IndexRequest>();
        Object v2 = valueMap.get("parent");
        if (v2 instanceof Map && (v = (parentIndexMap = (Map)v2).get("index")) instanceof String) {
            parentIndexName = (String)v;
            parentIndexSettingMap = this.createTextSettingMap(sourceValues, "openSearchParentIndex", (String)parentIndexName);
            requests.add(new IndexRequest(newIndex.getName()).id((String)parentIndexSettingMap.get("id")).source((Map<String, ?>)parentIndexSettingMap, (MediaType)XContentType.JSON));
        }
        if ((parentIndexName = valueMap.get("child")) instanceof Map && (parentIndexSettingMap = (childIndexMap = (Map)parentIndexName).get("index")) instanceof String) {
            String childIndexName = (String)parentIndexSettingMap;
            Map<String, Object> childIndexSettingMap = this.createTextSettingMap(sourceValues, "openSearchChildIndex", childIndexName);
            requests.add(new IndexRequest(newIndex.getName()).id((String)childIndexSettingMap.get("id")).source(childIndexSettingMap, (MediaType)XContentType.JSON));
        }
        return requests.isEmpty() ? null : requests;
    }

    private List<IndexRequest> convertKeysSetting(IndexToMigrate newIndex, Map<String, Object> sourceValues) {
        Map childMap;
        Object parentKeyFieldsSettingMap;
        Object parentKeyFields;
        Map parentMap;
        Object v;
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if ("noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        if (!"keys".equals(sourceValues.get("name"))) {
            return null;
        }
        Object object = sourceValues.get("value");
        if (!(object instanceof Map)) {
            return null;
        }
        Map valueMap = (Map)object;
        ArrayList<IndexRequest> requests = new ArrayList<IndexRequest>();
        Object v2 = valueMap.get("parent");
        if (v2 instanceof Map && (v = (parentMap = (Map)v2).get("idColumns")) instanceof String) {
            parentKeyFields = (String)v;
            parentKeyFieldsSettingMap = this.createTextSettingMap(sourceValues, "parentKeyFields", (String)parentKeyFields);
            requests.add(new IndexRequest(newIndex.getName()).id((String)parentKeyFieldsSettingMap.get("id")).source((Map<String, ?>)parentKeyFieldsSettingMap, (MediaType)XContentType.JSON));
        }
        if ((parentKeyFields = valueMap.get("child")) instanceof Map && (parentKeyFieldsSettingMap = (childMap = (Map)parentKeyFields).get("idColumns")) instanceof String) {
            String childKeyFields = (String)parentKeyFieldsSettingMap;
            Map<String, Object> childKeyFieldsSettingMap = this.createTextSettingMap(sourceValues, "childKeyFields", childKeyFields);
            requests.add(new IndexRequest(newIndex.getName()).id((String)childKeyFieldsSettingMap.get("id")).source(childKeyFieldsSettingMap, (MediaType)XContentType.JSON));
        }
        return requests.isEmpty() ? null : requests;
    }

    private List<IndexRequest> convertRdmsSetting(IndexToMigrate newIndex, Map<String, Object> sourceValues) {
        Map childMap;
        Object rdmsParentTableSettingMap;
        Object rdmsParentTable;
        Map parentMap;
        Object v;
        Object rdmsTimeZoneSettingMap;
        Object rdmsDataSourceNameSettingMap;
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if ("noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        if (!"rdms".equals(sourceValues.get("name"))) {
            return null;
        }
        Object object = sourceValues.get("value");
        if (!(object instanceof Map)) {
            return null;
        }
        Map valueMap = (Map)object;
        ArrayList<IndexRequest> requests = new ArrayList<IndexRequest>();
        Object v2 = valueMap.get("rdmsDataSourceName");
        if (v2 instanceof String) {
            String rdmsDataSourceName = (String)v2;
            rdmsDataSourceNameSettingMap = this.createTextSettingMap(sourceValues, "rdmsDataSourceName", rdmsDataSourceName);
            requests.add(new IndexRequest(newIndex.getName()).id((String)rdmsDataSourceNameSettingMap.get("id")).source((Map<String, ?>)rdmsDataSourceNameSettingMap, (MediaType)XContentType.JSON));
        }
        if ((rdmsDataSourceNameSettingMap = valueMap.get("rdmsTimeZone")) instanceof String) {
            String rdmsTimeZone = (String)rdmsDataSourceNameSettingMap;
            rdmsTimeZoneSettingMap = this.createTextSettingMap(sourceValues, "rdmsTimeZone", rdmsTimeZone);
            requests.add(new IndexRequest(newIndex.getName()).id((String)rdmsTimeZoneSettingMap.get("id")).source((Map<String, ?>)rdmsTimeZoneSettingMap, (MediaType)XContentType.JSON));
        }
        if ((rdmsTimeZoneSettingMap = valueMap.get("parent")) instanceof Map && (v = (parentMap = (Map)rdmsTimeZoneSettingMap).get("table")) instanceof String) {
            rdmsParentTable = (String)v;
            rdmsParentTableSettingMap = this.createTextSettingMap(sourceValues, "rdmsParentTable", (String)rdmsParentTable);
            requests.add(new IndexRequest(newIndex.getName()).id((String)rdmsParentTableSettingMap.get("id")).source((Map<String, ?>)rdmsParentTableSettingMap, (MediaType)XContentType.JSON));
        }
        if ((rdmsParentTable = valueMap.get("child")) instanceof Map && (rdmsParentTableSettingMap = (childMap = (Map)rdmsParentTable).get("table")) instanceof String) {
            String rdmsChildTable = (String)rdmsParentTableSettingMap;
            Map<String, Object> rdmsChildTableSettingMap = this.createTextSettingMap(sourceValues, "rdmsChildTable", rdmsChildTable);
            requests.add(new IndexRequest(newIndex.getName()).id((String)rdmsChildTableSettingMap.get("id")).source(rdmsChildTableSettingMap, (MediaType)XContentType.JSON));
        }
        return requests.isEmpty() ? null : requests;
    }

    private List<IndexRequest> convertFieldsSetting(IndexToMigrate newIndex, Map<String, Object> sourceValues) {
        Object parentFieldsSettingMap;
        if (sourceValues == null) {
            return null;
        }
        if (!"logservice".equals(sourceValues.get("moduleId"))) {
            return null;
        }
        if ("noinstance".equals(sourceValues.get("instanceId"))) {
            return null;
        }
        if (!"fields".equals(sourceValues.get("name"))) {
            return null;
        }
        Object object = sourceValues.get("value");
        if (!(object instanceof Map)) {
            return null;
        }
        Map valueMap = (Map)object;
        ArrayList<IndexRequest> requests = new ArrayList<IndexRequest>();
        Object v = valueMap.get("parent");
        if (v instanceof Map) {
            Map parentMap = (Map)v;
            parentFieldsSettingMap = this.createJsonSettingMap(sourceValues, "parentFields", parentMap);
            requests.add(new IndexRequest(newIndex.getName()).id((String)parentFieldsSettingMap.get("id")).source((Map<String, ?>)parentFieldsSettingMap, (MediaType)XContentType.JSON));
        }
        if ((parentFieldsSettingMap = valueMap.get("child")) instanceof Map) {
            Map childMap = (Map)parentFieldsSettingMap;
            Map<String, Object> childFieldsSettingMap = this.createJsonSettingMap(sourceValues, "childFields", childMap);
            requests.add(new IndexRequest(newIndex.getName()).id((String)childFieldsSettingMap.get("id")).source(childFieldsSettingMap, (MediaType)XContentType.JSON));
        }
        return requests.isEmpty() ? null : requests;
    }

    private Map<String, Object> createTextSettingMap(Map<String, Object> baseSettingValues, String settingName, String textValue) {
        return this.createSettingMap(baseSettingValues, settingName, "text", textValue);
    }

    private Map<String, Object> createJsonSettingMap(Map<String, Object> baseSettingValues, String settingName, Map mapValue) {
        return this.createSettingMap(baseSettingValues, settingName, "json", mapValue);
    }

    private Map<String, Object> createSettingMap(Map<String, Object> baseSettingValues, String settingName, String valueType, Object value) {
        return this.createV1SettingMap(this.createV1SettingId((String)baseSettingValues.get("moduleId"), (String)baseSettingValues.get("instanceId"), settingName), String.valueOf(baseSettingValues.get("moduleId")), String.valueOf(baseSettingValues.get("instanceId")), "none", settingName, valueType, value);
    }

    private class RenamedSetting {
        private final Map<String, Object> updatedSourceValues;

        public RenamedSetting(String newSettingName, Map<String, Object> sourceValues) {
            this.updatedSourceValues = new HashMap<String, Object>(sourceValues);
            this.updatedSourceValues.put("id", BpcConfigurationIndexMigrationFromModelVersion25To26.this.createV1SettingId((String)sourceValues.get("moduleId"), (String)sourceValues.get("instanceId"), newSettingName));
            this.updatedSourceValues.put("name", newSettingName);
        }

        public String getNewId() {
            return (String)this.updatedSourceValues.get("id");
        }

        public Map<String, Object> getUpdatedSourceValues() {
            return this.updatedSourceValues;
        }
    }
}

