/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.migration;

import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.migration.AllSearchHitsMigration;
import de.virtimo.bpc.core.opensearch.migration.IndexToMigrate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

class BpcConfigurationIndexMigrationFromModelVersion8To9
extends AllSearchHitsMigration {
    private static final Logger LOGGER = LogManager.getLogger(BpcConfigurationIndexMigrationFromModelVersion8To9.class);

    public BpcConfigurationIndexMigrationFromModelVersion8To9(OpenSearchService oss) {
        super(oss, 9);
    }

    @Override
    public List<IndexRequest> migrateSearchHit(RestHighLevelClient osClient, IndexToMigrate oldIndex, IndexToMigrate newIndex, SearchHit hit) {
        Map<String, Object> sourceValues = hit.getSourceAsMap();
        if ("monitor".equals(sourceValues.get("moduleId"))) {
            if ("row_style".equals(sourceValues.get("name"))) {
                ArrayList<HashMap> newRowStyleSetting = this.getNewRowStyleSettingFromRowStyle(sourceValues.get("value"));
                Map<String, Object> newRowStyleConfig = this.createV1SettingMap((String)sourceValues.get("id"), "monitor", (String)sourceValues.get("instanceId"), "none", "row_style", "json", newRowStyleSetting);
                return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(newRowStyleConfig, (MediaType)XContentType.JSON));
            }
            if ("function_gridMultipleViewsConfig".equals(sourceValues.get("name"))) {
                String rowStyleConfigId = this.createV1SettingId("monitor", (String)sourceValues.get("instanceId"), "row_style");
                try {
                    SearchRequest request = new SearchRequest().indices(oldIndex.getName()).source(new SearchSourceBuilder().query(QueryBuilders.matchQuery("id", rowStyleConfigId)));
                    SearchResponse response = osClient.search(request, RequestOptions.DEFAULT);
                    Object oldRowStyleSetting = response.getHits().getAt(0).getSourceAsMap().get("value");
                    Map<String, Object> newRowStyleAndMultipleViewSetting = this.getNewRowStyleAndMultipleViewSetting(oldRowStyleSetting, (HashMap)sourceValues.get("value"));
                    if (newRowStyleAndMultipleViewSetting != null) {
                        ArrayList newRowStyleSetting = (ArrayList)newRowStyleAndMultipleViewSetting.get("newRowStyleSetting");
                        HashMap newMultipleViewSetting = (HashMap)newRowStyleAndMultipleViewSetting.get("newMultipleViewSetting");
                        Map<String, Object> newMultipleViewConfig = this.createV1SettingMap((String)sourceValues.get("id"), "monitor", (String)sourceValues.get("instanceId"), "none", (String)sourceValues.get("name"), "json", newMultipleViewSetting);
                        Map<String, Object> newRowStyleConfig = this.createV1SettingMap(rowStyleConfigId, "monitor", (String)sourceValues.get("instanceId"), "none", "row_style", "json", newRowStyleSetting);
                        ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>();
                        indexRequests.add(new IndexRequest(newIndex.getName()).id((String)sourceValues.get("id")).source(newMultipleViewConfig, (MediaType)XContentType.JSON));
                        indexRequests.add(new IndexRequest(newIndex.getName()).id(rowStyleConfigId).source(newRowStyleConfig, (MediaType)XContentType.JSON));
                        return indexRequests;
                    }
                }
                catch (IOException | OpenSearchException e) {
                    LOGGER.warn("Error while converting gridMultipleViewsConfig", (Throwable)e);
                }
            }
        }
        return Collections.singletonList(new IndexRequest(newIndex.getName()).id(hit.getId()).source(sourceValues, (MediaType)XContentType.JSON));
    }

    private ArrayList<HashMap> getNewRowStyleSettingFromRowStyle(Object oldRowStyleSetting) {
        if (oldRowStyleSetting instanceof HashMap) {
            ArrayList<HashMap> newValue = new ArrayList<HashMap>();
            if (oldRowStyleSetting != null && !((HashMap)oldRowStyleSetting).isEmpty()) {
                newValue.add((HashMap)oldRowStyleSetting);
            }
            return newValue;
        }
        if (oldRowStyleSetting instanceof ArrayList) {
            return (ArrayList)oldRowStyleSetting;
        }
        return null;
    }

    private Map<String, Object> getNewRowStyleAndMultipleViewSetting(Object oldRowStyleSetting, HashMap<String, Object> multipleViewSetting) {
        ArrayList viewsConfig;
        ArrayList newRowStyleConfig = new ArrayList();
        if (oldRowStyleSetting instanceof HashMap) {
            if (oldRowStyleSetting != null && !((HashMap)oldRowStyleSetting).isEmpty()) {
                newRowStyleConfig.add((HashMap)oldRowStyleSetting);
            }
        } else if (oldRowStyleSetting instanceof ArrayList) {
            newRowStyleConfig = (ArrayList)((ArrayList)oldRowStyleSetting).clone();
        }
        if ((viewsConfig = (ArrayList)multipleViewSetting.get("views")) == null) {
            return null;
        }
        for (HashMap viewConfig : viewsConfig) {
            HashMap styleConfig = (HashMap)viewConfig.get("styles");
            if (styleConfig == null) continue;
            ArrayList<String> views = new ArrayList<String>();
            views.add((String)viewConfig.get("id"));
            styleConfig.put("views", views);
            newRowStyleConfig.add(styleConfig);
            viewConfig.remove("styles");
        }
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        returnValue.put("newRowStyleSetting", newRowStyleConfig);
        returnValue.put("newMultipleViewSetting", multipleViewSetting);
        return returnValue;
    }
}

