/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.plugin;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

public class OpenSearchBpcPluginCollector
extends Collector {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchBpcPluginCollector.class);
    private final BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;

    public OpenSearchBpcPluginCollector(BundleContext bundleContext) {
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(bundleContext, OpenSearchBpcPluginManager.class);
    }

    public void unregister() {
        LOGGER.info("unregister");
        CollectorRegistry.defaultRegistry.unregister((Collector)this);
        BpcServicesTracker.stopAll((Object)this);
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        try {
            OpenSearchBpcPluginManager.WebsocketState websocketState = this.openSearchBpcPluginManagerTracker.getService().getWebsocketState();
            int metricWebsocketState = switch (websocketState) {
                default -> throw new IncompatibleClassChangeError();
                case OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED -> 0;
                case OpenSearchBpcPluginManager.WebsocketState.CONNECTED -> 1;
                case OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED_DUE_TO_ERROR -> 2;
            };
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_os_bpc_plugin_status_websocket", "Status of the websocket connection (0=disconnected, 1=connected, 2=error)", (double)metricWebsocketState));
        }
        catch (Throwable websocketState) {
            // empty catch block
        }
        try {
            OpenSearchBpcPluginManager.PluginState pluginState = this.openSearchBpcPluginManagerTracker.getService().getPluginState();
            int metricPluginState = switch (pluginState) {
                default -> throw new IncompatibleClassChangeError();
                case OpenSearchBpcPluginManager.PluginState.UNKNOWN -> 0;
                case OpenSearchBpcPluginManager.PluginState.ACCESSIBLE -> 1;
                case OpenSearchBpcPluginManager.PluginState.NOT_ACCESSIBLE -> 2;
                case OpenSearchBpcPluginManager.PluginState.ERRORS -> 3;
            };
            mfs.add((Collector.MetricFamilySamples)new GaugeMetricFamily("bpc_os_bpc_plugin_status_plugin", "Status of the plugin (0=unknown, 1=accessible, 2=not accessible, 3=errors)", (double)metricPluginState));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return mfs;
    }
}

