/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.opensearch.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.SettingException;
import de.virtimo.bpc.api.auditlog.UserAuditLog;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.JsonGenerationException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginError;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchHost;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchPluginDTOResponse;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchBpcPluginErrorImpl;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchBpcPluginListener;
import de.virtimo.bpc.core.opensearch.plugin.OpenSearchPluginDTOResponseImpl;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobDeleteActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobInfosDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobScheduleActionEntryDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupJobStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.BackupSnapshotInfoDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterAddActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ChangesFilterRemoveAllActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ConfigDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.FilterDTO;
import de.virtimo.bpc.opensearch.plugin.dto.FiltersDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTO;
import de.virtimo.bpc.opensearch.plugin.dto.OpenSearchPluginDTOCreator;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobForcedStartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRestartActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsClearLookupJoinCachesActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsDetailsDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsRefreshLookupJoinsActionDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobsWithRuntimeStatsFromAllServersDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.core.xcontent.ToXContent;
import org.osgi.framework.BundleContext;

public class OpenSearchBpcPluginManagerImpl
implements OpenSearchBpcPluginManager,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchBpcPluginManagerImpl.class);
    public static final int MAX_ERRORS = 10;
    private final BundleContext bundleContext;
    private final CoreBundleConfiguration coreBundleConfiguration;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<EventManager> eventManagerTracker;
    private ScheduledExecutorService openSearchBpcPluginExecutorService;
    private final OpenSearchBpcPluginListener openSearchBpcPluginListener;
    private final List<OpenSearchBpcPluginError> lastErrors = new ArrayList<OpenSearchBpcPluginError>();
    private OpenSearchBpcPluginManager.PluginState pluginState = OpenSearchBpcPluginManager.PluginState.UNKNOWN;
    private OpenSearchBpcPluginManager.WebsocketState websocketState = OpenSearchBpcPluginManager.WebsocketState.DISCONNECTED;

    public OpenSearchBpcPluginManagerImpl(BundleContext bundleContext, CoreBundleConfiguration coreBundleConfiguration) {
        this.bundleContext = bundleContext;
        this.coreBundleConfiguration = coreBundleConfiguration;
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.eventManagerTracker = new BpcServicesTracker<EventManager>(bundleContext, EventManager.class);
        this.openSearchBpcPluginListener = new OpenSearchBpcPluginListener(bundleContext, this);
        this.openSearchBpcPluginExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryWithNamePrefix("bpc-core-os-plugin-listener"));
        this.openSearchBpcPluginExecutorService.scheduleWithFixedDelay(this.openSearchBpcPluginListener, 5L, coreBundleConfiguration.getSystemPropertyValueAsInt("de.virtimo.bpc.core.os-bpc-plugin.retryInterval", 5), TimeUnit.SECONDS);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        if (this.openSearchBpcPluginExecutorService != null) {
            this.openSearchBpcPluginExecutorService.shutdownNow();
            this.openSearchBpcPluginExecutorService = null;
        }
        if (this.openSearchBpcPluginListener != null) {
            this.openSearchBpcPluginListener.destroy();
        }
        BpcServicesTracker.stopAll(this);
    }

    @Override
    public String getOpenSearchBpcPluginWebsocketUrl() throws ServiceNotFoundException, SettingException {
        OpenSearchService oss = this.openSearchServiceTracker.getService();
        OpenSearchPluginDTOResponse<ConfigDTO> resp = this.getOpenSearchBpcPluginConfig(oss);
        OpenSearchHost openSearchHost = resp.getFromOpenSearchHost();
        ConfigDTO config = resp.getDto();
        if (config == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Failed to fetch the config from the 'os-bpc-plugin'.");
        }
        ConfigDTO.Websocket websocket = config.getWebsocket();
        if (websocket == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Did not find the websocket property in the 'os-bpc-plugin' config: " + String.valueOf(config));
        }
        Integer websocketPort = websocket.getPort();
        if (websocketPort == null) {
            throw new SettingException((ErrorCode)CoreErrorCode.UNEXPECTED, "Did not find the websocket port in the 'os-bpc-plugin' config: " + String.valueOf(config));
        }
        return "ws://" + openSearchHost.getHostName() + ":" + websocketPort + "/ws/_bpc";
    }

    @Override
    public OpenSearchBpcPluginManager.PluginState getPluginState() {
        return this.pluginState;
    }

    private void setPluginState(OpenSearchBpcPluginManager.PluginState pluginState) {
        this.pluginState = pluginState;
    }

    @Override
    public OpenSearchBpcPluginManager.WebsocketState getWebsocketState() {
        return this.websocketState;
    }

    @Override
    public void setWebsocketState(OpenSearchBpcPluginManager.WebsocketState websocketState) {
        if (this.websocketState != websocketState) {
            this.websocketState = websocketState;
            try {
                this.eventManagerTracker.getService().fireEvent("de/virtimo/os-bpc-plugin", "WebsocketState", (Object)websocketState);
            }
            catch (ServiceNotFoundException ex) {
                LOGGER.error("Failed to fire the websocket state change: " + String.valueOf((Object)websocketState), (Throwable)ex);
            }
        }
    }

    @Override
    public List<OpenSearchBpcPluginError> getErrors() {
        return this.lastErrors;
    }

    @Override
    public synchronized void addError(String message, Throwable t) {
        LOGGER.error(message);
        OpenSearchBpcPluginError previousError = null;
        if (!this.lastErrors.isEmpty()) {
            previousError = this.lastErrors.get(this.lastErrors.size() - 1);
        }
        OpenSearchBpcPluginErrorImpl currentError = new OpenSearchBpcPluginErrorImpl(message, t);
        if (previousError != null && previousError.equals(currentError)) {
            this.lastErrors.remove(this.lastErrors.size() - 1);
        }
        this.lastErrors.add(currentError);
        if (this.lastErrors.size() > 10) {
            this.lastErrors.remove(0);
        }
    }

    @Override
    public synchronized OpenSearchPluginDTOResponse<ConfigDTO> getOpenSearchBpcPluginConfig() throws ServiceNotFoundException {
        LOGGER.info("getOpenSearchBpcPluginConfig");
        return this.getOpenSearchBpcPluginConfig(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized OpenSearchPluginDTOResponse<ConfigDTO> getOpenSearchBpcPluginConfig(OpenSearchService oss) {
        LOGGER.info("getOpenSearchBpcPluginConfig oss=...");
        Request req = new Request("GET", "/_bpc/config");
        return this.getDTOWithHost(req, ConfigDTO.class, oss);
    }

    @Override
    public synchronized FiltersDTO getRegisteredFilters() throws ServiceNotFoundException {
        LOGGER.info("getRegisteredFilters");
        return this.getRegisteredFilters(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized FiltersDTO getRegisteredFilters(OpenSearchService oss) {
        LOGGER.info("getRegisteredFilters oss=...");
        return this.getDTO("GET", "/_bpc/filter", Map.of("serverUUID", this.coreBundleConfiguration.getServerUUID()), FiltersDTO.class, oss);
    }

    @Override
    public synchronized int registerFilter(FilterDTO filter) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("registerFilter filter={}", (Object)filter);
        return this.registerFilter(this.openSearchServiceTracker.getService(), filter);
    }

    @Override
    public synchronized int registerFilter(OpenSearchService oss, FilterDTO filter) throws JsonGenerationException {
        LOGGER.info("registerFilter oss=..., filter={}", (Object)filter);
        ChangesFilterAddActionDTO filterAddAction = new ChangesFilterAddActionDTO(this.coreBundleConfiguration.getServerUUID(), filter.getIndex(), filter.isSendIndexEventsOnlyForModifiedSources());
        return this.sendDTO("PUT", "/_bpc/filter", (OpenSearchPluginDTO)filterAddAction, oss);
    }

    @Override
    public synchronized int unregisterFilter(FilterDTO filter) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("unregisterFilter filter={}", (Object)filter);
        return this.unregisterFilter(this.openSearchServiceTracker.getService(), filter);
    }

    @Override
    public synchronized int unregisterFilter(OpenSearchService oss, FilterDTO filter) throws JsonGenerationException {
        LOGGER.info("unregisterFilter oss=..., filter={}", (Object)filter);
        ChangesFilterRemoveActionDTO filterRemoveAction = new ChangesFilterRemoveActionDTO(this.coreBundleConfiguration.getServerUUID(), filter.getIndex());
        return this.sendDTO("DELETE", "/_bpc/filter", (OpenSearchPluginDTO)filterRemoveAction, oss);
    }

    @Override
    public synchronized int unregisterAllFilters() throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("unregisterAllFilters");
        return this.unregisterAllFilters(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int unregisterAllFilters(OpenSearchService oss) throws JsonGenerationException {
        LOGGER.info("unregisterAllFilters oss=...");
        ChangesFilterRemoveAllActionDTO removeAllFilterAction = new ChangesFilterRemoveAllActionDTO(this.coreBundleConfiguration.getServerUUID());
        return this.sendDTO("DELETE", "/_bpc/filter/all", (OpenSearchPluginDTO)removeAllFilterAction, oss);
    }

    @Override
    public synchronized void registerFilters(FiltersDTO filtersToRegister) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("registerFilters oss=... filtersToRegister={}", (Object)filtersToRegister);
        this.registerFilters(this.openSearchServiceTracker.getService(), filtersToRegister);
    }

    @Override
    public synchronized void registerFilters(OpenSearchService oss, FiltersDTO filtersToRegister) throws JsonGenerationException {
        LOGGER.info("registerFilters oss=... filtersToRegister={}", (Object)filtersToRegister);
        FiltersDTO currentRegisteredFilters = this.getRegisteredFilters(oss);
        LOGGER.info("Current registered filters: " + String.valueOf(currentRegisteredFilters));
        for (FilterDTO currentRegisteredFilter : currentRegisteredFilters.getFilters()) {
            boolean toRegister = filtersToRegister != null && filtersToRegister.containsFilter(currentRegisteredFilter);
            if (toRegister) continue;
            this.unregisterFilter(oss, currentRegisteredFilter);
        }
        if (filtersToRegister != null) {
            for (FilterDTO filterToRegister : filtersToRegister.getFilters()) {
                boolean alreadyRegistered = currentRegisteredFilters.containsFilter(filterToRegister);
                if (alreadyRegistered) continue;
                this.registerFilter(oss, filterToRegister);
            }
        }
    }

    @Override
    public synchronized ConnectedServersDTO getConnectedServers() throws ServiceNotFoundException {
        LOGGER.info("getConnectedServers");
        return this.getConnectedServers(this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized ConnectedServersDTO getConnectedServers(OpenSearchService oss) {
        LOGGER.info("getConnectedServers oss={}", (Object)oss);
        return this.getDTO("GET", "/_bpc/servers", null, ConnectedServersDTO.class, oss);
    }

    @Override
    public synchronized int orchestrateReplicationJobs(ReplicationJobsDTO replicationJobs) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("orchestrateReplicationJobs replicationJobs=...");
        Objects.requireNonNull(replicationJobs, "replicationJobs cannot be null");
        return this.sendDTO("POST", "/_bpc/replicationjobs", (OpenSearchPluginDTO)replicationJobs, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int sendForcedStartOfReplicationJobAction(String replicationJobId, UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendForcedStartOfReplicationJob replicationJobId={}, initiatedByUserSession=...", (Object)replicationJobId);
        Objects.requireNonNull(replicationJobId, "replicationJobId cannot be null");
        ReplicationJobForcedStartActionDTO forcedStartAction = new ReplicationJobForcedStartActionDTO(replicationJobId, this.coreBundleConfiguration.getServerUUID(), UserAuditLog.getOriginator(initiatedByUserSession));
        return this.sendDTO("POST", "/_bpc/replicationjobs/job/forced_start", (OpenSearchPluginDTO)forcedStartAction, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int sendRestartOfReplicationJobAction(String replicationJobId, UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendRestartOfReplicationJob replicationJobId={}, initiatedByUserSession=...", (Object)replicationJobId);
        Objects.requireNonNull(replicationJobId, "replicationJobId cannot be null");
        ReplicationJobRestartActionDTO restartAction = new ReplicationJobRestartActionDTO(replicationJobId, this.coreBundleConfiguration.getServerUUID(), UserAuditLog.getOriginator(initiatedByUserSession));
        return this.sendDTO("POST", "/_bpc/replicationjobs/job/restart", (OpenSearchPluginDTO)restartAction, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int sendRefreshLookupJoinsOfReplicationJobAction(String replicationJobId, UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendRefreshLookupJoinsOfReplicationJob replicationJobId={}, initiatedByUserSession={}", (Object)replicationJobId, (Object)initiatedByUserSession);
        Objects.requireNonNull(replicationJobId, "replicationJobId cannot be null");
        ReplicationJobRefreshLookupJoinsActionDTO refreshLookupJoinsOfReplicationJobAction = new ReplicationJobRefreshLookupJoinsActionDTO(replicationJobId, this.coreBundleConfiguration.getServerUUID(), UserAuditLog.getOriginator(initiatedByUserSession));
        return this.sendDTO("POST", "/_bpc/replicationjobs/job/refresh_lookupjoins", (OpenSearchPluginDTO)refreshLookupJoinsOfReplicationJobAction, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int sendRefreshLookupJoinsOfAllReplicationJobsAction(UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendRefreshLookupJoinsOfAllReplicationJobsAction initiatedByUserSession={}", (Object)initiatedByUserSession);
        ReplicationJobsRefreshLookupJoinsActionDTO refreshLookupJoinsOfAllReplicationJobAction = new ReplicationJobsRefreshLookupJoinsActionDTO(this.coreBundleConfiguration.getServerUUID(), UserAuditLog.getOriginator(initiatedByUserSession));
        return this.sendDTO("POST", "/_bpc/replicationjobs/refresh_lookupjoins", (OpenSearchPluginDTO)refreshLookupJoinsOfAllReplicationJobAction, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int sendClearLookupJoinCachesOfReplicationJobsAction(UserSession initiatedByUserSession) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendClearLookupJoinCachesOfReplicationJobsAction initiatedByUserSession={}", (Object)initiatedByUserSession);
        ReplicationJobsClearLookupJoinCachesActionDTO clearLookupJoinCachesActionDTO = new ReplicationJobsClearLookupJoinCachesActionDTO(this.coreBundleConfiguration.getServerUUID(), UserAuditLog.getOriginator(initiatedByUserSession));
        return this.sendDTO("POST", "/_bpc/replicationjobs/clear_lookupjoin_caches", (OpenSearchPluginDTO)clearLookupJoinCachesActionDTO, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized ReplicationJobsWithRuntimeStatsFromAllServersDTO getReplicationJobsWithRuntimeStatsFromAllServers() throws ServiceNotFoundException {
        LOGGER.info("getReplicationJobsWithRuntimeStatsFromAllServers");
        return this.getDTO("GET", "/_bpc/replicationjobs/stats", null, ReplicationJobsWithRuntimeStatsFromAllServersDTO.class, this.openSearchServiceTracker.getService());
    }

    @Override
    public ReplicationJobsDetailsDTO getReplicationJobsDetails() throws ServiceNotFoundException {
        LOGGER.info("getReplicationJobsDetails");
        return this.getDTO("GET", "/_bpc/replicationjobs/details", null, ReplicationJobsDetailsDTO.class, this.openSearchServiceTracker.getService());
    }

    @Override
    public boolean waitUntilReplicationJobsAreInState(Set<String> replicationJobIDs, String state, long timeoutInSeconds) throws ServiceNotFoundException {
        LOGGER.info("waitUntilReplicationJobsAreInState replicationJobIDs={}, state={}, timeoutInSeconds={}", replicationJobIDs, (Object)state, (Object)timeoutInSeconds);
        if (replicationJobIDs == null || replicationJobIDs.isEmpty()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        ReplicationJobsDetailsDTO replicationJobsDetails;
        boolean allJobsInRequiredState;
        while (!(allJobsInRequiredState = (replicationJobsDetails = this.getReplicationJobsDetails()).areAllOfThisReplicationJobsInState(replicationJobIDs, state))) {
            boolean timeout;
            boolean bl = timeout = startTime + timeoutInSeconds * 1000L < System.currentTimeMillis();
            if (timeout) {
                return false;
            }
            try {
                long ONE_SECOND_IN_MILLIS = 1000L;
                Thread.sleep(ONE_SECOND_IN_MILLIS);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return true;
    }

    @Override
    public synchronized BackupJobInfosDTO getBackupJobInfosFromMasterServer() throws ServiceNotFoundException {
        LOGGER.info("getBackupJobInfosFromMasterServer");
        return this.getDTO("GET", "/_bpc/backupjob/infos", null, BackupJobInfosDTO.class, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int sendDeleteBackupJobAction(String backupJobIdentifier) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendDeleteBackupJobAction backupJobIdentifier={}", (Object)backupJobIdentifier);
        Objects.requireNonNull(backupJobIdentifier, "backupJobIdentifier cannot be null");
        BackupJobDeleteActionDTO deleteBackupJobAction = new BackupJobDeleteActionDTO(backupJobIdentifier, this.coreBundleConfiguration.getServerUUID(), null);
        return this.sendDTO("DELETE", "/_bpc/backupjob", (OpenSearchPluginDTO)deleteBackupJobAction, this.openSearchServiceTracker.getService());
    }

    @Override
    public BackupSnapshotInfoDTO sendStartBackupJobAction(String backupJobIdentifier) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendStartBackupJobAction backupJobIdentifier={}", (Object)backupJobIdentifier);
        Objects.requireNonNull(backupJobIdentifier, "backupJobIdentifier cannot be null");
        BackupJobStartActionDTO startBackupJobAction = new BackupJobStartActionDTO(backupJobIdentifier, this.coreBundleConfiguration.getServerUUID(), null);
        return this.sendAndReceiveDTO("POST", "/_bpc/backupjob/start", (OpenSearchPluginDTO)startBackupJobAction, BackupSnapshotInfoDTO.class, this.openSearchServiceTracker.getService());
    }

    @Override
    public synchronized int sendScheduleBackupJobsAction(List<BackupJobScheduleActionEntryDTO> entries) throws ServiceNotFoundException, JsonGenerationException {
        LOGGER.info("sendScheduleBackupJobsAction entries={}", entries);
        Objects.requireNonNull(entries, "entries cannot be null");
        BackupJobScheduleActionDTO scheduleBackupJobAction = new BackupJobScheduleActionDTO(this.coreBundleConfiguration.getServerUUID(), null);
        for (BackupJobScheduleActionEntryDTO entry : entries) {
            scheduleBackupJobAction.setEntry(entry);
        }
        return this.sendDTO("POST", "/_bpc/backupjob/schedule", (OpenSearchPluginDTO)scheduleBackupJobAction, this.openSearchServiceTracker.getService());
    }

    private int sendDTO(String httpMethod, String httpEndpoint, OpenSearchPluginDTO dto, OpenSearchService oss) throws JsonGenerationException {
        int result;
        LOGGER.info("sendDTO httpMethod={}, httpEndpoint={}, dto={}, oss=...", (Object)httpMethod, (Object)httpEndpoint, (Object)dto);
        Objects.requireNonNull(httpMethod, "httpMethod cannot be null");
        Objects.requireNonNull(httpEndpoint, "httpEndpoint cannot be null");
        Objects.requireNonNull(dto, "dto cannot be null");
        Request request = new Request(httpMethod, httpEndpoint);
        this.setJsonEntity(request, dto);
        try {
            Response resp = oss.getClient().getLowLevelClient().performRequest(request);
            result = resp.getStatusLine().getStatusCode();
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'os-bpc-plugin' is installed and that the following endpoint is accessible: " + String.valueOf(request), null);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
            result = 500;
        }
        catch (Throwable t) {
            this.addError("Failed to send the '" + dto.getClass().getSimpleName() + "' to the 'os-bpc-plugin' using the endpoint: " + String.valueOf(request), t);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ERRORS);
            result = 500;
        }
        return result;
    }

    private void setJsonEntity(Request request, OpenSearchPluginDTO dto) throws JsonGenerationException {
        try {
            request.setJsonEntity(JsonUtil.asJsonString((ToXContent)dto));
        }
        catch (Exception ex) {
            throw new JsonGenerationException("Failed to get the '" + dto.getClass().getSimpleName() + "' as JSON.", (Throwable)ex);
        }
    }

    private <T extends OpenSearchPluginDTO> T getDTO(String httpMethod, String httpEndpoint, Map<String, String> httpParameters, Class<T> dtoClass, OpenSearchService oss) {
        OpenSearchPluginDTOResponse<T> dtoWithHost;
        LOGGER.info("getDTO httpMethod={}, httpEndpoint={}, httpParameters={}, dtoClass={}, oss=...", (Object)httpMethod, (Object)httpEndpoint, httpParameters, dtoClass);
        Request request = new Request(httpMethod, httpEndpoint);
        if (httpParameters != null) {
            request.addParameters(httpParameters);
        }
        return (dtoWithHost = this.getDTOWithHost(request, dtoClass, oss)) == null ? null : (T)dtoWithHost.getDto();
    }

    private <T extends OpenSearchPluginDTO> T sendAndReceiveDTO(String httpMethod, String httpEndpoint, OpenSearchPluginDTO dto, Class<T> dtoClass, OpenSearchService oss) throws JsonGenerationException {
        OpenSearchPluginDTOResponse<T> dtoWithHost;
        LOGGER.info("sendAndReceiveDTO httpMethod={}, httpEndpoint={}, dto={}, dtoClass={}, oss=...", (Object)httpMethod, (Object)httpEndpoint, (Object)dto, dtoClass);
        Request request = new Request(httpMethod, httpEndpoint);
        if (dto != null) {
            this.setJsonEntity(request, dto);
        }
        return (dtoWithHost = this.getDTOWithHost(request, dtoClass, oss)) == null ? null : (T)dtoWithHost.getDto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends OpenSearchPluginDTO> OpenSearchPluginDTOResponse<T> getDTOWithHost(Request request, Class<T> dtoClass, OpenSearchService oss) {
        LOGGER.info("getDTOWithHost request={}, dtoClass={}, oss=...", (Object)request, dtoClass);
        Objects.requireNonNull(request, "request cannot be null");
        Objects.requireNonNull(dtoClass, "dtoClass cannot be null");
        OpenSearchPluginDTOResponseImpl<OpenSearchPluginDTO> result = null;
        InputStream inputStream = null;
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Response resp = oss.getClient().getLowLevelClient().performRequest(request);
            inputStream = resp.getEntity().getContent();
            Map jsonResponseMap = (Map)objectMapper.readValue(inputStream, Map.class);
            OpenSearchPluginDTO dtoInstance = OpenSearchPluginDTOCreator.newInstance(dtoClass, (Map)jsonResponseMap);
            result = new OpenSearchPluginDTOResponseImpl<OpenSearchPluginDTO>(resp.getHost(), dtoInstance);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ACCESSIBLE);
        }
        catch (IOException ex) {
            this.addError("Please be sure that the 'os-bpc-plugin' is installed and that the following endpoint is accessible: " + String.valueOf(request), null);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.NOT_ACCESSIBLE);
        }
        catch (Throwable t) {
            this.addError("Failed to get the DTO '" + dtoClass.getSimpleName() + "' from the 'os-bpc-plugin' using the endpoint: " + String.valueOf(request), t);
            this.setPluginState(OpenSearchBpcPluginManager.PluginState.ERRORS);
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
        }
        return result;
    }
}

