/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.percolators;

import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorRelatedDatabaseIDs;
import de.virtimo.bpc.api.PercolatorsProcessor;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.percolators.PercolatorImpl;
import de.virtimo.bpc.core.percolators.PercolatorRelatedDatabaseIDsImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;

public class PercolatorsProcessorImpl
implements PercolatorsProcessor {
    private static final Logger LOGGER = LogManager.getLogger(PercolatorsProcessorImpl.class);
    private static final long DEFAULT_MAX_NUMBER_OF_PROCESSABLE_DATABASE_IDS = 5000L;
    private final OpenSearchService oss;
    private final String osIndex;
    private final Set<String> realIndexNames;
    private final Set<Percolator> percolators;
    private boolean alreadyProcessed;
    private List<String> databaseIDs;
    private long numberOfDatabaseIDs;
    private long maxNumberOfProcessableDatabaseIDs;
    private final Set<String> updatedDatabaseIDs;
    private final Map<Percolator, PercolatorRelatedDatabaseIDs> percolatorsAndTheirRelatedDatabaseIDs;
    private boolean deletedAlreadyProcessed;
    private final List<String> deletedDatabaseIDs;
    private long numberOfDeletedDatabaseIDs;

    public PercolatorsProcessorImpl(OpenSearchService oss, String osIndex, Set<Percolator> percolators) throws OpenSearchRelatedException {
        this.oss = oss;
        this.osIndex = osIndex;
        this.realIndexNames = oss.getIndexNamesWithAlias(osIndex);
        this.percolators = percolators;
        this.maxNumberOfProcessableDatabaseIDs = 5000L;
        this.percolatorsAndTheirRelatedDatabaseIDs = new HashMap<Percolator, PercolatorRelatedDatabaseIDs>();
        this.alreadyProcessed = false;
        this.databaseIDs = new ArrayList<String>();
        this.updatedDatabaseIDs = new HashSet<String>();
        this.numberOfDatabaseIDs = 0L;
        this.deletedAlreadyProcessed = false;
        this.deletedDatabaseIDs = new ArrayList<String>();
        this.numberOfDeletedDatabaseIDs = 0L;
    }

    @Override
    public boolean existSomePercolators() {
        return !this.percolators.isEmpty();
    }

    @Override
    public boolean hasData() {
        return this.numberOfDatabaseIDs > 0L || this.numberOfDeletedDatabaseIDs > 0L;
    }

    @Override
    public Set<Percolator> getAllPercolators() {
        return this.percolators;
    }

    @Override
    public void setMaxNumberOfProcessableDatabaseIDs(long maxNumberOfProcessableDatabaseIDs) {
        this.maxNumberOfProcessableDatabaseIDs = maxNumberOfProcessableDatabaseIDs;
    }

    @Override
    public Set<String> getUpdatedDatabaseIDs() {
        return this.updatedDatabaseIDs;
    }

    @Override
    public Set<String> getDeletedDatabaseIDs() {
        return new HashSet<String>(this.deletedDatabaseIDs);
    }

    @Override
    public long getNumberOfDeletedDatabaseIDs() {
        return this.numberOfDeletedDatabaseIDs;
    }

    @Override
    public long getNumberOfDatabaseIDs() {
        return this.numberOfDatabaseIDs;
    }

    @Override
    public boolean hasReceivedTooManyDatabaseIDsToGetThePercolatorsFor() {
        return this.numberOfDatabaseIDs + this.numberOfDeletedDatabaseIDs > this.maxNumberOfProcessableDatabaseIDs;
    }

    @Override
    @NotNull
    public Map<Percolator, PercolatorRelatedDatabaseIDs> getPercolatorsAndTheirRelatedDatabaseIDs() {
        return this.percolatorsAndTheirRelatedDatabaseIDs;
    }

    @Override
    public void keepDeletedDatabaseIDs(Set<String> databaseIDs) {
        LOGGER.info("keepDeletedDatabaseIDs databaseIDs=...");
        if (databaseIDs != null && this.existSomePercolators()) {
            this.deletedDatabaseIDs.addAll(databaseIDs);
            this.numberOfDeletedDatabaseIDs = this.deletedDatabaseIDs.size();
        }
    }

    @Override
    public void keepDatabaseIDsFromBulkResponse(BulkResponse bulkResponse) {
        LOGGER.info("keepDatabaseIDsFromBulkResponse");
        if (bulkResponse != null && this.existSomePercolators()) {
            for (BulkItemResponse bulkItemResponse : bulkResponse) {
                if (bulkItemResponse.isFailed()) continue;
                String index = bulkItemResponse.getIndex();
                String databaseId = bulkItemResponse.getId();
                if (!this.osIndex.equals(index) && !this.realIndexNames.contains(index)) continue;
                this.databaseIDs.add(databaseId);
                if (bulkItemResponse.getVersion() <= 1L) continue;
                this.updatedDatabaseIDs.add(databaseId);
            }
            this.numberOfDatabaseIDs = this.databaseIDs.size();
        }
    }

    @Override
    public void process() throws OpenSearchRelatedException {
        LOGGER.info("process");
        if (this.alreadyProcessed) {
            LOGGER.warn("process() can only be called once!");
            return;
        }
        this.alreadyProcessed = true;
        try {
            this.processDatabaseIDs(this.databaseIDs, ProcessingMode.ForNewOrUpdatedDatabaseIDs);
        }
        finally {
            this.databaseIDs = null;
        }
    }

    @Override
    public void processForDeleted() throws OpenSearchRelatedException {
        LOGGER.info("processForDeleted");
        if (this.deletedAlreadyProcessed) {
            LOGGER.warn("processForDeleted() can only be called once!");
            return;
        }
        this.deletedAlreadyProcessed = true;
        this.processDatabaseIDs(this.deletedDatabaseIDs, ProcessingMode.ForDeletedDatabaseIDs);
    }

    private void processDatabaseIDs(List<String> dbIDs, ProcessingMode processingMode) throws OpenSearchRelatedException {
        LOGGER.info("processDatabaseIDs dbIDs=..., processingMode={}", (Object)processingMode);
        if (!this.existSomePercolators()) {
            LOGGER.info("No percolators found, means nothing to do.");
            return;
        }
        if (this.hasReceivedTooManyDatabaseIDsToGetThePercolatorsFor()) {
            LOGGER.info("Received too many database IDs in general to get the percolators for. Caller must force a reload to get up to date data.");
            return;
        }
        if (dbIDs.isEmpty()) {
            LOGGER.info("No database IDs given, means nothing to do.");
            return;
        }
        LOGGER.info("Processing number of database IDs: {}", (Object)dbIDs.size());
        try {
            RestHighLevelClient osClient = this.oss.getClient();
            MultiSearchRequest multiPercolatorsSearchRequest = PercolatorsProcessorImpl.prepareMultiPercolateSearchRequest(this.osIndex, dbIDs);
            MultiSearchResponse multiPercolateSearchResponse = osClient.msearch(multiPercolatorsSearchRequest, RequestOptions.DEFAULT);
            MultiSearchResponse.Item[] items = multiPercolateSearchResponse.getResponses();
            for (int i = 0; i < dbIDs.size(); ++i) {
                String processedID = dbIDs.get(i);
                SearchResponse searchResponse = items[i].getResponse();
                if (searchResponse == null || searchResponse.getHits().getTotalHits().value() <= 0L) continue;
                do {
                    for (SearchHit hit : searchResponse.getHits().getHits()) {
                        String matchedPercolatorUID = hit.getId();
                        PercolatorImpl percolator = new PercolatorImpl(this.osIndex, matchedPercolatorUID);
                        if (!percolator.isValid()) continue;
                        PercolatorRelatedDatabaseIDs ids = this.percolatorsAndTheirRelatedDatabaseIDs.get(percolator);
                        if (ids == null) {
                            ids = new PercolatorRelatedDatabaseIDsImpl();
                            this.percolatorsAndTheirRelatedDatabaseIDs.put(percolator, ids);
                        }
                        if (processingMode == ProcessingMode.ForDeletedDatabaseIDs) {
                            ids.keepAsDeletedDatabaseId(processedID);
                            continue;
                        }
                        if (processingMode != ProcessingMode.ForNewOrUpdatedDatabaseIDs) continue;
                        ids.keepAsNewOrUpdatedDatabaseId(processedID);
                    }
                } while ((searchResponse = searchResponse.getScrollId() != null ? osClient.scroll(new SearchScrollRequest(searchResponse.getScrollId()).scroll(new TimeValue(60000L)), RequestOptions.DEFAULT) : null) != null && searchResponse.getHits().getHits().length != 0);
                this.oss.releaseScrollId(searchResponse);
            }
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private static MultiSearchRequest prepareMultiPercolateSearchRequest(String osIndex, List<String> ids) {
        LOGGER.debug("prepareMultiPercolateSearch osIndex={}, ids=...", (Object)osIndex);
        MultiSearchRequest multiSearchRequests = new MultiSearchRequest();
        for (String id : ids) {
            QueryBuilder pQuery = PercolatorsProcessorImpl.percolateQuery(osIndex, "_percolator_query", id);
            SearchRequest sr = new SearchRequest().indices(osIndex).source(new SearchSourceBuilder().size(100).query(QueryBuilders.constantScoreQuery(pQuery))).scroll(new TimeValue(60000L));
            multiSearchRequests.add(sr);
        }
        return multiSearchRequests;
    }

    private static QueryBuilder percolateQuery(String index, String field, String documentId) {
        return QueryBuilders.wrapperQuery("{\n  \"percolate\": {\n    \"index\": \"$$index$$\",\n    \"field\": \"$$field$$\",\n    \"id\": \"$$documentId$$\"\n  }\n}\n".replace("$$index$$", index).replace("$$field$$", field).replace("$$documentId$$", documentId));
    }

    private static enum ProcessingMode {
        ForNewOrUpdatedDatabaseIDs,
        ForDeletedDatabaseIDs;

    }
}

