/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator;

import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.PercolatorsProcessor;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.core.lookupjoins.LookupJoins;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobAlreadyStartedException;
import de.virtimo.bpc.core.replicator.ReplicationJobCallback;
import de.virtimo.bpc.core.replicator.ReplicationJobException;
import de.virtimo.bpc.core.replicator.ReplicationJobNotFoundException;
import de.virtimo.bpc.core.replicator.ReplicationManager;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheck;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckResult;
import de.virtimo.bpc.core.replicator.consistency.ConsistencyCheckTask;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobLogData;
import de.virtimo.bpc.core.replicator.logger.ReplicationJobsLogService;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopy;
import de.virtimo.bpc.core.replicator.shadowcopy.ShadowCopyTask;
import de.virtimo.bpc.core.replicator.tailsync.TailSyncTask;
import de.virtimo.bpc.core.service.QuartzSchedulerService;
import de.virtimo.bpc.util.ThreadFactoryWithNamePrefix;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ReplicationManagerImpl
implements ReplicationManager,
ReplicationJobCallback,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationManagerImpl.class);
    private final BundleContext bundleContext;
    private ReplicationModule replicationModule;
    private final Map<String, ReplicationJob> jobs;
    private final Map<String, ScheduledFuture<?>> replicationJobHandles;
    private ScheduledThreadPoolExecutor executorService;
    private final ExecutorService percolatorsExecutorService;
    private final ExecutorService consistencyCheckExecutorService;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<DatabaseManager> databaseManagerTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<ReplicationJobsLogService> replicationJobsLogServiceTracker;
    private final BpcServicesTracker<QuartzSchedulerService> quartzSchedulerServiceTracker;
    private static final Object REPLICATION_JOBS_LOCK = new Object();

    public ReplicationManagerImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.replicationJobsLogServiceTracker = new BpcServicesTracker<ReplicationJobsLogService>(bundleContext, ReplicationJobsLogService.class);
        this.quartzSchedulerServiceTracker = new BpcServicesTracker<QuartzSchedulerService>(bundleContext, QuartzSchedulerService.class);
        this.percolatorsExecutorService = Executors.newFixedThreadPool(3, new ThreadFactoryWithNamePrefix("bpc-core-replication-done-percolators"));
        this.consistencyCheckExecutorService = Executors.newFixedThreadPool(1, new ThreadFactoryWithNamePrefix("bpc-core-replication-done-consistencycheck"));
        this.jobs = new HashMap<String, ReplicationJob>();
        this.replicationJobHandles = new HashMap();
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void initialize(ReplicationModule replicationModule) {
        LOGGER.info("initialize replicationModule={}", (Object)replicationModule);
        this.replicationModule = replicationModule;
        if (this.executorService == null) {
            this.executorService = new ScheduledThreadPoolExecutor((int)replicationModule.getReplicatorThreadCount(), new ThreadFactoryWithNamePrefix("bpc-core-replication"));
            this.executorService.setRemoveOnCancelPolicy(true);
            this.executorService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        }
    }

    @Override
    public void shutdownService() {
        LOGGER.info("shutdownService");
        this.stopAllReplicationJobs();
        if (this.executorService != null) {
            try {
                this.executorService.shutdownNow();
            }
            finally {
                this.executorService = null;
            }
        }
        try {
            this.quartzSchedulerServiceTracker.getService().deleteAllJobsOfGroup("tail_sync");
        }
        catch (Exception ex) {
            LOGGER.error("Error deleting the scheduled tail sync tasks.", (Throwable)ex);
        }
        try {
            this.quartzSchedulerServiceTracker.getService().deleteAllJobsOfGroup("shadow_copy");
        }
        catch (Exception ex) {
            LOGGER.error("Error deleting the scheduled shadow copy tasks.", (Throwable)ex);
        }
        BpcServicesTracker.stopAll(this);
        if (this.percolatorsExecutorService != null) {
            this.percolatorsExecutorService.shutdownNow();
        }
        if (this.consistencyCheckExecutorService != null) {
            this.consistencyCheckExecutorService.shutdownNow();
        }
        this.replicationModule = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAllReplicationJobs() {
        LOGGER.info("stopAllReplicationJobs");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            HashSet<String> replicationJobIDs = new HashSet<String>(this.jobs.keySet());
            for (String replicationJobID : replicationJobIDs) {
                this._stopReplicationJob(replicationJobID);
            }
            if (!this.jobs.isEmpty() || !this.replicationJobHandles.isEmpty()) {
                LOGGER.error("BPC developers, there is a bug/problem in the replication ReplicationManagerImpl.stop() method.");
                LOGGER.error("- jobs.......................: {}", (Object)this.jobs.size());
                LOGGER.error("- replicationJobHandles......: {}", (Object)this.replicationJobHandles.size());
            }
            this.jobs.clear();
            this.replicationJobHandles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopReplicationJob(String replicationJobId) {
        LOGGER.info("stopReplicationJob replicationJobId={}", (Object)replicationJobId);
        Objects.requireNonNull(replicationJobId, "'replicationJobId' must not be null");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            this._stopReplicationJob(replicationJobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stopReplicationJob(String replicationJobId) {
        LOGGER.info("_stopReplicationJob replicationJobId={}", (Object)replicationJobId);
        Objects.requireNonNull(replicationJobId, "'replicationJobId' must not be null");
        if (this.replicationJobHandles.containsKey(replicationJobId)) {
            try {
                ScheduledFuture<?> replicationJobHandle = this.replicationJobHandles.get(replicationJobId);
                if (replicationJobHandle.cancel(true)) {
                    LOGGER.info("Running ReplicationJob '{}' canceled", (Object)replicationJobId);
                } else {
                    LOGGER.warn("Could not cancel the running ReplicationJob '{}'", (Object)replicationJobId);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to cancel the scheduled ReplicationJob '{}'.", (Object)replicationJobId, (Object)ex);
            }
            finally {
                this.replicationJobHandles.remove(replicationJobId);
            }
        }
        if (this.jobs.containsKey(replicationJobId)) {
            try {
                ReplicationJob replicationJobToStop = this.jobs.get(replicationJobId);
                replicationJobToStop.destroy();
            }
            catch (Exception ex) {
                LOGGER.error("Failed to destroy the ReplicationJob '{}'.", (Object)replicationJobId, (Object)ex);
            }
            finally {
                this.jobs.remove(replicationJobId);
            }
        }
        try {
            this.quartzSchedulerServiceTracker.getService().deleteJob(replicationJobId, "tail_sync");
        }
        catch (Exception ex) {
            LOGGER.error("Failed to un-schedule the tail sync task of the ReplicationJob '{}'.", (Object)replicationJobId, (Object)ex);
        }
        try {
            this.quartzSchedulerServiceTracker.getService().deleteJob(replicationJobId, "shadow_copy");
        }
        catch (Exception ex) {
            LOGGER.error("Failed to un-schedule the shadow copy task of the ReplicationJob '{}'.", (Object)replicationJobId, (Object)ex);
        }
    }

    @Override
    public ScheduledExecutorService getReplicationScheduler() {
        return this.executorService;
    }

    @Override
    public void setReplicatorThreadCount(Integer threadCount) {
        LOGGER.info("setReplicatorThreadCount replicatorThreadCount={}", (Object)threadCount);
        if (threadCount != null && this.executorService != null) {
            this.executorService.setCorePoolSize(threadCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startReplicationJob(String replicationJobId) throws ReplicationJobNotFoundException, ReplicationJobAlreadyStartedException {
        LOGGER.info("startReplicationJob replicationJobId={}", (Object)replicationJobId);
        Objects.requireNonNull(replicationJobId, "'replicationJobId' must not be null");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (this.jobs.containsKey(replicationJobId)) {
                LOGGER.warn("Failed to start the replication job with the ID '{}', because it is already started.", (Object)replicationJobId);
                throw new ReplicationJobAlreadyStartedException(replicationJobId);
            }
            ReplicationJob replicationJobToStart = this.replicationModule.getReplicationJob(replicationJobId);
            this._startReplicationJob(replicationJobToStart);
        }
    }

    private void _startReplicationJob(ReplicationJob job) {
        LOGGER.debug("_startReplicationJob job={}", (Object)job);
        if (job != null) {
            String replicationJobId = job.getId();
            job.setCallback(this);
            this.jobs.put(replicationJobId, job);
            ScheduledFuture<?> replicationJobHandle = this.executorService.scheduleWithFixedDelay(job, job.getSettings().getReplicationDelay(), job.getSettings().getReplicationInterval(), TimeUnit.SECONDS);
            this.replicationJobHandles.put(replicationJobId, replicationJobHandle);
            if (job.isEnabled()) {
                if (job.getShadowCopy().isEnabled()) {
                    LOGGER.info("Scheduling shadow copy task for replication job: {}", (Object)job);
                    try {
                        this.scheduleShadowCopyTask(job);
                    }
                    catch (ServiceNotFoundException | SchedulerException ex) {
                        LOGGER.error("Failed to schedule the shadow copy task job.", ex);
                    }
                } else {
                    LOGGER.info("Skipping shadow copy task scheduling, it is disabled for replication job: {}", (Object)job);
                }
            } else {
                LOGGER.info("Skipping shadow copy task scheduling, the related replication job is disabled: {}", (Object)job);
            }
            if (job.isEnabled()) {
                if (job.getTailSync().isEnabled()) {
                    LOGGER.info("Scheduling tail sync task for replication job: {}", (Object)job);
                    try {
                        this.scheduleTailSyncTask(job);
                    }
                    catch (ServiceNotFoundException | SchedulerException ex) {
                        LOGGER.error("Failed to schedule the tail sync task job.", ex);
                    }
                } else {
                    LOGGER.info("Skipping tail sync scheduling, it is disabled for replication job: {}", (Object)job);
                }
            } else {
                LOGGER.info("Skipping tail sync task scheduling, the related replication job is disabled: {}", (Object)job);
            }
        }
    }

    private void scheduleShadowCopyTask(ReplicationJob replicationJob) throws ServiceNotFoundException, SchedulerException {
        LOGGER.debug("scheduleShadowCopyTask replicationJob=...");
        String replicationJobId = replicationJob.getId();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.setAllowsTransientData(true);
        jobDataMap.put("replicationJob", (Object)replicationJob);
        JobDetail shadowCopyTaskJob = JobBuilder.newJob(ShadowCopyTask.class).withIdentity(JobKey.jobKey((String)replicationJobId, (String)"shadow_copy")).usingJobData(jobDataMap).build();
        CronTrigger shadowCopyTaskJobTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)replicationJobId, (String)"shadow_copy_trigger")).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)replicationJob.getShadowCopy().getCronPattern())).forJob(shadowCopyTaskJob).build();
        this.quartzSchedulerServiceTracker.getService().scheduleJob(shadowCopyTaskJob, (Trigger)shadowCopyTaskJobTrigger);
    }

    private void scheduleTailSyncTask(ReplicationJob replicationJob) throws ServiceNotFoundException, SchedulerException {
        LOGGER.debug("scheduleTailSyncTask replicationJob=...");
        String replicationJobId = replicationJob.getId();
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.setAllowsTransientData(true);
        jobDataMap.put("replicationJob", (Object)replicationJob);
        jobDataMap.put("callback", (Object)this);
        JobDetail tailSyncTaskJob = JobBuilder.newJob(TailSyncTask.class).withIdentity(JobKey.jobKey((String)replicationJobId, (String)"tail_sync")).usingJobData(jobDataMap).build();
        CronTrigger tailSyncTaskJobTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(replicationJobId, "tail_sync_trigger").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)replicationJob.getTailSync().getCronPattern())).forJob(tailSyncTaskJob).build();
        this.quartzSchedulerServiceTracker.getService().scheduleJob(tailSyncTaskJob, (Trigger)tailSyncTaskJobTrigger);
    }

    @Override
    public void onFinished(String replicationType, final ReplicationJob replicationJob, final PercolatorsProcessor percolatorsProcessor) {
        ConsistencyCheck consistencyCheck;
        LOGGER.info("onFinished replicationType={}, replicationJob={}, percolatorsProcessor={}", (Object)replicationType, (Object)replicationJob, (Object)percolatorsProcessor);
        if (percolatorsProcessor.existSomePercolators() && percolatorsProcessor.hasData()) {
            Runnable percolatorsRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        PercolatorsManager percolatorsManager = ReplicationManagerImpl.this.percolatorsManagerTracker.getService(15L);
                        OpenSearchService oss = ReplicationManagerImpl.this.openSearchServiceTracker.getService(15L);
                        percolatorsManager.informClientsAboutReplicatedData(oss, replicationJob.getTarget().getIndex(), percolatorsProcessor);
                    }
                    catch (ServiceNotFoundException ex) {
                        LOGGER.warn("Failed to process the collected percolators data due to missing service.", (Throwable)ex);
                    }
                    catch (OpenSearchRelatedException ex) {
                        LOGGER.warn("Failed to process the collected percolators data due to a OpenSearch failure.", (Throwable)ex);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Failed to process the collected percolators data due to an unexpected error.", (Throwable)ex);
                    }
                }
            };
            this.percolatorsExecutorService.submit(percolatorsRunnable);
        }
        if ("replication".equals(replicationType) && (consistencyCheck = replicationJob.getConsistencyCheck()).isEnabled() && !consistencyCheck.isRunning() && replicationJob.getStats().getJobCount() % consistencyCheck.getConsistencyCheckFrequency() == 0) {
            Runnable consistencyCheckRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        DatabaseManager databaseManager = ReplicationManagerImpl.this.databaseManagerTracker.getService(15L);
                        OpenSearchService oss = ReplicationManagerImpl.this.openSearchServiceTracker.getService(15L);
                        try {
                            oss.flushIndices(replicationJob.getTarget().getIndex());
                        }
                        catch (OpenSearchRelatedException openSearchRelatedException) {
                            // empty catch block
                        }
                        try {
                            consistencyCheck.started();
                            DataSource dataSource = databaseManager.getDataSource(replicationJob.getSource().getDataSourceName());
                            ConsistencyCheckTask consistencyCheckTask = new ConsistencyCheckTask(replicationJob.getId(), replicationJob.getSettings(), replicationJob.getSource(), replicationJob.getTarget(), dataSource, oss);
                            ConsistencyCheckResult consistencyCheckResult = consistencyCheckTask.process();
                            consistencyCheck.setLastRunResult(consistencyCheckResult);
                            consistencyCheck.increaseRunCount();
                            LOGGER.info("{}: Replication job result is consistent: {}", (Object)replicationJob.getId(), (Object)consistencyCheckResult.areSourceAndTargetConsistent());
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to perform the replication job consistency check.", (Throwable)ex);
                            consistencyCheck.increaseErrorCount();
                        }
                        finally {
                            consistencyCheck.stopped();
                        }
                    }
                    catch (ServiceNotFoundException ex) {
                        LOGGER.warn("Failed to perform the replication job consistency check due to missing service.", (Throwable)ex);
                    }
                }
            };
            this.consistencyCheckExecutorService.submit(consistencyCheckRunnable);
        }
    }

    @Override
    public OpenSearchService getOpenSearchService() throws ServiceNotFoundException {
        LOGGER.debug("getOpenSearchService");
        return this.openSearchServiceTracker.getService();
    }

    @Override
    public Connection getDatabaseConnection(ReplicationJob replicationJob) throws ServiceNotFoundException, DataSourceNotFoundException, SQLException {
        LOGGER.debug("getDatabaseConnection replicationJob=...");
        String dataSourceName = replicationJob.getSource().getDataSourceName();
        DataSource dataSource = this.databaseManagerTracker.getService().getDataSource(dataSourceName);
        return dataSource.getConnection();
    }

    @Override
    public LookupJoins getLookupJoins(ReplicationJob replicationJob) {
        LOGGER.debug("getLookupJoins replicationJob=...");
        return this.replicationModule.getLookupJoinsOfReplicationJob(replicationJob.getId());
    }

    @Override
    public Set<Percolator> getAllValidPercolatorsFromIndex(OpenSearchService oss, String index) throws ServiceNotFoundException {
        LOGGER.debug("getAllValidPercolatorsFromIndex oss=..., index={}", (Object)index);
        return this.percolatorsManagerTracker.getService().getAllValidPercolatorsFromIndex(oss, index);
    }

    @Override
    public void persistReplicationJobLogData(ReplicationJobLogData replicationJobLogData) {
        LOGGER.debug("persistReplicationJobLogData replicationJobsLogData=...");
        try {
            ReplicationJobsLogService replicationJobsLogService = this.replicationJobsLogServiceTracker.getService();
            replicationJobsLogService.log(replicationJobLogData);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to persist the replication job log data.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<ReplicationJob> getJobs() {
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            return new ArrayList<ReplicationJob>(this.jobs.values());
        }
    }

    @Override
    public void forcedStartOfReplicationJob(String replicationJobId) throws ReplicationJobException {
        LOGGER.info("forcedStartOfReplicationJob replicationJobId={}", (Object)replicationJobId);
        Objects.requireNonNull(replicationJobId, "'replicationJobId' must not be null");
        if (this.jobs.containsKey(replicationJobId)) {
            ReplicationJob replicationJob = this.jobs.get(replicationJobId);
            if (!replicationJob.isEnabled()) {
                throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_DISABLED, "Replication job is disabled.");
            }
            if (replicationJob.getStats().isRunning()) {
                throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_ALREADY_RUNNING, "Replication job is running at the moment.");
            }
            ShadowCopy shadowCopy = replicationJob.getShadowCopy();
            if (shadowCopy != null && shadowCopy.isEnabled() && shadowCopy.isRunning()) {
                throw new ReplicationJobException((ErrorCode)CoreErrorCode.REPLICATION_JOB_SHADOW_COPY_RUNNING, "Replication job cannot be started due to running shadow copy task.");
            }
            replicationJob.run();
        } else {
            LOGGER.warn("The forced start of replication job '{}' is not possible, because it is not running on this server.", (Object)replicationJobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartOfReplicationJob(String replicationJobId) throws OpenSearchRelatedException, ServiceNotFoundException {
        LOGGER.info("restartOfReplicationJob replicationJobId={}", (Object)replicationJobId);
        Objects.requireNonNull(replicationJobId, "'replicationJobId' must not be null");
        Object object = REPLICATION_JOBS_LOCK;
        synchronized (object) {
            if (this.jobs.containsKey(replicationJobId)) {
                ReplicationJob replicationJob = this.jobs.get(replicationJobId);
                replicationJob.resetLastUpdateTimestampOnRestart();
            } else {
                LOGGER.warn("Restarting the replication job '{}' is not possible, because it is not running on this server.", (Object)replicationJobId);
            }
        }
    }
}

