/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.shadowcopy;

import de.virtimo.bpc.api.ModuleConfiguration;
import java.util.Date;
import java.util.Objects;

public class ShadowCopy {
    public static final String SHADOWCOPY_ENABLED_FIELD = "replicationShadowCopyEnabled";
    public static final String SHADOWCOPY_CRON_PATTERN_FIELD = "replicationShadowCopyCronPattern";
    public static final String SHADOWCOPY_KEEP_COPIES_COUNT_FIELD = "replicationShadowCopyKeepCopiesCount";
    public static final boolean DEFAULT_SHADOWCOPY_ENABLED = false;
    public static final String DEFAULT_SHADOWCOPY_CRON_PATTERN = "0 0 16 ? * Sun";
    public static final int DEFAULT_SHADOWCOPY_KEEP_COPIES_COUNT = 3;
    private final boolean enabled;
    private final String cronPattern;
    private final int keepCopiesCount;
    private transient boolean running;
    private transient Date lastRunStart;
    private transient Date lastRunEnd;

    public ShadowCopy(ModuleConfiguration jobConfig) {
        this(jobConfig.getSettingValue(SHADOWCOPY_ENABLED_FIELD).asBoolean(false), jobConfig.getSettingValue(SHADOWCOPY_CRON_PATTERN_FIELD).asString(DEFAULT_SHADOWCOPY_CRON_PATTERN), jobConfig.getSettingValue(SHADOWCOPY_KEEP_COPIES_COUNT_FIELD).asInt(3));
    }

    private ShadowCopy(Builder builder) {
        this(builder.enabled, builder.cronPattern, builder.keepCopiesCount);
    }

    public ShadowCopy(boolean enabled, String cronPattern, int keepCopiesCount) {
        this.enabled = enabled;
        this.cronPattern = cronPattern;
        this.keepCopiesCount = keepCopiesCount;
        this.running = false;
        this.lastRunEnd = null;
        this.lastRunStart = null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCronPattern() {
        return this.cronPattern;
    }

    public int getKeepCopiesCount() {
        return this.keepCopiesCount;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Date getLastRunStart() {
        return this.lastRunStart;
    }

    public void setLastRunStart(Date lastRunStart) {
        this.lastRunStart = lastRunStart;
    }

    public Date getLastRunEnd() {
        return this.lastRunEnd;
    }

    public void setLastRunEnd(Date lastRunEnd) {
        this.lastRunEnd = lastRunEnd;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ShadowCopy)) {
            return false;
        }
        ShadowCopy that = (ShadowCopy)o;
        return this.enabled == that.enabled && this.keepCopiesCount == that.keepCopiesCount && Objects.equals(this.cronPattern, that.cronPattern);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.cronPattern, this.keepCopiesCount);
    }

    public String toString() {
        return "ShadowCopy{enabled=" + this.enabled + ", cronPattern='" + this.cronPattern + "', keepCopiesCount=" + this.keepCopiesCount + ", running=" + this.running + ", lastRunStart=" + String.valueOf(this.lastRunStart) + ", lastRunEnd=" + String.valueOf(this.lastRunEnd) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean enabled = false;
        private String cronPattern = "0 0 16 ? * Sun";
        private int keepCopiesCount = 3;

        private Builder() {
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder cronPattern(String cronPattern) {
            this.cronPattern = cronPattern;
            return this;
        }

        public Builder keepCopiesCount(int keepCopiesCount) {
            this.keepCopiesCount = keepCopiesCount;
            return this;
        }

        public ShadowCopy build() {
            return new ShadowCopy(this);
        }
    }
}

