/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.replicator.tailsync;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.Percolator;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.PercolatorsProcessor;
import de.virtimo.bpc.api.db.DatabaseManager;
import de.virtimo.bpc.api.db.exception.DataSourceNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.percolators.PercolatorsProcessorImpl;
import de.virtimo.bpc.core.replicator.DbResultSetToJsonConverter;
import de.virtimo.bpc.core.replicator.ReplicationJob;
import de.virtimo.bpc.core.replicator.ReplicationJobCallback;
import de.virtimo.bpc.core.replicator.ReplicationJobSettings;
import de.virtimo.bpc.core.replicator.ReplicationSource;
import de.virtimo.bpc.core.replicator.ReplicationTarget;
import de.virtimo.bpc.core.replicator.tailsync.GetDataResult;
import de.virtimo.bpc.core.replicator.tailsync.RecordData;
import de.virtimo.bpc.core.replicator.tailsync.TailSync;
import de.virtimo.bpc.core.replicator.tailsync.TailSyncDatabaseHandler;
import de.virtimo.bpc.core.replicator.tailsync.TailSyncOpenSearchHandler;
import de.virtimo.bpc.util.DateUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.bulk.BulkProcessor;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.XContentBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class TailSyncTask
implements InterruptableJob {
    private static final Logger LOGGER = LogManager.getLogger(TailSyncTask.class);
    private String replicationJobId;
    private boolean cancelled = false;

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void interrupt() throws UnableToInterruptJobException {
        LOGGER.info("{}: interrupt", (Object)this.replicationJobId);
        this.cancelled = true;
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        ReplicationJob replicationJob = (ReplicationJob)jobDataMap.get((Object)"replicationJob");
        ReplicationJobCallback replicationJobCallback = (ReplicationJobCallback)jobDataMap.get((Object)"callback");
        this.replicationJobId = replicationJob.getId();
        LOGGER.info("{}: execute jobExecutionContext={}", (Object)this.replicationJobId, (Object)jobExecutionContext);
        BundleContext bundleContext = FrameworkUtil.getBundle(TailSyncTask.class).getBundleContext();
        TailSync tailSync = replicationJob.getTailSync();
        if (tailSync.isRunning()) {
            LOGGER.warn("{}: Skipping the tail sync task execution. There is already a running task.", (Object)this.replicationJobId);
            return;
        }
        if (!replicationJob.isEnabled()) {
            LOGGER.warn("{}: Skipping the tail sync task execution. The related replication job is disabled.", (Object)this.replicationJobId);
            return;
        }
        if (!tailSync.isEnabled()) {
            LOGGER.warn("{}: Skipping the tail sync task execution. It is disabled.", (Object)this.replicationJobId);
            return;
        }
        if (!replicationJob.isReplicatingLatestRecords()) {
            LOGGER.warn("{}: Skipping the tail sync task execution. The related replication job is still in the middle of its work and does not already replicate just the latest records.", (Object)this.replicationJobId);
            return;
        }
        BpcServicesTracker<DatabaseManager> databaseManagerTracker = new BpcServicesTracker<DatabaseManager>(bundleContext, DatabaseManager.class);
        BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        BpcServicesTracker<OpenSearchService> openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        try (BpcServicesTracker<DatabaseManager> bpcServicesTracker = databaseManagerTracker;
             BpcServicesTracker<PercolatorsManager> bpcServicesTracker2 = percolatorsManagerTracker;
             BpcServicesTracker<OpenSearchService> bpcServicesTracker3 = openSearchServiceTracker;){
            DatabaseManager databaseManager = databaseManagerTracker.getService();
            PercolatorsManager percolatorsManager = percolatorsManagerTracker.getService();
            OpenSearchService oss = openSearchServiceTracker.getService();
            DbResultSetToJsonConverter dbResultSetToJsonConverter = replicationJob.createDbResultSetToJsonConverter(oss);
            DataSource dataSource = databaseManager.getDataSource(replicationJob.getSource().getDataSourceName());
            PercolatorsProcessor percolatorsProcessor = this.performTailSync(dataSource, oss, tailSync, replicationJob.getSettings(), replicationJob.getSource(), replicationJob.getTarget(), dbResultSetToJsonConverter, percolatorsManager);
            if (percolatorsProcessor != null) {
                replicationJobCallback.onFinished("tailsync", replicationJob, percolatorsProcessor);
            }
        }
        catch (ServiceNotFoundException ex) {
            LOGGER.warn("{}: Skipping the tail sync task execution. Required services are unexpectedly unavailable: {}", (Object)this.replicationJobId, (Object)ex.getMessage());
        }
        catch (DataSourceNotFoundException ex) {
            LOGGER.warn("{}: Skipping the tail sync task execution. Did not get the required data source: {}", (Object)this.replicationJobId, (Object)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PercolatorsProcessor performTailSync(DataSource dataSource, OpenSearchService oss, TailSync tailSync, ReplicationJobSettings replicationJobSettings, ReplicationSource replicationSource, ReplicationTarget replicationTarget, DbResultSetToJsonConverter dbResultSetToJsonConverter, PercolatorsManager percolatorsManager) {
        LOGGER.info("{}: performTailSync dataSource=..., oss=..., tailSync=..., replicationJobSettings=..., replicationSource=..., replicationTarget=..., dbResultSetToJsonConverter=..., percolatorsManager=...", (Object)this.replicationJobId);
        tailSync.setRunning(true);
        tailSync.setLastRunStart(new Date());
        tailSync.setLastRunEnd(null);
        tailSync.increaseRunCount();
        long tailSyncStartTimestamp = System.currentTimeMillis();
        long amountMissingDatabaseRecords = 0L;
        long amountUpdatedDatabaseRecords = 0L;
        long amountDeletedDatabaseRecords = 0L;
        TailSyncOpenSearchHandler osHandler = null;
        TailSyncDatabaseHandler dbHandler = null;
        try {
            Timestamp lowerDateLimit;
            Timestamp deleteOlderThanTimestamp;
            if (!oss.existsIndex(replicationTarget.getIndex())) {
                LOGGER.info("{}: Nothing to do, the target index {} does not exist. Regular replication must run first.", (Object)this.replicationJobId, (Object)replicationTarget.getIndex());
                PercolatorsProcessor percolatorsProcessor = null;
                return percolatorsProcessor;
            }
            osHandler = new TailSyncOpenSearchHandler(oss, replicationTarget, this.replicationJobId);
            dbHandler = new TailSyncDatabaseHandler(dataSource, this.replicationJobId);
            dbHandler.initVamWorkaround(replicationJobSettings.getVamOrganizationId());
            dbHandler.initSelectByIdPreparedStatement(replicationSource);
            dbHandler.initSelectByRangePreparedStatements(tailSync.getBlockSize(), replicationSource);
            HashSet<Percolator> percolatorsFromIndex = percolatorsManager == null ? new HashSet<Percolator>() : percolatorsManager.getAllValidPercolatorsFromIndex(oss, replicationTarget.getIndex());
            final PercolatorsProcessorImpl percolatorsProcessor = new PercolatorsProcessorImpl(oss, replicationTarget.getIndex(), percolatorsFromIndex);
            Timestamp startTimestamp = dbHandler.evaluateStartTimestamp(replicationJobSettings, replicationSource);
            Timestamp relativeStartTimestamp = StringUtil.isNullOrEmpty(tailSync.getRelativeStartDate()) ? null : new Timestamp(DateUtil.getDateForRelativeValue(tailSync.getRelativeStartDate()).getTime());
            Timestamp endTimestamp = new Timestamp(DateUtil.getDateForRelativeValue(tailSync.getRelativeEndDate()).getTime());
            if (relativeStartTimestamp != null && relativeStartTimestamp.after(endTimestamp)) {
                LOGGER.warn("{}: The relative start date ({} = {}) gets ignored, because it is after the relative end date ({} = {}) and that makes no sense.", (Object)this.replicationJobId, (Object)tailSync.getRelativeStartDate(), (Object)relativeStartTimestamp, (Object)tailSync.getRelativeEndDate(), (Object)endTimestamp);
                relativeStartTimestamp = null;
            }
            if (relativeStartTimestamp != null && relativeStartTimestamp.before(startTimestamp)) {
                LOGGER.warn("{}: The relative start date ({} = {}) gets ignored, because it is before the evaluated start time ({})", (Object)this.replicationJobId, (Object)tailSync.getRelativeStartDate(), (Object)relativeStartTimestamp, (Object)startTimestamp);
                relativeStartTimestamp = null;
            }
            if (endTimestamp != null) {
                endTimestamp = DateUtil.cloneTimestampAndMaximizeNanos(endTimestamp);
            }
            if (StringUtil.isNullOrEmpty(tailSync.getRelativeDeleteOlderThanDate())) {
                LOGGER.info("{}: The relative delete older than date is not given, using the 'startTimestamp' ({}) to delete older documents.", (Object)this.replicationJobId, (Object)startTimestamp);
                deleteOlderThanTimestamp = new Timestamp(startTimestamp.getTime());
            } else {
                deleteOlderThanTimestamp = new Timestamp(DateUtil.getDateForRelativeValue(tailSync.getRelativeDeleteOlderThanDate()).getTime());
                LOGGER.info("{}: Using the given relative delete older than date ({} = {}) to delete older documents.", (Object)this.replicationJobId, (Object)tailSync.getRelativeDeleteOlderThanDate(), (Object)deleteOlderThanTimestamp);
            }
            if (relativeStartTimestamp != null) {
                if (relativeStartTimestamp.before(deleteOlderThanTimestamp)) {
                    LOGGER.warn("{}: The relative sync start date ({} = {}) is before the delete documents older than date ({}). This leads to less than optimal processing.", (Object)this.replicationJobId, (Object)tailSync.getRelativeStartDate(), (Object)relativeStartTimestamp, (Object)deleteOlderThanTimestamp);
                }
            } else if (startTimestamp.before(deleteOlderThanTimestamp)) {
                LOGGER.warn("{}: The sync start date ({}) is before the delete documents older than date ({}). This leads to less than optimal processing.", (Object)this.replicationJobId, (Object)startTimestamp, (Object)deleteOlderThanTimestamp);
            }
            LOGGER.info("{}: startTimestamp={}, relativeStartTimestamp={} ({}), endTimestamp={}, deleteOlderThanTimestamp={}", (Object)this.replicationJobId, (Object)startTimestamp, (Object)relativeStartTimestamp, (Object)tailSync.getRelativeStartDate(), (Object)endTimestamp, (Object)deleteOlderThanTimestamp);
            osHandler.deleteDocumentsOlderThan(replicationSource.getLastUpdateColumn(), deleteOlderThanTimestamp);
            BulkProcessor.Listener listener = new BulkProcessor.Listener(){

                @Override
                public void beforeBulk(long executionId, BulkRequest request) {
                }

                @Override
                public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                    try {
                        percolatorsProcessor.keepDatabaseIDsFromBulkResponse(response);
                    }
                    catch (Throwable ex) {
                        LOGGER.error("{}: Failed to keep the database IDs", (Object)TailSyncTask.this.replicationJobId, (Object)ex);
                    }
                }

                @Override
                public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                    LOGGER.error("{}: After bulk failed.", (Object)TailSyncTask.this.replicationJobId, (Object)failure);
                }
            };
            BulkProcessor bulkProcessor = BulkProcessor.builder((request, bulkListener) -> oss.getClient().bulkAsync((BulkRequest)request, RequestOptions.DEFAULT, (ActionListener<BulkResponse>)bulkListener), listener).setBulkActions(10000).setBulkSize(new ByteSizeValue(10L, ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds(5L)).setConcurrentRequests(1).build();
            Timestamp timestamp = lowerDateLimit = relativeStartTimestamp != null ? new Timestamp(relativeStartTimestamp.getTime()) : new Timestamp(startTimestamp.getTime());
            while (true) {
                if (this.isCancelled()) {
                    LOGGER.info("{}: Tail sync stopped by context", (Object)this.replicationJobId);
                    break;
                }
                long tailSyncBlockStartTimestamp = System.currentTimeMillis();
                Timestamp upperDateLimit = DateUtil.addDaysToTimestamp(tailSync.getBlockDayRange(), lowerDateLimit);
                if ((upperDateLimit = DateUtil.cloneTimestampAndMaximizeNanos(upperDateLimit)).after(endTimestamp)) {
                    upperDateLimit = DateUtil.cloneTimestampWithNanos(endTimestamp);
                }
                LOGGER.info("{}: Processing date range: {} <-> {}", (Object)this.replicationJobId, (Object)lowerDateLimit, (Object)upperDateLimit);
                GetDataResult dbResult = dbHandler.getRecordData(replicationSource.getIdColumns(), replicationSource.getLastUpdateColumn(), replicationSource.getLastUpdateColumnTimeZoneCalendar(), lowerDateLimit, upperDateLimit);
                if (dbResult.getThrowable() != null) {
                    throw dbResult.getThrowable();
                }
                GetDataResult openSearchResult = osHandler.getRecordData(replicationSource.getIdColumns(), replicationSource.getLastUpdateColumn(), lowerDateLimit, upperDateLimit);
                if (openSearchResult.getThrowable() != null) {
                    throw openSearchResult.getThrowable();
                }
                Map<String, RecordData> dbRecordDatas = dbResult.getData();
                Map<String, RecordData> openSearchRecordDatas = openSearchResult.getData();
                List<RecordData> missingDatabaseRecords = this.evaluateMissingDatabaseRecords(dbRecordDatas, openSearchRecordDatas);
                List<RecordData> updatedDatabaseRecords = this.evaluateUpdatedDatabaseRecords(dbRecordDatas, openSearchRecordDatas);
                List<RecordData> deletedDatabaseRecords = this.evaluateDeletedDatabaseRecords(dbRecordDatas, openSearchRecordDatas);
                amountMissingDatabaseRecords += (long)missingDatabaseRecords.size();
                amountUpdatedDatabaseRecords += (long)updatedDatabaseRecords.size();
                amountDeletedDatabaseRecords += (long)deletedDatabaseRecords.size();
                if (!missingDatabaseRecords.isEmpty()) {
                    this.addDatabaseRecordsToOpenSearch(missingDatabaseRecords, dbHandler, dbResultSetToJsonConverter, replicationJobSettings, replicationSource, replicationTarget, oss, bulkProcessor);
                }
                if (!updatedDatabaseRecords.isEmpty()) {
                    this.addDatabaseRecordsToOpenSearch(updatedDatabaseRecords, dbHandler, dbResultSetToJsonConverter, replicationJobSettings, replicationSource, replicationTarget, oss, bulkProcessor);
                }
                if (!deletedDatabaseRecords.isEmpty()) {
                    this.deleteNoLongerExistingOpenSearchRecords(replicationTarget, deletedDatabaseRecords, bulkProcessor);
                }
                LOGGER.info("{}: Tail sync date range ({} <-> {}) block done [new:{},updated:{},deleted:{}] in {} seconds", (Object)this.replicationJobId, (Object)lowerDateLimit, (Object)upperDateLimit, (Object)missingDatabaseRecords.size(), (Object)updatedDatabaseRecords.size(), (Object)deletedDatabaseRecords.size(), (Object)Float.valueOf((float)(System.currentTimeMillis() - tailSyncBlockStartTimestamp) / 1000.0f));
                if (upperDateLimit.equals(endTimestamp)) {
                    LOGGER.info("{}: We reached the end", (Object)this.replicationJobId);
                    break;
                }
                lowerDateLimit = new Timestamp(upperDateLimit.getTime());
            }
            bulkProcessor.awaitClose(5L, TimeUnit.MINUTES);
            percolatorsProcessor.process();
            LOGGER.info("{}: Tail sync done [new:{},updated:{},deleted:{}] in {} seconds", (Object)this.replicationJobId, (Object)amountMissingDatabaseRecords, (Object)amountUpdatedDatabaseRecords, (Object)amountDeletedDatabaseRecords, (Object)Float.valueOf((float)(System.currentTimeMillis() - tailSyncStartTimestamp) / 1000.0f));
            PercolatorsProcessorImpl percolatorsProcessorImpl = percolatorsProcessor;
            return percolatorsProcessorImpl;
        }
        catch (OpenSearchRelatedException | IOException | OpenSearchException ex) {
            tailSync.increaseErrorCount();
            LOGGER.error("{}: OpenSearch related error: {}", (Object)this.replicationJobId, (Object)ex.getLocalizedMessage(), (Object)ex);
            PercolatorsProcessor percolatorsProcessor = null;
            return percolatorsProcessor;
        }
        catch (Exception ex) {
            tailSync.increaseErrorCount();
            LOGGER.error("{}: {}", (Object)this.replicationJobId, (Object)ex.getLocalizedMessage(), (Object)ex);
            PercolatorsProcessor percolatorsProcessor = null;
            return percolatorsProcessor;
        }
        catch (Throwable ex) {
            tailSync.increaseErrorCount();
            LOGGER.error("{}: Unexpected Throwable!", (Object)this.replicationJobId, (Object)ex);
            PercolatorsProcessor percolatorsProcessor = null;
            return percolatorsProcessor;
        }
        finally {
            if (osHandler != null) {
                osHandler.destroy();
            }
            if (dbHandler != null) {
                dbHandler.destroy();
            }
            tailSync.setRunning(false);
            tailSync.setLastRunEnd(new Date());
            tailSync.addTailSyncLastRunRecords(amountMissingDatabaseRecords, amountUpdatedDatabaseRecords, amountDeletedDatabaseRecords);
        }
    }

    private List<RecordData> evaluateMissingDatabaseRecords(Map<String, RecordData> dbRecordDatas, Map<String, RecordData> openSearchRecordDatas) {
        ArrayList<RecordData> result = new ArrayList<RecordData>();
        dbRecordDatas.forEach((dbRecordId, dbRecordData) -> {
            if (!openSearchRecordDatas.containsKey(dbRecordId)) {
                result.add((RecordData)dbRecordData);
            }
        });
        return result;
    }

    private List<RecordData> evaluateUpdatedDatabaseRecords(Map<String, RecordData> dbRecordDatas, Map<String, RecordData> openSearchRecordDatas) {
        ArrayList<RecordData> result = new ArrayList<RecordData>();
        dbRecordDatas.forEach((dbRecordId, dbRecordData) -> {
            RecordData openSearchRecordData = (RecordData)openSearchRecordDatas.get(dbRecordId);
            if (openSearchRecordData != null && dbRecordData.getLastUpdateDate().getTime() != openSearchRecordData.getLastUpdateDate().getTime()) {
                result.add((RecordData)dbRecordData);
            }
        });
        return result;
    }

    private List<RecordData> evaluateDeletedDatabaseRecords(Map<String, RecordData> dbRecordDatas, Map<String, RecordData> openSearchRecordDatas) {
        ArrayList<RecordData> result = new ArrayList<RecordData>();
        openSearchRecordDatas.forEach((openSearchRecordId, openSearchRecordData) -> {
            if (!dbRecordDatas.containsKey(openSearchRecordId)) {
                result.add((RecordData)openSearchRecordData);
            }
        });
        return result;
    }

    private void addDatabaseRecordsToOpenSearch(List<RecordData> databaseRecords, TailSyncDatabaseHandler dbHandler, DbResultSetToJsonConverter dbResultSetToJsonConverter, ReplicationJobSettings replicationJobSettings, ReplicationSource replicationSource, ReplicationTarget replicationTarget, OpenSearchService oss, BulkProcessor bulkProcessor) throws SQLException, IOException, OpenSearchRelatedException {
        LOGGER.info("{}: addDatabaseRecordsToOpenSearch databaseRecords=..., dbHandler=..., dbResultSetToJsonConverter=..., replicationJobSettings=..., replicationSource=..., replicationTarget=..., oss=..., bulkProcessor=...", (Object)this.replicationJobId);
        for (RecordData recordData : databaseRecords) {
            ResultSet rs = dbHandler.getDatabaseRecordByID(replicationSource.getIdColumns(), recordData);
            try {
                if (!rs.next()) continue;
                XContentBuilder source = dbResultSetToJsonConverter.resultToJsonObject(rs, replicationJobSettings.isSyncFiles(), replicationJobSettings.isUnzipSyncedFiles(), replicationSource.getDateFieldColumnsTimeZoneCalendar(), replicationSource.getLastUpdateColumn(), replicationSource.getLastUpdateColumnTimeZoneCalendar());
                IndexRequest indexRequest = ((IndexRequest)new IndexRequest().index(replicationTarget.getIndex())).id(recordData.getRecordId()).source(source);
                if (replicationJobSettings.isSyncFiles()) {
                    indexRequest.setPipeline(oss.getAttachmentsPipelineName(replicationTarget.getIndex()));
                }
                bulkProcessor.add(indexRequest);
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
    }

    private void deleteNoLongerExistingOpenSearchRecords(ReplicationTarget replicationTarget, List<RecordData> deletedDatabaseRecords, BulkProcessor bulkProcessor) {
        LOGGER.info("{}: deleteNoLongerExistingOpenSearchRecords replicationTarget=..., deletedDatabaseRecords=..., bulkProcessor=...", (Object)this.replicationJobId);
        for (RecordData deletedDatabaseRecord : deletedDatabaseRecords) {
            DeleteRequest deleteRequest = new DeleteRequest(replicationTarget.getIndex()).id(deletedDatabaseRecord.getRecordId());
            bulkProcessor.add(deleteRequest);
        }
    }
}

