/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.util.StringUtil;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.jaxrs.impl.NewCookieHeaderProvider;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sun.misc.Unsafe;

public class BpcNewCookieHeaderProvider
extends NewCookieHeaderProvider {
    private static final Logger LOGGER = LogManager.getLogger(BpcNewCookieHeaderProvider.class);
    public static final String SAME_SITE_NONE = "__SAME_SITE_NONE__";
    public static final String SAME_SITE_LAX = "__SAME_SITE_LAX__";
    public static final String SAME_SITE_STRICT = "__SAME_SITE_STRICT__";
    private static Object originalNewCookieHeaderProvider = null;

    private static void setHeaderProviderForNewCookieClass(NewCookieHeaderProvider headerProvider) throws NoSuchFieldException, IllegalAccessException {
        Field headerProvidersField = RuntimeDelegateImpl.class.getDeclaredField("headerProviders");
        headerProvidersField.setAccessible(true);
        RuntimeDelegate runtimeDelegate = RuntimeDelegate.getInstance();
        RuntimeDelegateImpl runtimeDelegateImpl = (RuntimeDelegateImpl)runtimeDelegate;
        Map headerProviders = (Map)headerProvidersField.get(runtimeDelegateImpl);
        headerProviders.put(NewCookie.class, headerProvider);
    }

    public static void setAsUglyWorkaround_Old() {
        try {
            BpcNewCookieHeaderProvider.setHeaderProviderForNewCookieClass(new BpcNewCookieHeaderProvider());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to enable the BPC specific 'NewCookieHeaderProvider' to set the 'SameSite' attribute to cookies.", (Throwable)ex);
        }
    }

    public static void removeUglyWorkaround_Old() {
        try {
            BpcNewCookieHeaderProvider.setHeaderProviderForNewCookieClass(new NewCookieHeaderProvider());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to restore the original 'NewCookieHeaderProvider'.", (Throwable)ex);
        }
    }

    private static void removeFinalModifier(Field field) throws IllegalAccessException, NoSuchFieldException {
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (NoSuchFieldException ex) {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(Field.class, MethodHandles.lookup());
            VarHandle modifiersHandle = lookup.findVarHandle(Field.class, "modifiers", Integer.TYPE);
            modifiersHandle.set(field, field.getModifiers() & 0xFFFFFFEF);
        }
    }

    public static void setAsUglyWorkaround_Oldest() {
        try {
            Field delegateField = NewCookie.class.getDeclaredField("delegate");
            BpcNewCookieHeaderProvider.removeFinalModifier(delegateField);
            delegateField.setAccessible(true);
            originalNewCookieHeaderProvider = delegateField.get(null);
            delegateField.set(null, (Object)new BpcNewCookieHeaderProvider());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to enable the BPC specific 'NewCookieHeaderProvider' to set the 'SameSite' attribute to cookies.", (Throwable)ex);
        }
    }

    public static void removeUglyWorkaround_Oldest() {
        if (originalNewCookieHeaderProvider != null) {
            try {
                Field delegateField = NewCookie.class.getDeclaredField("delegate");
                BpcNewCookieHeaderProvider.removeFinalModifier(delegateField);
                delegateField.setAccessible(true);
                delegateField.set(null, originalNewCookieHeaderProvider);
                originalNewCookieHeaderProvider = null;
            }
            catch (Exception ex) {
                LOGGER.error("Failed to restore the original 'NewCookieHeaderProvider'.", (Throwable)ex);
            }
        }
    }

    private static Unsafe getUnsafe() throws NoSuchFieldException, IllegalAccessException {
        Field f = Unsafe.class.getDeclaredField("theUnsafe");
        f.setAccessible(true);
        return (Unsafe)f.get(null);
    }

    private static void setFinalStatic(Field field, Object value) throws Exception {
        Unsafe unsafe = BpcNewCookieHeaderProvider.getUnsafe();
        Object fieldBase = unsafe.staticFieldBase(field);
        long fieldOffset = unsafe.staticFieldOffset(field);
        unsafe.putObject(fieldBase, fieldOffset, value);
    }

    private static Object getStaticFinal(Field field) throws NoSuchFieldException, IllegalAccessException {
        Unsafe unsafe = BpcNewCookieHeaderProvider.getUnsafe();
        Object fieldBase = unsafe.staticFieldBase(field);
        long fieldOffset = unsafe.staticFieldOffset(field);
        return unsafe.getObject(fieldBase, fieldOffset);
    }

    public static void setAsUglyWorkaround() {
        try {
            NewCookie classLoaderWorkaroundCookie = new NewCookie("just", "to_initialize");
            BpcNewCookieHeaderProvider.setFinalStatic(NewCookie.class.getDeclaredField("delegate"), (Object)new BpcNewCookieHeaderProvider());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to enable the BPC specific 'NewCookieHeaderProvider' to set the 'SameSite' attribute to cookies.", (Throwable)ex);
        }
    }

    public static void removeUglyWorkaround() {
        try {
            BpcNewCookieHeaderProvider.setFinalStatic(NewCookie.class.getDeclaredField("delegate"), new NewCookieHeaderProvider());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to restore the original 'NewCookieHeaderProvider'.", (Throwable)ex);
        }
    }

    public String toString(NewCookie value) {
        String comment = value.getComment();
        if (!StringUtil.isNullOrEmpty(comment)) {
            if (comment.contains(SAME_SITE_NONE)) {
                return this.removeUnwantedFields(super.toString(value)) + ";SameSite=None";
            }
            if (comment.contains(SAME_SITE_LAX)) {
                return this.removeUnwantedFields(super.toString(value)) + ";SameSite=Lax";
            }
            if (comment.contains(SAME_SITE_STRICT)) {
                return this.removeUnwantedFields(super.toString(value)) + ";SameSite=Strict";
            }
        }
        return super.toString(value);
    }

    private String removeUnwantedFields(String oldCookieString) {
        List<String> oldCookieElements = StringUtil.explode(oldCookieString, ";");
        ArrayList<String> newCookieElements = new ArrayList<String>();
        for (String oldCookieElement : oldCookieElements) {
            if (oldCookieElement.startsWith("Comment") || oldCookieElement.startsWith("Version")) continue;
            newCookieElements.add(oldCookieElement);
        }
        return StringUtil.implode(";", newCookieElements);
    }
}

