/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.resource.response.OnlineUsers;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="collaboration")
@Tag(name="Collaboration API", description="This is the collaboration endpoint providing collaboration functionality.")
public class CollaborationEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(CollaborationEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ClientSessionManager> clientSessionManagerBpcServicesTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public CollaborationEndpoint(BundleContext bundleContext) {
        LOGGER.info("ServerInfoEndpoints bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.clientSessionManagerBpcServicesTracker = new BpcServicesTracker<ClientSessionManager>(this.bundleContext, ClientSessionManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/online-users")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="COLLABORATION_ADMIN", right="COLLABORATION_LIST_USERS", message="Not allowed to list online users")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=OnlineUsers.class))})})
    @OperationDescription(summary="Get list of online users", description="Get a list of online users.")
    @ReturnDescription(value="The requested list of users as JSON.")
    public Response getOnlineUsers(@Context HttpHeaders hh) {
        LOGGER.info("getOnlineUsers");
        try {
            ClientSessionManager sessionManager = this.clientSessionManagerBpcServicesTracker.getService();
            List<ClientSession> allSessions = sessionManager.getAllSessions();
            OnlineUsers onlineUsersDto = new OnlineUsers(allSessions);
            return Response.ok((Object)onlineUsersDto).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the list of online users.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

