/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.ModuleManager;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.replicator.ReplicationModule;
import de.virtimo.bpc.jaxrs.BpcEndpoint;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.opensearch.plugin.dto.ReplicationJobRuntimeStatsDTO;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="replication")
@Tag(name="Replication API", description="These are the replication endpoints.")
public class ReplicationEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(ReplicationEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;
    private BpcServicesTracker<ModuleManager> moduleManagerTracker;

    public ReplicationEndpoint(BundleContext bundleContext) {
        LOGGER.info("ReplicationEndpoint bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
        this.moduleManagerTracker = new BpcServicesTracker<ModuleManager>(this.bundleContext, ModuleManager.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/jobs/usingindex/{dataIndex}/monitor")
    @Produces(value={"application/json"})
    @BpcEndpoint
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the replication jobs with runtime stats indexing into the given OpenSearch index.", description="Get the replication jobs with runtime stats indexing into the given OpenSearch index.\nThe response will be compact and used by the BPC monitor frontend.\n\nIs without access rights check at the moment, because this endpoint gets called from the frontend monitor.\n")
    @ReturnDescription(value="The requested data as JSON")
    public Response getReplicationJobsWithRuntimeStatsForMonitorDataIndex(@Parameter(description="the name of the OpenSearch index") @PathParam(value="dataIndex") String dataIndex, @Context HttpHeaders hh) {
        LOGGER.info("getReplicationJobsWithRuntimeStatsForMonitorDataIndex dataIndex={}", (Object)dataIndex);
        try {
            ReplicationModule replicationModule = this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
            List<ReplicationJobRuntimeStatsDTO> replicationJobsWithRuntimeStats = replicationModule.getReplicationJobsWithRuntimeStatsFromAllServersUsingIndex(dataIndex);
            ArrayList result = new ArrayList();
            for (ReplicationJobRuntimeStatsDTO replicationJobRuntimeStats : replicationJobsWithRuntimeStats) {
                HashMap<String, Object> replicationMap = new HashMap<String, Object>();
                replicationMap.put("Job", dataIndex);
                replicationMap.put("errorCount", replicationJobRuntimeStats.getReplication().getErrorCount());
                replicationMap.put("lastRunEnd", replicationJobRuntimeStats.getReplication().getLastRunEnd());
                replicationMap.put("currentErrorMessage", replicationJobRuntimeStats.getReplication().getCurrentErrorMessage());
                if (replicationJobRuntimeStats.getConsistencyCheck().isEnabled()) {
                    replicationMap.put("sourceAndTargetConsistent", replicationJobRuntimeStats.getConsistencyCheck().isSourceAndTargetConsistent());
                }
                HashMap<String, Object> compactReplicationJobInfoMap = new HashMap<String, Object>();
                compactReplicationJobInfoMap.put("id", replicationJobRuntimeStats.getId());
                compactReplicationJobInfoMap.put("replication", replicationMap);
                result.add(compactReplicationJobInfoMap);
            }
            return Response.ok(result).build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the replication jobs with runtime stats for the data index: {}", (Object)dataIndex, (Object)ex);
            return ErrorResponse.forException(ex).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/{replicationJobId}/restart")
    @BpcRoleOrRightRequired(role="REPLICATION_ADMIN", right="REPLICATION_JOB_RESTART")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Restarts a replication job.", description="Restarts a replication job.")
    public Response restartOfReplicationJob(@Parameter(description="the ID of the replication job") @PathParam(value="replicationJobId") String replicationJobId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("restartOfReplicationJob replicationJobId={}", (Object)replicationJobId);
        try {
            ReplicationModule replicationModule = this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
            replicationModule.sendRestartOfReplicationJobActionToPlugin(replicationJobId, userSession);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to restart the replication job with the id: {}", (Object)replicationJobId, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @PUT
    @Path(value="/{replicationJobId}/start")
    @BpcRoleOrRightRequired(role="REPLICATION_ADMIN", right="REPLICATION_JOB_FORCED_START")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Forced start of a replication job.", description="Forced start of a replication job.")
    public Response forcedStartOfReplicationJob(@Parameter(description="the ID of the replication job") @PathParam(value="replicationJobId") String replicationJobId, @Context HttpHeaders hh, @Context UserSession userSession) {
        LOGGER.info("forcedStartOfReplicationJob replicationJobId={}", (Object)replicationJobId);
        try {
            ReplicationModule replicationModule = this.moduleManagerTracker.getService().getModuleByClass(ReplicationModule.class);
            replicationModule.sendForcedStartOfReplicationJobActionToPlugin(replicationJobId, userSession);
            return Response.ok().build();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to forced start the replication job with the id: {}", (Object)replicationJobId, (Object)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

