/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource;

import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.jaxrs.annotation.JacksonFeatures;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.SystemException;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchBpcPluginManager;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.core.exception.CoreErrorCode;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServerDTO;
import de.virtimo.bpc.opensearch.plugin.dto.ConnectedServersDTO;
import de.virtimo.bpc.opensearch.plugin.utils.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.xcontent.ToXContent;
import org.osgi.framework.BundleContext;

@Path(value="server")
@Tag(name="Server API", description="These are the BPC server endpoints. Please be sure that every BPC server in the cluster uses a unique UUID.\nThis is done by the setting `de.virtimo.bpc.core.karaf.uuid` which can found in the config file `[karaf]/etc/de.virtimo.bpc.core.cfg`.\n")
public class ServerEndpoints {
    private static final Logger LOGGER = LogManager.getLogger(ServerEndpoints.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<OpenSearchBpcPluginManager> openSearchBpcPluginManagerTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public ServerEndpoints(BundleContext bundleContext) {
        LOGGER.info("ServerInfoEndpoints bundleContext={}", (Object)bundleContext);
        this.bundleContext = bundleContext;
    }

    public void onStartup() {
        LOGGER.info("onStartup");
        this.openSearchBpcPluginManagerTracker = new BpcServicesTracker<OpenSearchBpcPluginManager>(this.bundleContext, OpenSearchBpcPluginManager.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("onShutdown");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="SERVER_ADMIN", right="SERVER_GET_UUIDS")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    @OperationDescription(summary="Get the UUIDs of the BPC servers in the cluster.", description="Get the UUIDs of the BPC servers in the cluster.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getUUIDsOfServers(@Context HttpHeaders hh) {
        LOGGER.info("getUUIDsOfServers");
        try {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            ConnectedServersDTO connectedServers = openSearchBpcPluginManager.getConnectedServers();
            return Response.ok((Object)connectedServers.getUUIDs()).build();
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the UUIDs of the connected BPC servers.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }

    @GET
    @Path(value="/{uuid}/info")
    @Produces(value={"application/json"})
    @JacksonFeatures(serializationEnable={SerializationFeature.INDENT_OUTPUT})
    @BpcRoleOrRightRequired(role="SERVER_ADMIN", right="SERVER_GET_INFO")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Requested server not found")})
    @OperationDescription(summary="Get detailed info of a BPC server in the cluster.", description="Get detailed info of a BPC server in the cluster.")
    @ReturnDescription(value="The requested data as JSON.")
    public Response getServerInfo(@Parameter(description="the UUID of the BPC server to get the infos for") @PathParam(value="uuid") String serverUUID, @Context HttpHeaders hh) {
        LOGGER.info("getServerInfo serverUUID={}", (Object)serverUUID);
        try {
            OpenSearchBpcPluginManager openSearchBpcPluginManager = this.openSearchBpcPluginManagerTracker.getService();
            ConnectedServerDTO connectedServer = openSearchBpcPluginManager.getConnectedServers().getConnectedServerByUUID(serverUUID);
            if (connectedServer != null) {
                return Response.ok((Object)JsonUtil.asJsonString((ToXContent)connectedServer)).build();
            }
            throw new SystemException((ErrorCode)CoreErrorCode.SERVER_NOT_FOUND, "The server with the UUID '${uuid}' does not exist.", MapUtil.mapOf("uuid", serverUUID));
        }
        catch (Exception ex) {
            LOGGER.error("Exception while getting the server info.", (Throwable)ex);
            return ErrorResponse.forException(ex).languageFrom(hh).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

