/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.resource.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.virtimo.bpc.api.auth.ClientSession;
import de.virtimo.bpc.core.resource.response.OnlineUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OnlineUsers {
    private final List<OnlineUser> onlineUsers;

    public OnlineUsers(Collection<ClientSession> clientSessionList) {
        if (clientSessionList == null) {
            this.onlineUsers = new ArrayList<OnlineUser>();
            return;
        }
        HashMap<String, OnlineUser> onlineUserMap = OnlineUsers.getUniqueOnlineUsersMap(clientSessionList);
        this.onlineUsers = onlineUserMap.values().stream().sorted(Comparator.comparing(OnlineUser::isActive).reversed().thenComparing(OnlineUser::getFirstName).thenComparing(OnlineUser::getLastName).thenComparing(OnlineUser::getLoginName).thenComparing(OnlineUser::getEmail)).toList();
    }

    @NotNull
    private static HashMap<String, OnlineUser> getUniqueOnlineUsersMap(Collection<ClientSession> clientSessionList) {
        HashMap<String, OnlineUser> onlineUserMap = new HashMap<String, OnlineUser>();
        for (ClientSession clientSession : clientSessionList) {
            OnlineUser onlineUser = new OnlineUser(clientSession);
            if (!onlineUserMap.containsKey(onlineUser.getLoginName())) {
                onlineUserMap.put(onlineUser.getLoginName(), onlineUser);
                continue;
            }
            if (onlineUserMap.get(onlineUser.getLoginName()).isActive() || !onlineUser.isActive()) continue;
            onlineUserMap.put(onlineUser.getLoginName(), onlineUser);
        }
        return onlineUserMap;
    }

    @JsonProperty(value="count")
    public int count() {
        return this.onlineUsers.size();
    }

    @JsonProperty(value="users")
    public List<OnlineUser> getOnlineUsers() {
        return this.onlineUsers;
    }
}

