/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.AbstractBackendModuleLoadedEventHandler;
import de.virtimo.bpc.api.BpcService;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Module;
import de.virtimo.bpc.api.PercolatorsManager;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultImpl;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.service.IndexCleanupService;
import de.virtimo.bpc.util.DictionaryUtil;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.RequestOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.TopHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class CheckResultStorageServiceImpl
implements CheckResultStorageService,
BpcService {
    private static final Logger LOGGER = LogManager.getLogger(CheckResultStorageServiceImpl.class);
    public static final String INDEX_NAME = "bpc-security-check-results";
    public static final String DELETE_CHECK_RESULTS_OLDER_THAN_PROPERTY = "deleteCheckResultsOlderThan";
    private static final String DEFAULT_DELETE_OLDER_THAN = "1 year ago";
    private static final int BULK_TIMEOUT_SECONDS = 60;
    private static final int MAX_SEARCH_RESULTS = 1000;
    private static final String AGGREGATION_NAME_CHECKS = "checks";
    private static final String AGGREGATION_NAME_LATEST = "latest";
    private static final String FIELD_CHECK_RESULT_ID = "checkResultId";
    private static final String FIELD_TIMESTAMP = "timestamp";
    private final BundleContext bundleContext;
    private final BpcServicesTracker<IndexCleanupService> indexCleanupServiceTracker;
    private final BpcServicesTracker<OpenSearchService> openSearchServiceTracker;
    private final BpcServicesTracker<PercolatorsManager> percolatorsManagerTracker;
    private final BpcServicesTracker<ConfigurationAdmin> configurationAdminTracker;
    private final EventRegistration eventRegistration;

    public CheckResultStorageServiceImpl(BundleContext bundleContext) {
        LOGGER.info("Activate CheckResultStorageService");
        this.bundleContext = bundleContext;
        this.indexCleanupServiceTracker = new BpcServicesTracker<IndexCleanupService>(bundleContext, IndexCleanupService.class);
        this.openSearchServiceTracker = new BpcServicesTracker<OpenSearchService>(bundleContext, OpenSearchService.class);
        this.percolatorsManagerTracker = new BpcServicesTracker<PercolatorsManager>(bundleContext, PercolatorsManager.class);
        this.configurationAdminTracker = new BpcServicesTracker<ConfigurationAdmin>(bundleContext, ConfigurationAdmin.class);
        this.eventRegistration = new EventRegistration(bundleContext);
        this.eventRegistration.forBackendModuleLoadedEvents("_core", new CoreModuleLoadedEvent());
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    @Override
    public void shutdownService() {
        LOGGER.info("Deactivating CheckResultStorageService");
        this.stopIndexCleanupTask();
        this.eventRegistration.unregisterAllEventHandler();
        BpcServicesTracker.stopAll(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCheckResult(CheckResult checkResult) {
        LOGGER.debug("Persisting check result: {}", (Object)checkResult.getIdentifier());
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            OpenSearchService openSearchService = this.openSearchServiceTracker.getService();
            PercolatorsManager percolatorsManager = this.percolatorsManagerTracker.getService();
            String json = objectMapper.writeValueAsString((Object)checkResult);
            IndexRequest indexRequest = this.createIndexRequest(json);
            BulkRequest bulkRequest = this.createBulkRequest(indexRequest);
            BulkResponse bulkResponse = openSearchService.bulk(bulkRequest, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                LOGGER.error("Failed to persist check result: {}", (Object)bulkResponse.buildFailureMessage());
            } else {
                LOGGER.info("Check result '{}' successfully persisted", (Object)checkResult.getIdentifier());
            }
            percolatorsManager.informClientsAboutReplicatedData(openSearchService, INDEX_NAME, bulkResponse);
        }
        catch (Exception ex) {
            LOGGER.error("Error while persisting check result '{}'", (Object)checkResult.getIdentifier(), (Object)ex);
        }
        finally {
            ObjectMapperPool.getInstance().restore((Object)objectMapper);
        }
    }

    private IndexRequest createIndexRequest(String json) {
        return ((IndexRequest)new IndexRequest().index(INDEX_NAME)).source(json, (MediaType)XContentType.JSON);
    }

    private BulkRequest createBulkRequest(IndexRequest indexRequest) {
        return new BulkRequest().timeout(TimeValue.timeValueSeconds(60L)).add(indexRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CheckResult> getLatestCheckResults() {
        LOGGER.debug("Retrieving latest check results");
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            SearchRequest searchRequest = this.buildLatestCheckResultsSearchRequest();
            SearchResponse searchResponse = this.openSearchServiceTracker.getService().getClient().search(searchRequest, RequestOptions.DEFAULT);
            List<CheckResult> results = this.extractCheckResultsFromAggregations(searchResponse, objectMapper);
            LOGGER.debug("Retrieved {} latest check results", (Object)results.size());
            List<CheckResult> list = results;
            return list;
        }
        catch (Exception e) {
            LOGGER.error("Failed to retrieve latest check results", (Throwable)e);
            ArrayList<CheckResult> arrayList = new ArrayList<CheckResult>();
            return arrayList;
        }
        finally {
            ObjectMapperPool.getInstance().restore((Object)objectMapper);
        }
    }

    private SearchRequest buildLatestCheckResultsSearchRequest() {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).aggregation(((TermsAggregationBuilder)AggregationBuilders.terms(AGGREGATION_NAME_CHECKS).field(FIELD_CHECK_RESULT_ID)).size(1000).subAggregation(AggregationBuilders.topHits(AGGREGATION_NAME_LATEST).size(1).sort((SortBuilder<?>)SortBuilders.fieldSort(FIELD_TIMESTAMP).order(SortOrder.DESC))));
        return new SearchRequest(INDEX_NAME).source(searchSourceBuilder);
    }

    private List<CheckResult> extractCheckResultsFromAggregations(SearchResponse searchResponse, ObjectMapper objectMapper) {
        ArrayList<CheckResult> checkResults = new ArrayList<CheckResult>();
        Aggregations aggregations = searchResponse.getAggregations();
        if (aggregations == null) {
            LOGGER.debug("No aggregations found in search response");
            return checkResults;
        }
        Terms checksAggregation = (Terms)aggregations.get(AGGREGATION_NAME_CHECKS);
        for (Terms.Bucket bucket : checksAggregation.getBuckets()) {
            TopHits latestHits = (TopHits)bucket.getAggregations().get(AGGREGATION_NAME_LATEST);
            for (SearchHit hit : latestHits.getHits().getHits()) {
                try {
                    CheckResult checkResult = (CheckResult)objectMapper.readValue(hit.getSourceAsString(), CheckResultImpl.class);
                    checkResults.add(checkResult);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to deserialize check result from hit: {}", (Object)hit.getId(), (Object)e);
                }
            }
        }
        return checkResults;
    }

    private void startIndexCleanupTask(String deleteOlderThan) {
        LOGGER.debug("Scheduling index cleanup task for index '{}'", (Object)INDEX_NAME);
        try {
            this.indexCleanupServiceTracker.getService().scheduleDeleteTask(INDEX_NAME, FIELD_TIMESTAMP, deleteOlderThan, 4, TimeUnit.HOURS);
            LOGGER.debug("Index cleanup task scheduled successfully");
        }
        catch (Exception ex) {
            LOGGER.error("Failed to schedule index cleanup task for index '{}'", (Object)INDEX_NAME, (Object)ex);
        }
    }

    private void stopIndexCleanupTask() {
        LOGGER.debug("Stopping index cleanup task for index '{}'", (Object)INDEX_NAME);
        try {
            this.indexCleanupServiceTracker.getService().cancelAndRemoveScheduledDeleteTask(INDEX_NAME);
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to stop cleanup task for index '{}'", (Object)INDEX_NAME, (Object)ex);
        }
    }

    private class CoreModuleLoadedEvent
    extends AbstractBackendModuleLoadedEventHandler {
        private CoreModuleLoadedEvent() {
        }

        @Override
        public void processLoadedModule(Module module) {
            LOGGER.info("{}.processLoadedModule module=...", (Object)this.getClass().getSimpleName());
            try {
                CheckResultStorageServiceImpl.this.stopIndexCleanupTask();
                Map properties = Optional.ofNullable(CheckResultStorageServiceImpl.this.configurationAdminTracker.getService().getConfiguration("de.virtimo.bpc.core.security.checks")).map(Configuration::getProperties).map(DictionaryUtil::convertToMap).orElse(Collections.emptyMap());
                String deleteOlderThan = properties.getOrDefault(CheckResultStorageServiceImpl.DELETE_CHECK_RESULTS_OLDER_THAN_PROPERTY, CheckResultStorageServiceImpl.DEFAULT_DELETE_OLDER_THAN);
                LOGGER.info("Cleanup task will delete check results older than: {}", (Object)deleteOlderThan);
                CheckResultStorageServiceImpl.this.startIndexCleanupTask(deleteOlderThan);
            }
            catch (ServiceNotFoundException | IOException e) {
                LOGGER.error("Can't find service", (Throwable)e);
            }
        }
    }
}

