/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check;

import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReportImpl
implements Report {
    private static final Logger LOGGER = LogManager.getLogger(ReportImpl.class);
    private final List<CheckResult> checkResults;
    private final double score;

    public ReportImpl(List<CheckResult> checkResults, double score) {
        this.validateParameters(checkResults, score);
        this.checkResults = new ArrayList<CheckResult>(checkResults);
        this.score = score;
    }

    private void validateParameters(List<CheckResult> checkResults, double score) {
        if (checkResults == null) {
            throw new IllegalArgumentException("Check results cannot be null");
        }
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            throw new IllegalArgumentException("Score must be a valid number");
        }
        if (score < 0.0) {
            LOGGER.warn("Score is negative: {}. This might indicate a calculation error.", (Object)score);
        }
        if (score > 1.0) {
            LOGGER.warn("Score exceeds 1.0: {}. This might indicate a calculation error.", (Object)score);
        }
    }

    @Override
    public double getTotalScore() {
        return this.score;
    }

    @Override
    public List<CheckResult> getCheckResults() {
        return Collections.unmodifiableList(this.checkResults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportImpl report = (ReportImpl)o;
        return Double.compare(report.score, this.score) == 0 && Objects.equals(this.checkResults, report.checkResults);
    }

    public int hashCode() {
        return Objects.hash(this.checkResults, this.score);
    }

    public String toString() {
        return "ReportImpl{score=" + this.score + ", checkResultsCount=" + this.checkResults.size() + "}";
    }
}

