/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check;

import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.ErrorResponse;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.api.security.CheckResultReportService;
import de.virtimo.bpc.api.security.Report;
import de.virtimo.bpc.api.service.ErrorResponseService;
import de.virtimo.bpc.jaxrs.BpcRoleOrRightRequired;
import de.virtimo.bpc.jaxrs.OperationDescription;
import de.virtimo.bpc.jaxrs.ReturnDescription;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;

@Path(value="security-check")
@Tag(name="Security Check API", description="Providing information about internal security checks.")
public class SecurityCheckEndpoint {
    private static final Logger LOGGER = LogManager.getLogger(SecurityCheckEndpoint.class);
    private final BundleContext bundleContext;
    private BpcServicesTracker<CheckResultReportService> checkResultReportServiceTracker;
    private BpcServicesTracker<ErrorResponseService> errorResponseServiceTracker;

    public SecurityCheckEndpoint(BundleContext bundleContext) {
        if (bundleContext == null) {
            throw new IllegalArgumentException("BundleContext cannot be null");
        }
        this.bundleContext = bundleContext;
        LOGGER.info("Security check REST endpoint created");
    }

    public void onStartup() {
        LOGGER.info("Starting security check REST endpoint");
        this.checkResultReportServiceTracker = new BpcServicesTracker<CheckResultReportService>(this.bundleContext, CheckResultReportService.class);
        this.errorResponseServiceTracker = new BpcServicesTracker<ErrorResponseService>(this.bundleContext, ErrorResponseService.class);
    }

    public void onShutdown() {
        LOGGER.info("Shutting down security check REST endpoint");
        BpcServicesTracker.stopAll(this);
    }

    @GET
    @Produces(value={"application/json"})
    @BpcRoleOrRightRequired(role="SECURITY_CHECK_ADMIN", right="SECURITY_CHECK_REPORT_READ", message="Not allowed to get the current report")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=Report.class))})})
    @OperationDescription(summary="Get the security check report", description="Get the security check report. The report includes the latest check results which are not excluded by configuration.")
    @ReturnDescription(value="The current security check report as JSON.")
    public Response getReport(@Context HttpHeaders httpHeaders) {
        LOGGER.debug("Security check report requested");
        try {
            Report report = this.checkResultReportServiceTracker.getService().getReport();
            return Response.ok((Object)report).type("application/json").build();
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("Required services are not available", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
        catch (Exception e) {
            LOGGER.error("Error while generating security check report", (Throwable)e);
            return ErrorResponse.forException(e).languageFrom(httpHeaders).usingTracker(this.errorResponseServiceTracker).build();
        }
    }
}

