/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.security.check.tls;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.security.AbstractCheck;
import de.virtimo.bpc.api.security.Check;
import de.virtimo.bpc.api.security.CheckResult;
import de.virtimo.bpc.api.security.CheckResultStorageService;
import de.virtimo.bpc.core.security.check.AbstractBpcSecurityCheck;
import de.virtimo.bpc.core.security.check.tls.ConfigurationProfile;
import de.virtimo.bpc.core.security.check.tls.MozillaGuideline;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Modified;

public class TlsCheck
extends AbstractBpcSecurityCheck
implements Check {
    private static final Logger LOGGER = LogManager.getLogger(TlsCheck.class);
    public static final String IDENTIFIER = "TlsCheck";
    public static final String RECOMMENDATIONS_FILE = "mozilla_tls_recommendations.json";
    public static final String RECOMMENDATION_TYPE_MODERN = "modern";
    private String mozillaTlsRecommendationType;
    private ConfigurationProfile configurationProfile;
    private List<String> recommendedCipherSuites;

    public TlsCheck(BundleContext bundleContext) {
        super(bundleContext);
        LOGGER.info("Start TLS check");
    }

    @Override
    protected void coreReady() {
        this.checkTLs();
    }

    @Override
    public String getDescription() {
        return "Checks the TLS configuration";
    }

    @Override
    public String getIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public int getMaximumScore() {
        return 2;
    }

    @Override
    @Modified
    public void modified(Map<String, Object> properties) {
        LOGGER.info("Configuration has been modified");
        this.checkTLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRecommendations() throws IOException {
        LOGGER.debug("loadRecommendations");
        this.mozillaTlsRecommendationType = this.getProperties().getOrDefault("mozillaTlsRecommendationType", RECOMMENDATION_TYPE_MODERN).toString();
        ObjectMapper objectMapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try (InputStream inputStream = TlsCheck.class.getClassLoader().getResourceAsStream(RECOMMENDATIONS_FILE);){
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: mozilla_tls_recommendations.json");
            }
            MozillaGuideline guideline = (MozillaGuideline)objectMapper.readValue(inputStream, MozillaGuideline.class);
            LOGGER.debug("Mozilla Guideline Version: {}", (Object)guideline.getVersion());
            this.configurationProfile = guideline.getConfigurations().get(this.mozillaTlsRecommendationType.toLowerCase());
            this.recommendedCipherSuites = new ArrayList<String>();
            this.recommendedCipherSuites.addAll(this.configurationProfile.getCipherSuites());
            this.recommendedCipherSuites.addAll((Collection<String>)this.configurationProfile.getCiphers().get("iana"));
        }
        finally {
            if (objectMapper != null) {
                ObjectMapperPool.getInstance().restore((Object)objectMapper);
            }
        }
    }

    private void checkTLs() {
        LOGGER.debug("checkTLs");
        try {
            this.loadRecommendations();
            ArrayList<AbstractCheck.InterimResult> interimResults = new ArrayList<AbstractCheck.InterimResult>();
            SSLContext sslContext = SSLContext.getDefault();
            SSLParameters sslParameters = sslContext.getDefaultSSLParameters();
            interimResults.add(this.checkProtocol(sslParameters));
            interimResults.add(this.checkCipherSuites(sslParameters.getCipherSuites()));
            CheckResult checkResult = this.buildCheckResult(interimResults).withIdentifier("tls-default").withTags(List.of("tls")).build();
            LOGGER.debug("TLS check result: {}", (Object)checkResult);
            ((CheckResultStorageService)this.checkResultStorageServiceTracker.getService()).storeCheckResult(checkResult);
        }
        catch (Exception e) {
            LOGGER.error("Error while checking SSLContext", (Throwable)e);
        }
    }

    private AbstractCheck.InterimResult checkProtocol(SSLParameters sslParameters) {
        LOGGER.debug("checkProtocol sslParameters");
        List<String> recommendedProtocols = this.configurationProfile.getTlsVersions();
        List<String> configuredProtocols = Arrays.asList(sslParameters.getProtocols());
        LOGGER.debug("recommendedProtocols = {}", recommendedProtocols);
        LOGGER.debug("configuredProtocols = {}", configuredProtocols);
        ArrayList<String> recommendedButNotConfigured = new ArrayList<String>(recommendedProtocols);
        recommendedButNotConfigured.removeAll(configuredProtocols);
        if (!recommendedButNotConfigured.isEmpty()) {
            LOGGER.info("Recommended protocols not configured: {}", recommendedButNotConfigured);
        }
        ArrayList<String> configuredButNotRecommended = new ArrayList<String>(configuredProtocols);
        configuredButNotRecommended.removeAll(recommendedProtocols);
        if (!configuredButNotRecommended.isEmpty()) {
            LOGGER.debug("Not recommended protocols found = {}", configuredButNotRecommended);
            return new AbstractCheck.InterimResult(0, "Configured protocols don't fit the recommended protocols " + String.valueOf(configuredButNotRecommended) + " (0)");
        }
        return new AbstractCheck.InterimResult(1, "Protocols fit the recommended protocols");
    }

    private AbstractCheck.InterimResult checkCipherSuites(String[] cipherSuites) {
        LOGGER.debug("Checking {} cipher suites", (Object)cipherSuites.length);
        ArrayList<String> notRecommendedCipherSuites = new ArrayList<String>();
        for (String cipherSuite : cipherSuites) {
            if (this.recommendedCipherSuites.contains(cipherSuite)) continue;
            notRecommendedCipherSuites.add(cipherSuite);
            LOGGER.info("Cipher Suite '{}' is not recommended in Mozilla's TLS Recommendation for '{}'", (Object)cipherSuite, (Object)this.mozillaTlsRecommendationType);
        }
        if (notRecommendedCipherSuites.isEmpty()) {
            return new AbstractCheck.InterimResult(1, "All Cipher Suites are recommended");
        }
        String message = String.format("Not recommended Cipher Suites for '%s' found: %s", this.mozillaTlsRecommendationType, notRecommendedCipherSuites);
        return new AbstractCheck.InterimResult(0, message);
    }
}

