/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import de.virtimo.bpc.core.service.OpenSearchBasicAuthData;
import de.virtimo.bpc.core.service.OpenSearchPrivateKeyData;
import de.virtimo.bpc.util.BpcKeyStore;
import de.virtimo.bpc.util.BpcTrustStore;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.RestClientBuilder;
import org.osgi.framework.BundleContext;

public class OpenSearchHttpClientConfigCallback
implements RestClientBuilder.HttpClientConfigCallback {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchHttpClientConfigCallback.class);
    private final BundleContext bundleContext;
    private final OpenSearchBasicAuthData basicAuthData;
    private final boolean mustSetSslContext;
    private final OpenSearchPrivateKeyData privateKeyData;

    public OpenSearchHttpClientConfigCallback(BundleContext bundleContext, OpenSearchBasicAuthData basicAuthData, boolean mustSetSslContext, OpenSearchPrivateKeyData privateKeyData) {
        this.bundleContext = bundleContext;
        this.basicAuthData = basicAuthData;
        this.mustSetSslContext = mustSetSslContext;
        this.privateKeyData = privateKeyData;
    }

    @Override
    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
        if (this.basicAuthData != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(null, -1), (Credentials)new UsernamePasswordCredentials(this.basicAuthData.getUserName(), this.basicAuthData.getPassword().toCharArray()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if (this.mustSetSslContext) {
            if (this.bundleContext == null) {
                LOGGER.warn("Failed to set the SSL context to the OpenSearch client due to missing BundleContext. Maybe a unit test?");
            } else {
                try {
                    SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                    if (this.privateKeyData != null) {
                        char[] privateKeyPwd = this.privateKeyData.getPassword();
                        if (privateKeyPwd == null) {
                            privateKeyPwd = BpcKeyStore.getInstance().getPaxWebKeyStoreData(this.bundleContext).getKeyStorePassword();
                        }
                        KeyStore workaroundKeyStore = BpcKeyStore.getInstance().createWorkaroundKeyStore(this.bundleContext, this.privateKeyData.getAlias(), privateKeyPwd);
                        sslContextBuilder.loadKeyMaterial(workaroundKeyStore, privateKeyPwd);
                    }
                    sslContextBuilder.loadTrustMaterial(BpcTrustStore.getInstance().getTrustStore(this.bundleContext), null);
                    SSLContext sslContext = sslContextBuilder.build();
                    TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(sslContext).build();
                    PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setTlsStrategy(tlsStrategy).build();
                    httpClientBuilder.setConnectionManager((AsyncClientConnectionManager)connectionManager);
                }
                catch (Exception ex) {
                    LOGGER.error("Failed to set the pax web related truststore and/or keystore to the OpenSearch client.", (Throwable)ex);
                }
            }
        }
        return httpClientBuilder;
    }
}

