/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.Destroyer;
import de.virtimo.bpc.api.AbstractSettingUpdatedEventHandler;
import de.virtimo.bpc.api.BpcServicesTracker;
import de.virtimo.bpc.api.CoreBundleConfiguration;
import de.virtimo.bpc.api.ErrorCode;
import de.virtimo.bpc.api.EventRegistration;
import de.virtimo.bpc.api.Setting;
import de.virtimo.bpc.api.exception.BpcErrorCode;
import de.virtimo.bpc.api.exception.OpenSearchIndexMappingNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchIndexNotFoundException;
import de.virtimo.bpc.api.exception.OpenSearchRelatedException;
import de.virtimo.bpc.api.opensearch.BpcIndexInfo;
import de.virtimo.bpc.api.opensearch.BpcIndexState;
import de.virtimo.bpc.api.opensearch.IndexInfo;
import de.virtimo.bpc.api.opensearch.ManagedIndicesHandler;
import de.virtimo.bpc.api.opensearch.SearchScrollIterator;
import de.virtimo.bpc.api.opensearch.plugin.OpenSearchHost;
import de.virtimo.bpc.api.service.OpenSearchService;
import de.virtimo.bpc.core.opensearch.BpcIndexInfoImpl;
import de.virtimo.bpc.core.opensearch.BpcIndexStateImpl;
import de.virtimo.bpc.core.opensearch.ManagedIndicesHandlerImpl;
import de.virtimo.bpc.core.service.OpenSearchBasicAuthData;
import de.virtimo.bpc.core.service.OpenSearchHostImpl;
import de.virtimo.bpc.core.service.OpenSearchHttpClientConfigCallback;
import de.virtimo.bpc.core.service.OpenSearchPrivateKeyData;
import de.virtimo.bpc.core.service.OpenSearchSettingsCleaner;
import de.virtimo.bpc.util.JsonUtil;
import de.virtimo.bpc.util.MapUtil;
import de.virtimo.bpc.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.reactor.DefaultConnectingIOReactor;
import org.apache.hc.core5.reactor.IOReactorStatus;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.flush.FlushResponse;
import org.opensearch.action.admin.indices.open.OpenIndexRequest;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.admin.indices.refresh.RefreshRequest;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkRequest;
import org.opensearch.action.bulk.BulkResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.MultiGetRequest;
import org.opensearch.action.get.MultiGetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.ingest.DeletePipelineRequest;
import org.opensearch.action.ingest.GetPipelineRequest;
import org.opensearch.action.ingest.GetPipelineResponse;
import org.opensearch.action.ingest.PutPipelineRequest;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.client.GetAliasesResponse;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.core.CountRequest;
import org.opensearch.client.core.CountResponse;
import org.opensearch.client.core.MainResponse;
import org.opensearch.client.indices.CloseIndexRequest;
import org.opensearch.client.indices.CloseIndexResponse;
import org.opensearch.client.indices.CreateIndexRequest;
import org.opensearch.client.indices.CreateIndexResponse;
import org.opensearch.client.indices.GetIndexRequest;
import org.opensearch.client.indices.GetIndexResponse;
import org.opensearch.client.indices.GetIndexTemplatesRequest;
import org.opensearch.client.indices.GetIndexTemplatesResponse;
import org.opensearch.client.indices.GetMappingsRequest;
import org.opensearch.client.indices.GetMappingsResponse;
import org.opensearch.client.indices.IndexTemplateMetadata;
import org.opensearch.client.indices.PutIndexTemplateRequest;
import org.opensearch.client.indices.PutMappingRequest;
import org.opensearch.client.tasks.GetTaskRequest;
import org.opensearch.client.tasks.GetTaskResponse;
import org.opensearch.client.tasks.TaskId;
import org.opensearch.client.tasks.TaskSubmissionResponse;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentOpenSearchExtension;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.discovery.ClusterManagerNotDiscoveredException;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.index.reindex.ReindexRequest;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.transport.NoNodeAvailableException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OpenSearchServiceImpl
implements OpenSearchService {
    private static final Logger LOGGER = LogManager.getLogger(OpenSearchServiceImpl.class);
    private BundleContext bundleContext;
    private EventRegistration eventRegistration;
    private OpenSearchServiceStatus status;
    private RestHighLevelClient _client;
    private long _clientRecreationsCnt = 0L;
    private String _version;
    private List<OpenSearchHost> initialOpenSearchHosts;
    private OpenSearchBasicAuthData basicAuthData;
    private OpenSearchPrivateKeyData privateKeyData;
    private ManagedIndicesHandler managedIndicesHandler;
    private Map<String, BpcIndexState> indexStates;
    private Map<String, Object> defaultIndexCreationSettings;
    private List defaultDynamicTemplates;
    private static final Object INDEX_STATES_LOCK = new Object();
    private static final Object CLIENT_LOCK = new Object();

    private OpenSearchServiceImpl() {
    }

    public static OpenSearchService create(BundleContext bundleContext, CoreBundleConfiguration conf) {
        List<OpenSearchHost> openSearchHosts;
        String hostsString;
        OpenSearchBasicAuthData basicAuthData = null;
        String openSearchUsername = conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.opensearch.username", null);
        String openSearchPassword = conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.opensearch.password", null);
        if (openSearchUsername != null && openSearchPassword != null) {
            basicAuthData = new OpenSearchBasicAuthData(openSearchUsername, openSearchPassword);
        }
        OpenSearchPrivateKeyData privateKeyData = null;
        String openSearchPrivateKeyAlias = conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.opensearch.privatekey.alias", null);
        if (openSearchPrivateKeyAlias != null) {
            String openSearchPrivateKeyPassword = conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.opensearch.privatekey.password", null);
            privateKeyData = new OpenSearchPrivateKeyData(openSearchPrivateKeyAlias, openSearchPrivateKeyPassword);
        }
        if (!StringUtil.isNullOrEmpty(hostsString = conf.getSystemPropertyValueAsString("de.virtimo.bpc.core.opensearch.hosts", null))) {
            openSearchHosts = OpenSearchHosts.create(hostsString);
        } else {
            LOGGER.warn("Configuration 'de.virtimo.bpc.core.opensearch.hosts' is empty. Using default host 'https://localhost:9200'.");
            openSearchHosts = OpenSearchHosts.create("https://localhost:9200");
        }
        return new OpenSearchServiceImpl(bundleContext, openSearchHosts, basicAuthData, privateKeyData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenSearchServiceImpl(BundleContext bundleContext, List<OpenSearchHost> openSearchHosts, OpenSearchBasicAuthData basicAuthData, OpenSearchPrivateKeyData privateKeyData) {
        LOGGER.info("OpenSearchServiceImpl bundleContext={}, openSearchHosts={}, basicAuthData={}, privateKeyData={}", (Object)bundleContext, openSearchHosts, (Object)basicAuthData, (Object)privateKeyData);
        this.bundleContext = bundleContext;
        this.status = OpenSearchServiceStatus.Starting;
        try {
            this.initialOpenSearchHosts = new ArrayList<OpenSearchHost>(openSearchHosts);
            this.basicAuthData = basicAuthData;
            this.privateKeyData = privateKeyData;
            this.indexStates = new ConcurrentHashMap<String, BpcIndexState>();
            this.defaultIndexCreationSettings = null;
            this.defaultDynamicTemplates = null;
            this._client = this.createClient();
            LOGGER.info("Hi OpenSearch {}", (Object)this._client.toString());
            this.managedIndicesHandler = new ManagedIndicesHandlerImpl(bundleContext, this);
            this.eventRegistration = new EventRegistration(bundleContext);
            this.eventRegistration.forModuleUpdatedEvents("_core", "indexCreationSettings", new DefaultIndexCreationSettingsSettingUpdatedEventHandler());
            this.eventRegistration.forModuleUpdatedEvents("_core", "indexDynamicTemplates", new DefaultDynamicTemplatesSettingUpdatedEventHandler());
            this.eventRegistration.forModuleUpdatedEvents("_core", "indexTemplates", new IndexTemplatesSettingUpdatedEventHandler());
        }
        finally {
            this.status = OpenSearchServiceStatus.Active;
        }
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownService() {
        block12: {
            LOGGER.info("shutdownService");
            this.status = OpenSearchServiceStatus.ShuttingDown;
            try {
                BpcServicesTracker.stopAll(this);
                this.eventRegistration.unregisterAllEventHandler();
                Destroyer.destroy(this.managedIndicesHandler);
                Object object = INDEX_STATES_LOCK;
                synchronized (object) {
                    for (BpcIndexState indexState : this.indexStates.values()) {
                        indexState.destroy();
                    }
                    this.indexStates.clear();
                }
                if (this._client == null) break block12;
                try {
                    this._client.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Failed to close the OpenSearch client", (Throwable)ex);
                }
                finally {
                    this._client = null;
                    this._version = null;
                }
            }
            finally {
                this.status = OpenSearchServiceStatus.ShutDown;
            }
        }
    }

    @Override
    public void setDefaultIndexCreationSettings(Map<String, Object> defaultIndexCreationSettings) {
        this.defaultIndexCreationSettings = defaultIndexCreationSettings;
    }

    @Override
    public Map<String, Object> getDefaultIndexCreationSettings() {
        return this.defaultIndexCreationSettings;
    }

    @Override
    public void setDefaultDynamicTemplates(List defaultDynamicTemplates) {
        this.defaultDynamicTemplates = defaultDynamicTemplates;
    }

    @Override
    public List getDefaultDynamicTemplates() {
        return this.defaultDynamicTemplates;
    }

    @Override
    public ManagedIndicesHandler getManagedIndicesHandler() {
        return this.managedIndicesHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIndexState(String indexAlias) {
        LOGGER.info("hasIndexState indexAlias={}", (Object)indexAlias);
        Object object = INDEX_STATES_LOCK;
        synchronized (object) {
            return this.indexStates.get(indexAlias) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BpcIndexState getIndexState(String indexAlias) {
        LOGGER.debug("getIndexState indexAlias={}", (Object)indexAlias);
        Object object = INDEX_STATES_LOCK;
        synchronized (object) {
            BpcIndexState indexState = this.indexStates.get(indexAlias);
            if (indexState == null) {
                indexState = new BpcIndexStateImpl(this, indexAlias);
                this.indexStates.put(indexAlias, indexState);
            }
            return indexState;
        }
    }

    private RestHighLevelClient createClient() {
        LOGGER.info("createClient");
        try {
            RestHighLevelClient restHighLevelClient = this.createClient(null);
            try {
                MainResponse infoResponse = restHighLevelClient.info(RequestOptions.DEFAULT);
                this._version = infoResponse.getVersion().getNumber();
            }
            catch (Exception exception) {
                // empty catch block
            }
            RestHighLevelClient restHighLevelClient2 = restHighLevelClient;
            return restHighLevelClient2;
        }
        finally {
            ++this._clientRecreationsCnt;
        }
    }

    @Override
    public RestHighLevelClient createClient(OpenSearchService.CreateClientCustomizerCallback clientCustomizer) {
        LOGGER.info("createClient clientCustomizer={}", (Object)clientCustomizer);
        HttpHost[] httpHosts = OpenSearchHosts.asHttpHosts(this.initialOpenSearchHosts);
        RestClientBuilder restClientBuilder = RestClient.builder(httpHosts);
        OpenSearchHttpClientConfigCallback openSearchHttpClientConfigCallback = new OpenSearchHttpClientConfigCallback(this.bundleContext, this.basicAuthData, OpenSearchHosts.usesHttps(httpHosts), this.privateKeyData);
        restClientBuilder.setHttpClientConfigCallback(openSearchHttpClientConfigCallback);
        if (clientCustomizer != null) {
            clientCustomizer.customize(restClientBuilder);
        }
        return new RestHighLevelClient(restClientBuilder);
    }

    private boolean isIOReactorStopped(RestHighLevelClient client) {
        LOGGER.debug("isIOReactorStopped client={}", (Object)client);
        try {
            DefaultConnectingIOReactor ioReactor;
            IOReactorStatus ioReactorStatus;
            RestClient lowLevelClient = client.getLowLevelClient();
            Field clientField = RestClient.class.getDeclaredField("client");
            clientField.setAccessible(true);
            Object clientFieldValue = clientField.get(lowLevelClient);
            Field ioReactorField = OpenSearchServiceImpl.getFieldFromHierarchy(clientFieldValue.getClass(), "ioReactor");
            ioReactorField.setAccessible(true);
            Object ioReactorFieldValue = ioReactorField.get(clientFieldValue);
            if (ioReactorFieldValue instanceof DefaultConnectingIOReactor && ((ioReactorStatus = (ioReactor = (DefaultConnectingIOReactor)ioReactorFieldValue).getStatus()) == IOReactorStatus.SHUTTING_DOWN || ioReactorStatus == IOReactorStatus.SHUT_DOWN)) {
                return true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Failed to check if the I/O reactor of the OpenSearch RestHighLevelClient is in status 'STOPPED'.", (Throwable)ex);
        }
        return false;
    }

    public static Field getFieldFromHierarchy(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            try {
                Field field = current.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestHighLevelClient getClient() {
        LOGGER.debug("getClient");
        Object object = CLIENT_LOCK;
        synchronized (object) {
            if (this.status == OpenSearchServiceStatus.Active && this._client != null && this.isIOReactorStopped(this._client)) {
                LOGGER.warn("Not good ... the I/O reactor status of the OpenSearch client is in status 'STOPPED' and must be re-created. This has already been done: {} times", (Object)this._clientRecreationsCnt);
                this._client = this.createClient();
            }
            return this._client;
        }
    }

    @Override
    public String getHost() {
        return "localhost";
    }

    @Override
    public int getPort() {
        return 9200;
    }

    @Override
    public String getScheme() {
        return "http";
    }

    @Override
    public String getOpenSearchVersion() {
        return this._version;
    }

    @Override
    public boolean existsIndex(String indexOrAliasName) throws OpenSearchRelatedException {
        LOGGER.info("existsIndex indexOrAliasName={}", (Object)indexOrAliasName);
        try {
            RestHighLevelClient client = this.getClient();
            if (client.indices().existsAlias(new GetAliasesRequest(indexOrAliasName), RequestOptions.DEFAULT)) {
                return true;
            }
            return client.indices().exists(new GetIndexRequest(indexOrAliasName), RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean createIndex(String indexName) throws OpenSearchRelatedException {
        LOGGER.info("createIndex name={}", (Object)indexName);
        try {
            CreateIndexResponse createIndexResponse = this.getClient().indices().create(new CreateIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!createIndexResponse.isAcknowledged()) {
                LOGGER.warn("Creation of index '{}' has not been acknowledged.", (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean createIndex(String indexName, Map<String, Object> settings) throws OpenSearchRelatedException {
        LOGGER.info("createIndex indexName={}, settings={}", (Object)indexName, settings);
        try {
            CreateIndexResponse createIndexResponse = this.getClient().indices().create(new CreateIndexRequest(indexName).settings(settings), RequestOptions.DEFAULT);
            if (!createIndexResponse.isAcknowledged()) {
                LOGGER.warn("Creation of index '{}' has not been acknowledged.", (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String createIndex(String aliasName, Map<String, Object> settings, Map<String, Object> mappings) throws OpenSearchRelatedException {
        LOGGER.debug("createIndex aliasName={}, settings={}, mappings={}", (Object)aliasName, settings, mappings);
        if (StringUtil.isNullOrEmpty(aliasName)) {
            throw new NullPointerException("An aliasName must be given.");
        }
        String indexName = this.getIndexNameOfAlias(aliasName);
        if (indexName != null) return indexName;
        if (!this.acquireLock(aliasName)) throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Index creation not possible. Failed to acquire a lock for the OpenSearch alias: '{alias}'.", MapUtil.mapOf("alias", aliasName));
        try {
            indexName = this.getIndexNameOfAlias(aliasName);
            if (indexName != null) return indexName;
            indexName = this.createIndex(aliasName, null, settings, mappings);
            return indexName;
        }
        finally {
            this.releaseLock(aliasName);
        }
    }

    private String getIndexNameOfAlias(String aliasName) throws OpenSearchRelatedException {
        Set<String> indexNamesWithAlias = this.getIndexNamesWithAlias(aliasName);
        if (!indexNamesWithAlias.isEmpty()) {
            if (indexNamesWithAlias.size() == 1) {
                return indexNamesWithAlias.iterator().next();
            }
            throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_EXCEPTION, "Index creation not necessary and not possible. Please be sure that the alias '{alias}' is assigned to one index only.", MapUtil.mapOf("alias", aliasName));
        }
        return null;
    }

    @Override
    public String createIndex(String aliasName, String indexName, Map<String, Object> settings, Map<String, Object> mappings) throws OpenSearchRelatedException {
        LOGGER.info("createIndex aliasName={}, indexName={}, settings={}, mappings={}", (Object)aliasName, (Object)indexName, settings, mappings);
        if (StringUtil.isNullOrEmpty(aliasName) && StringUtil.isNullOrEmpty(indexName)) {
            throw new NullPointerException("An aliasName and/or indexName must be given.");
        }
        if (StringUtil.isNullOrEmpty(indexName)) {
            indexName = this.newIndexNameForAlias(aliasName);
        }
        LOGGER.debug("created index name: {}", (Object)indexName);
        CreateIndexRequest cir = new CreateIndexRequest(indexName);
        if (!StringUtil.isNullOrEmpty(aliasName)) {
            LOGGER.debug("add alias: {}", (Object)aliasName);
            cir.alias(new Alias(aliasName));
        }
        if (settings != null) {
            LOGGER.debug("add settings");
            Map<String, Object> cleanedSettings = OpenSearchSettingsCleaner.clearSettingsMapFromKnownPrivateSettings(settings);
            cir.settings(cleanedSettings);
        }
        if (mappings != null) {
            LOGGER.debug("add mapping {}", mappings);
            cir.mapping(mappings);
        }
        LOGGER.debug("create Index: {}", (Object)cir.toString());
        try {
            this.getClient().indices().create(cir, RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return indexName;
    }

    @Override
    public Map<String, Object> getMapping(String indexName) {
        LOGGER.debug("getMapping indexName={}", (Object)indexName);
        try {
            return this.getMappingMetaData(indexName).sourceAsMap();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the mapping of the index '{}'.", (Object)indexName, (Object)ex);
            return null;
        }
    }

    @Override
    public MappingMetadata getMappingMetaData(String indexName) throws OpenSearchIndexMappingNotFoundException, OpenSearchIndexNotFoundException, OpenSearchRelatedException {
        try {
            GetMappingsResponse response = this.getClient().indices().getMapping(new GetMappingsRequest().indices(indexName), RequestOptions.DEFAULT);
            Map<String, MappingMetadata> mappings = response.mappings();
            if (mappings != null && !mappings.isEmpty()) {
                return mappings.values().iterator().next();
            }
            throw new OpenSearchIndexMappingNotFoundException(indexName);
        }
        catch (OpenSearchStatusException ex) {
            if (RestStatus.NOT_FOUND == ex.status() && ex.getMessage().contains("index_not_found_exception")) {
                throw new OpenSearchIndexNotFoundException(indexName);
            }
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public Map<String, Object> getSettings(String indexName) {
        LOGGER.debug("getSettings indexName={}", (Object)indexName);
        try {
            GetSettingsResponse response = this.getClient().indices().getSettings(new GetSettingsRequest().indices(indexName), RequestOptions.DEFAULT);
            if (response != null) {
                Map<String, Settings> indexToSettings = response.getIndexToSettings();
                Settings settings = indexToSettings.get(indexName);
                try {
                    Method getAsStructuredMapMethod = settings.getClass().getDeclaredMethod("getAsStructuredMap", new Class[0]);
                    getAsStructuredMapMethod.setAccessible(true);
                    Map structuredMap = (Map)getAsStructuredMapMethod.invoke((Object)settings, new Object[0]);
                    return (Map)structuredMap.get("index");
                }
                catch (Exception exception) {}
            }
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                LOGGER.error("Failed to get the settings of the not existing index '{}'.", (Object)indexName);
            } else {
                LOGGER.error("Unhandled exception in OpenSearchServiceImpl.getSettings(). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)ex.status(), (Object)ex);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to get the settings of the index '{}'.", (Object)indexName, (Object)ex);
        }
        return null;
    }

    @Override
    public Map<String, String> getFieldsTypeMapping(String index) {
        LinkedHashMap properties;
        LOGGER.info("getFieldsTypeMapping index={}", (Object)index);
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> map = this.getMapping(index);
        if (map != null && (properties = (LinkedHashMap)map.get("properties")) != null) {
            for (String key : properties.keySet()) {
                LinkedHashMap value = (LinkedHashMap)properties.get(key);
                String columnType = (String)value.get("type");
                if (columnType == null) continue;
                LOGGER.info("OpenSearch fieldname:{}, type:{}", (Object)key, (Object)columnType);
                result.put(key, columnType);
            }
        }
        return result;
    }

    @Override
    public Set<String> getFieldNamesOfType(String index, String type) {
        LOGGER.info("getFieldNamesOfType index={}, type={}", (Object)index, (Object)type);
        HashSet<String> result = new HashSet<String>();
        Map<String, String> fieldsTypeMapping = this.getFieldsTypeMapping(index);
        for (String fieldName : fieldsTypeMapping.keySet()) {
            String fieldType = fieldsTypeMapping.get(fieldName);
            if (!fieldType.equalsIgnoreCase(type)) continue;
            result.add(fieldName);
        }
        return result;
    }

    @Override
    public boolean copyIndexMapping(String sourceIndexName, String targetIndexName) throws OpenSearchRelatedException {
        LOGGER.debug("copyIndexMapping sourceIndexName={}, targetIndexName={}", (Object)sourceIndexName, (Object)targetIndexName);
        try {
            RestHighLevelClient client = this.getClient();
            GetMappingsResponse mappingsResponse = client.indices().getMapping(new GetMappingsRequest().indices(sourceIndexName), RequestOptions.DEFAULT);
            Map<String, MappingMetadata> mappingsByIndex = mappingsResponse.mappings();
            for (MappingMetadata mappingMetaData : mappingsByIndex.values()) {
                PutMappingRequest pmr = new PutMappingRequest(targetIndexName);
                pmr.source(mappingMetaData.sourceAsMap());
                AcknowledgedResponse putMappingResponse = client.indices().putMapping(pmr, RequestOptions.DEFAULT);
                if (putMappingResponse.isAcknowledged()) continue;
                LOGGER.warn("Setting the source mapping to the target index '{}' has not been acknowledged.", (Object)targetIndexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean hasDynamicTemplatesMapping(String indexName) {
        LOGGER.info("hasDynamicTemplatesMapping indexName={}", (Object)indexName);
        return this.hasDynamicTemplatesMapping(this.getMapping(indexName));
    }

    @Override
    public boolean hasDynamicTemplatesMapping(Map<String, Object> mapping) {
        return mapping != null && mapping.containsKey("dynamic_templates");
    }

    @Override
    public boolean deleteIndex(String indexName) throws OpenSearchRelatedException {
        LOGGER.info("deleteIndex indexName={}", (Object)indexName);
        try {
            AcknowledgedResponse deleteIndexResponse = this.getClient().indices().delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!deleteIndexResponse.isAcknowledged()) {
                LOGGER.warn("Deletion of index '{}' has not been acknowledged.", (Object)indexName);
                return false;
            }
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() != RestStatus.NOT_FOUND) {
                LOGGER.error("Unhandled exception in OpenSearchServiceImpl.deleteIndex(). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)ex.status(), (Object)ex);
                throw new OpenSearchRelatedException(ex);
            }
            LOGGER.info("The OpenSearch index '{}' to delete does not exist.", (Object)indexName);
            return false;
        }
        catch (Throwable t) {
            LOGGER.error("Could not delete the OpenSearch index '{}'", (Object)indexName, (Object)t);
            return false;
        }
        return true;
    }

    @Override
    public void deleteIndexWithException(String indexName) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("deleteIndexWithException indexName={}", (Object)indexName);
        try {
            AcknowledgedResponse deleteIndexResponse = this.getClient().indices().delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!deleteIndexResponse.isAcknowledged()) {
                LOGGER.warn("Deletion of index '{}' issued, but was not acknowledged.", (Object)indexName);
            } else {
                LOGGER.info("Index '{}' deleted successfully.", (Object)indexName);
            }
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new OpenSearchIndexNotFoundException(indexName);
            }
            throw new OpenSearchRelatedException(ex);
        }
        catch (Throwable t) {
            throw new OpenSearchRelatedException(t);
        }
    }

    @Override
    public boolean closeIndex(String indexName) throws OpenSearchRelatedException {
        LOGGER.info("closeIndex indexName={}", (Object)indexName);
        try {
            CloseIndexResponse closeIndexResponse = this.getClient().indices().close(new CloseIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!closeIndexResponse.isAcknowledged()) {
                LOGGER.warn("Closing the index '{}' has not been acknowledged", (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean openIndex(String indexName) throws OpenSearchRelatedException {
        LOGGER.info("openIndex indexName={}", (Object)indexName);
        try {
            OpenIndexResponse openIndexResponse = this.getClient().indices().open(new OpenIndexRequest(indexName), RequestOptions.DEFAULT);
            if (!openIndexResponse.isAcknowledged()) {
                LOGGER.warn("Opening the index '{}' has not been acknowledged.", (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public String newIndexNameForAlias(String aliasName) {
        LOGGER.info("newIndexNameForAlias={}", (Object)aliasName);
        return aliasName + "_" + new Date().getTime();
    }

    @Override
    public String aliasFromBpcIndexName(String indexName) {
        Pattern pattern;
        Matcher matcher;
        LOGGER.info("aliasFromBpcIndexName={}", (Object)indexName);
        if (indexName != null && !indexName.isEmpty() && (matcher = (pattern = Pattern.compile("^(.+)_\\d+$")).matcher(indexName)).find()) {
            String aliasName = matcher.group(1);
            return aliasName;
        }
        return null;
    }

    @Override
    public long getCreationTimestampOfIndexName(String aliasName, String indexName) {
        LOGGER.debug("getCreationTimestampOfIndexName aliasName={} indexName={}", (Object)aliasName, (Object)indexName);
        if (aliasName == null || indexName == null) {
            return -1L;
        }
        if (!indexName.startsWith(aliasName + "_")) {
            return -1L;
        }
        String creationTimestampString = indexName.substring(aliasName.length() + 1);
        try {
            return Long.valueOf(creationTimestampString);
        }
        catch (Exception ex) {
            LOGGER.error("Could not convert '{}' to a long value.", (Object)creationTimestampString, (Object)ex);
            return -1L;
        }
    }

    @Override
    public boolean addAliasToIndex(String aliasName, String indexName) throws OpenSearchRelatedException {
        LOGGER.info("addAliasToIndex alias:" + aliasName + ", index:" + indexName);
        try {
            IndicesAliasesRequest.AliasActions addAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexName).alias(aliasName);
            IndicesAliasesRequest addAliasRequest = new IndicesAliasesRequest().addAliasAction(addAliasAction);
            AcknowledgedResponse indicesAliasesResponse = this.getClient().indices().updateAliases(addAliasRequest, RequestOptions.DEFAULT);
            if (!indicesAliasesResponse.isAcknowledged()) {
                LOGGER.warn("Adding the alias '{}' to the index '{}' has not been acknowledged", (Object)aliasName, (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean moveAlias(String sourceIndexName, String targetIndexName) throws OpenSearchRelatedException {
        LOGGER.info("moveAlias sourceIndexName={}, targetIndexName={}", (Object)sourceIndexName, (Object)targetIndexName);
        Set<String> sourceIndexAliases = this.getAliasesForIndexName(sourceIndexName);
        LOGGER.debug("Source index aliases = {}", sourceIndexAliases);
        try {
            if (!sourceIndexAliases.isEmpty()) {
                IndicesAliasesRequest moveAliasRequest = new IndicesAliasesRequest();
                for (String sourceIndexAlias : sourceIndexAliases) {
                    IndicesAliasesRequest.AliasActions addAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(targetIndexName).alias(sourceIndexAlias);
                    IndicesAliasesRequest.AliasActions removeAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(sourceIndexName).alias(sourceIndexAlias);
                    moveAliasRequest.addAliasAction(addAliasAction);
                    moveAliasRequest.addAliasAction(removeAliasAction);
                }
                AcknowledgedResponse indicesAliasesResponse = this.getClient().indices().updateAliases(moveAliasRequest, RequestOptions.DEFAULT);
                if (!indicesAliasesResponse.isAcknowledged()) {
                    LOGGER.warn("Alias modification has not been acknowledged. Source index:{}, target index:{}", (Object)sourceIndexName, (Object)targetIndexName);
                    return false;
                }
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean removeAlias(String indexName, String aliasName) throws OpenSearchRelatedException {
        LOGGER.info("removeAlias indexName={}, aliasName={}", (Object)indexName, (Object)aliasName);
        try {
            IndicesAliasesRequest.AliasActions removeAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(indexName).alias(aliasName);
            IndicesAliasesRequest removeAliasRequest = new IndicesAliasesRequest().addAliasAction(removeAliasAction);
            AcknowledgedResponse indicesAliasesResponse = this.getClient().indices().updateAliases(removeAliasRequest, RequestOptions.DEFAULT);
            if (!indicesAliasesResponse.isAcknowledged()) {
                LOGGER.warn("Alias modification has not been acknowledged. Index:{}, alias:{}", (Object)indexName, (Object)aliasName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public Set<String> getAliasesOfAllIndices() throws OpenSearchRelatedException {
        LOGGER.debug("getAliasesOfAllIndices");
        try {
            GetAliasesResponse aliasesResponseOfAllIndices = this.getClient().indices().getAlias(new GetAliasesRequest().indices("*"), RequestOptions.DEFAULT);
            HashSet<String> result = new HashSet<String>();
            Map<String, Set<AliasMetadata>> indexNamesWithAliases = aliasesResponseOfAllIndices.getAliases();
            for (String indexName : indexNamesWithAliases.keySet()) {
                Set<AliasMetadata> aliasMetadata = indexNamesWithAliases.get(indexName);
                for (AliasMetadata aliasMetadatum : aliasMetadata) {
                    result.add(aliasMetadatum.alias());
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public Set<String> getAliasesForIndexName(String indexName) throws OpenSearchRelatedException {
        LOGGER.info("getAliasesForIndexName indexName={}", (Object)indexName);
        try {
            HashSet<String> result = new HashSet<String>();
            GetAliasesResponse response = this.getClient().indices().getAlias(new GetAliasesRequest().indices(indexName), RequestOptions.DEFAULT);
            for (String aliasIndexName : response.getAliases().keySet()) {
                Set<AliasMetadata> metaDatas = response.getAliases().get(aliasIndexName);
                for (AliasMetadata metaData : metaDatas) {
                    result.add(metaData.alias());
                }
            }
            return result;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public Set<String> getIndexNamesWithAlias(String aliasName) throws OpenSearchRelatedException {
        LOGGER.info("getIndexNamesWithAlias aliasName={}", (Object)aliasName);
        try {
            GetAliasesResponse response = this.getClient().indices().getAlias(new GetAliasesRequest().aliases(aliasName), RequestOptions.DEFAULT);
            return new HashSet<String>(response.getAliases().keySet());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    @NotNull
    public String getBpcIndexNameForAlias(String indexAlias) throws OpenSearchRelatedException {
        LOGGER.info("getBpcIndexNameForAlias indexAlias={}", (Object)indexAlias);
        Set<String> indexNames = this.getIndexNamesWithAlias(indexAlias);
        if (indexNames.isEmpty()) {
            throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_FAILED, "The OpenSearch alias '${indexAlias}' is probably an index and not just an alias for an index. Please fix this.", MapUtil.mapOf("indexAlias", indexAlias));
        }
        if (indexNames.size() != 1) {
            throw new OpenSearchRelatedException((ErrorCode)BpcErrorCode.OPENSEARCH_FAILED, "The OpenSearch alias '${indexAlias}' has multiple indices assigned. Please fix this.", MapUtil.mapOf("indexAlias", indexAlias));
        }
        return indexNames.iterator().next();
    }

    @Override
    @NotNull
    public List<String> getAllIndexNamesWithPrefix(String indexNamePrefix) throws OpenSearchRelatedException {
        LOGGER.info("getAllIndexNamesWithPrefix indexNamePrefix={}", (Object)indexNamePrefix);
        ArrayList<String> result = new ArrayList<String>();
        try {
            GetIndexResponse response = this.getClient().indices().get(new GetIndexRequest("*"), RequestOptions.DEFAULT);
            String[] allIndexNames = response.getIndices();
            if (allIndexNames != null) {
                for (String indiceName : allIndexNames) {
                    if (indexNamePrefix != null && !indiceName.startsWith(indexNamePrefix)) continue;
                    result.add(indiceName);
                }
            }
            return result;
        }
        catch (OpenSearchStatusException ex) {
            if (ex.status() != RestStatus.NOT_FOUND) {
                throw new OpenSearchRelatedException(ex);
            }
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        return result;
    }

    @Override
    @NotNull
    public List<String> getAllBpcIndexNamesWithAlias(String bpcAlias) throws OpenSearchRelatedException {
        LOGGER.info("getAllBpcIndexNamesWithAliasPrefix bpcAlias={}", (Object)bpcAlias);
        ArrayList<String> result = new ArrayList<String>();
        for (String indexName : this.getAllIndexNamesWithPrefix(bpcAlias)) {
            String extractedAliasFromIndexName = this.aliasFromBpcIndexName(indexName);
            if (!bpcAlias.equals(extractedAliasFromIndexName) || result.contains(indexName)) continue;
            result.add(indexName);
        }
        return result;
    }

    @Override
    public void refreshIndices(String ... indexNames) throws OpenSearchRelatedException {
        LOGGER.info("refreshIndices indexNames={}", (Object)Arrays.toString(indexNames));
        try {
            RefreshResponse refreshResponse = this.getClient().indices().refresh(new RefreshRequest(indexNames), RequestOptions.DEFAULT);
            LOGGER.info("Refresh request successful? {}. Executed with {} successful shards and {} failed shards.", (Object)(refreshResponse.getStatus() == RestStatus.OK ? 1 : 0), (Object)refreshResponse.getSuccessfulShards(), (Object)refreshResponse.getFailedShards());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void flushIndices(String ... indexNames) throws OpenSearchRelatedException {
        LOGGER.info("flushIndices indexNames={}", (Object)Arrays.toString(indexNames));
        try {
            FlushRequest flushRequest = new FlushRequest(indexNames).waitIfOngoing(true);
            FlushResponse flushResponse = this.getClient().indices().flush(flushRequest, RequestOptions.DEFAULT);
            LOGGER.info("Flush request successful? {}. Executed with {} successful shards and {} failed shards.", (Object)(flushResponse.getStatus() == RestStatus.OK ? 1 : 0), (Object)flushResponse.getSuccessfulShards(), (Object)flushResponse.getFailedShards());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void reindex(String sourceIndexName, String targetIndexName, QueryBuilder filterQuery) throws OpenSearchRelatedException {
        LOGGER.info("reindex sourceIndexName={}, targetIndexName={}, filterQuery={}", (Object)sourceIndexName, (Object)targetIndexName, (Object)filterQuery);
        try {
            ReindexRequest request = ((ReindexRequest)new ReindexRequest().setSourceIndices(sourceIndexName).setDestIndex(targetIndexName).setRefresh(true)).setSourceQuery(filterQuery);
            TaskSubmissionResponse reindexTaskSubmissionResponse = this.getClient().submitReindexTask(request, RequestOptions.DEFAULT);
            TaskId reindexTaskId = new TaskId(reindexTaskSubmissionResponse.getTask());
            this.waitForTaskCompletionByPollingStatus(reindexTaskId, 3000L);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (RuntimeException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void waitForTaskCompletionByPollingStatus(TaskId taskId, long pollTimeInMillis) throws OpenSearchRelatedException {
        LOGGER.info("waitForTaskCompletionByPollingStatus taskId={}, pollTimeInMillis={}", (Object)taskId, (Object)pollTimeInMillis);
        try {
            GetTaskRequest getTaskRequest;
            Optional<GetTaskResponse> getTaskResponse;
            do {
                this.threadSleepAndIgnoreInterruptions(pollTimeInMillis);
                getTaskRequest = new GetTaskRequest(taskId.getNodeId(), taskId.getId());
            } while ((getTaskResponse = this.getClient().tasks().get(getTaskRequest, RequestOptions.DEFAULT)).isPresent() && !getTaskResponse.get().isCompleted());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (RuntimeException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private void threadSleepAndIgnoreInterruptions(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Ignored thread sleep interruption.", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getMetaDataValues(String indexName) {
        LOGGER.info("getMetaDataValues indexName={}", (Object)indexName);
        Map<String, Object> mappingsMap = this.getMapping(indexName);
        if (mappingsMap != null) {
            return (Map)mappingsMap.get("_meta");
        }
        return null;
    }

    @Override
    public boolean setMetaDataValues(String indexName, Map<String, Object> values) throws OpenSearchRelatedException {
        LOGGER.info("setMetaDataValues indexName={}, values={}", (Object)indexName, values);
        try {
            HashMap<String, Map<String, Object>> mappings = new HashMap<String, Map<String, Object>>();
            mappings.put("_meta", values);
            String mappingsAsJsonString = JsonUtil.getInstance().convertPojoToJsonString(mappings);
            LOGGER.info("mappingsAsJsonString = {}", (Object)mappingsAsJsonString);
            PutMappingRequest request = new PutMappingRequest(indexName).source(mappingsAsJsonString, (MediaType)XContentType.JSON);
            AcknowledgedResponse putMappingResponse = this.getClient().indices().putMapping(request, RequestOptions.DEFAULT);
            if (!putMappingResponse.isAcknowledged()) {
                LOGGER.warn("Mapping update on index '{}' has not been acknowledged.", (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public Object getMetaDataValue(String indexName, String propertyName) {
        LOGGER.info("getMetaDataValue indexName={}, propertyName={}", (Object)indexName, (Object)propertyName);
        Map<String, Object> props = this.getMetaDataValues(indexName);
        if (props != null) {
            return props.get(propertyName);
        }
        return null;
    }

    @Override
    public boolean setMetaDataValue(String indexName, String propertyName, Object propertyValue) throws OpenSearchRelatedException {
        LOGGER.info("setMetaDataValue indexName={}, propertyName={}, propertyValue={}", (Object)indexName, (Object)propertyName, propertyValue);
        Map<String, Object> props = this.getMetaDataValues(indexName);
        if (props == null) {
            props = new HashMap<String, Object>();
        }
        props.put(propertyName, propertyValue);
        return this.setMetaDataValues(indexName, props);
    }

    @Override
    public boolean removeMetaDataValue(String indexName, String propertyName) throws OpenSearchRelatedException {
        LOGGER.info("removeMetaDataValue indexName={}, propertyName={}", (Object)indexName, (Object)propertyName);
        Map<String, Object> props = this.getMetaDataValues(indexName);
        if (props == null) {
            return true;
        }
        props.remove(propertyName);
        return this.setMetaDataValues(indexName, props);
    }

    @Override
    public int getModelVersion(String indexName) {
        LOGGER.info("getModelVersion indexName={}", (Object)indexName);
        Object modelVersionObject = this.getMetaDataValue(indexName, "model_version");
        if (modelVersionObject instanceof Integer) {
            Integer modelVersion = (Integer)modelVersionObject;
            LOGGER.info("Found the model version '{}' in '{}'", (Object)modelVersion, (Object)indexName);
            return modelVersion;
        }
        LOGGER.info("Did not find the model version in '{}'. Using 1 as the version", (Object)indexName);
        return 1;
    }

    @Override
    public boolean setModelVersion(String indexName, int modelVersion) throws OpenSearchRelatedException {
        LOGGER.info("setModelVersion indexName={}, modelVersion={}", (Object)indexName, (Object)modelVersion);
        return this.setMetaDataValue(indexName, "model_version", modelVersion);
    }

    @Override
    @NotNull
    public Set<String> getTemplateNames() throws OpenSearchRelatedException {
        HashSet<String> result;
        block4: {
            LOGGER.info("getTemplateNames");
            result = new HashSet<String>();
            try {
                GetIndexTemplatesResponse getIndexTemplatesResponse = this.getClient().indices().getIndexTemplate(new GetIndexTemplatesRequest("*"), RequestOptions.DEFAULT);
                List<IndexTemplateMetadata> indexTemplates = getIndexTemplatesResponse.getIndexTemplates();
                for (IndexTemplateMetadata indexTemplate : indexTemplates) {
                    result.add(indexTemplate.name());
                }
            }
            catch (IOException ex) {
                throw new OpenSearchRelatedException(ex);
            }
            catch (OpenSearchException ex) {
                if (ex.status() == RestStatus.NOT_FOUND) break block4;
                throw new OpenSearchRelatedException(ex);
            }
        }
        return result;
    }

    @Override
    @NotNull
    public Set<String> getTemplateNamesWithPrefix(String prefix) throws OpenSearchRelatedException {
        LOGGER.info("getTemplateNamesWithPrefix prefix={}", (Object)prefix);
        HashSet<String> result = new HashSet<String>();
        for (String templateName : this.getTemplateNames()) {
            if (!templateName.startsWith(prefix)) continue;
            result.add(templateName);
        }
        return result;
    }

    @Override
    public boolean deleteTemplate(String templateName) throws OpenSearchRelatedException {
        LOGGER.info("deleteTemplate templateName={}", (Object)templateName);
        try {
            AcknowledgedResponse deleteIndexTemplateResponse = this.getClient().indices().deleteTemplate(new DeleteIndexTemplateRequest(templateName), RequestOptions.DEFAULT);
            if (!deleteIndexTemplateResponse.isAcknowledged()) {
                LOGGER.warn("Deletion of the index template '{}' has not been acknowledged.", (Object)templateName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean createTemplate(String templateName, Map<String, Object> templateValue) throws OpenSearchRelatedException {
        LOGGER.info("createTemplate templateName={}, templateValue=...", (Object)templateName);
        try {
            AcknowledgedResponse putIndexTemplateResponse = this.getClient().indices().putTemplate(new PutIndexTemplateRequest(templateName).source(templateValue), RequestOptions.DEFAULT);
            if (!putIndexTemplateResponse.isAcknowledged()) {
                LOGGER.warn("Creation of the template '{}' has not been acknowledged.", (Object)templateName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean updateIndexSettings(String indexName, Settings.Builder settingsBuilder) throws OpenSearchRelatedException {
        LOGGER.info("updateIndexSettings indexName={}, settingsBuilder={}", (Object)indexName, (Object)settingsBuilder);
        try {
            AcknowledgedResponse updateSettingsResponse = this.getClient().indices().putSettings(new UpdateSettingsRequest(indexName).settings(settingsBuilder), RequestOptions.DEFAULT);
            if (!updateSettingsResponse.isAcknowledged()) {
                LOGGER.warn("Updating the settings of the index '{}' has not been acknowledged.", (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean updateIndexMapping(String indexName, Map<String, Object> mapping) throws OpenSearchRelatedException {
        LOGGER.info("updateIndexMapping indexName={}, mapping=...", (Object)indexName);
        try {
            PutMappingRequest putMappingRequest = new PutMappingRequest(indexName).source(mapping);
            AcknowledgedResponse updateMappingsResponse = this.getClient().indices().putMapping(putMappingRequest, RequestOptions.DEFAULT);
            if (!updateMappingsResponse.isAcknowledged()) {
                LOGGER.warn("Updating the mappings of the index '{}' has not been acknowledged.", (Object)indexName);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private static String getWaitTime(long startTime, long maxRetryTimeMillis) {
        return "(" + (System.currentTimeMillis() - startTime) / 1000L + " / " + maxRetryTimeMillis / 1000L + " seconds)";
    }

    @Override
    public boolean waitForOpenSearch(int waitMaxSeconds, String[] indices) throws InterruptedException {
        LOGGER.info("waitForOpenSearch waitMaxSeconds={}, indices={}", (Object)waitMaxSeconds, (Object)(indices == null ? null : Arrays.toString(indices)));
        long retryMillis = 2000L;
        long maxRetryTimeMillis = waitMaxSeconds * 1000;
        long startTimeMillis = System.currentTimeMillis();
        while (System.currentTimeMillis() < startTimeMillis + maxRetryTimeMillis) {
            try {
                ClusterHealthRequest request = indices == null ? new ClusterHealthRequest().waitForStatus(ClusterHealthStatus.RED).timeout(TimeValue.timeValueMillis(1000L)) : new ClusterHealthRequest(indices).waitForStatus(ClusterHealthStatus.YELLOW).timeout(TimeValue.timeValueMillis(1000L));
                ClusterHealthResponse clusterHealthResponse = this.getClient().cluster().health(request, RequestOptions.DEFAULT);
                if (clusterHealthResponse.isTimedOut()) {
                    LOGGER.warn("OpenSearch cannot be reached. Did get a timeout. {}", (Object)OpenSearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis));
                    Thread.sleep(retryMillis);
                    continue;
                }
                LOGGER.info("OpenSearch is available!");
                return true;
            }
            catch (NoNodeAvailableException ex) {
                LOGGER.warn("OpenSearch cannot be reached. Still no started? {}", (Object)OpenSearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis));
                Thread.sleep(retryMillis);
            }
            catch (ClusterManagerNotDiscoveredException ex) {
                LOGGER.warn("OpenSearch cannot be reached. But we are very close. {}", (Object)OpenSearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis));
                Thread.sleep(retryMillis);
            }
            catch (Exception ex) {
                LOGGER.error("OpenSearch cannot be reached. Unhandled exception received. {}", (Object)OpenSearchServiceImpl.getWaitTime(startTimeMillis, maxRetryTimeMillis), (Object)ex);
                Thread.sleep(retryMillis);
            }
        }
        return false;
    }

    public String toString() {
        return "OpenSearchServiceImpl{client=" + String.valueOf(this._client) + "}";
    }

    @Override
    public void prepareManagedIndices(Bundle bundle) throws OpenSearchRelatedException {
        LOGGER.debug("prepareManagedIndices bundle={}", (Object)bundle);
        try {
            this.waitForOpenSearch(30, null);
            this.getManagedIndicesHandler().prepareManagedIndices(bundle);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed prepare managed indices", (Throwable)e);
        }
    }

    @Override
    public void prepareManagedIndices(Map<String, Object> managedIndicesConfigMap) throws OpenSearchRelatedException {
        LOGGER.debug("prepareManagedIndices managedIndicesConfigMap={}", managedIndicesConfigMap);
        try {
            this.waitForOpenSearch(30, null);
            this.getManagedIndicesHandler().prepareManagedIndices(managedIndicesConfigMap);
        }
        catch (InterruptedException e) {
            LOGGER.error("Failed prepare managed indices", (Throwable)e);
        }
    }

    private String createLockIndexName(String alias) {
        return alias + "_creation_lock";
    }

    @Override
    public boolean acquireLock(String alias) throws OpenSearchRelatedException {
        LOGGER.debug("acquireLock alias={}", (Object)alias);
        long timeoutInSeconds = 6L;
        long startTime = System.currentTimeMillis();
        boolean lockAcquired = false;
        while (!lockAcquired) {
            boolean timeout;
            lockAcquired = this.createAcquireLock(alias);
            if (lockAcquired) continue;
            boolean bl = timeout = startTime + timeoutInSeconds * 1000L < System.currentTimeMillis();
            if (timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return lockAcquired;
    }

    public boolean createAcquireLock(String alias) throws OpenSearchRelatedException {
        LOGGER.debug("createAcquireLock alias={}", (Object)alias);
        try {
            String lockIndexName = this.createLockIndexName(alias);
            CreateIndexRequest request = new CreateIndexRequest(lockIndexName);
            request.settings(Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 1));
            request.mapping("{\"properties\": {}}", (MediaType)XContentType.JSON);
            CreateIndexResponse response = this.getClient().indices().create(request, RequestOptions.DEFAULT);
            return response.isAcknowledged();
        }
        catch (OpenSearchStatusException ex) {
            if (ex.status() == RestStatus.BAD_REQUEST) {
                return false;
            }
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void releaseLock(String alias) throws OpenSearchRelatedException {
        LOGGER.debug("releaseLock alias={}", (Object)alias);
        try {
            String lockIndexName = this.createLockIndexName(alias);
            this.getClient().indices().delete(new DeleteIndexRequest(lockIndexName), RequestOptions.DEFAULT);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean releaseScrollId(SearchResponse searchResponse) {
        LOGGER.debug("releaseScrollId searchResponse={}", (Object)searchResponse);
        if (searchResponse != null) {
            return this.releaseScrollId(searchResponse.getScrollId());
        }
        return false;
    }

    @Override
    public boolean releaseScrollId(String scrollId) {
        LOGGER.debug("releaseScrollId scrollId={}", (Object)scrollId);
        if (scrollId != null) {
            try {
                ClearScrollRequest request = new ClearScrollRequest();
                request.addScrollId(scrollId);
                ClearScrollResponse clearScrollResponse = this.getClient().clearScroll(request, RequestOptions.DEFAULT);
                return clearScrollResponse.isSucceeded();
            }
            catch (Throwable t) {
                LOGGER.warn("Failed to release the scroll id: {}", (Object)scrollId);
            }
        }
        return false;
    }

    @Override
    public Map<String, IndexInfo> getIndexInfos() throws OpenSearchRelatedException {
        LOGGER.debug("getIndexInfos");
        try {
            GetAliasesResponse aliasesResponseOfAllIndices = this.getClient().indices().getAlias(new GetAliasesRequest().indices("*"), RequestOptions.DEFAULT);
            HashMap<String, IndexInfo> indexInfos = new HashMap<String, IndexInfo>();
            List<Map<String, Object>> indexCatalog = this.getIndexCatalog();
            for (Map<String, Object> indexMetaData : indexCatalog) {
                String index = MapUtil.getValueAsString(indexMetaData, "index", null);
                String health = MapUtil.getValueAsString(indexMetaData, "health", "");
                String state = MapUtil.getValueAsString(indexMetaData, "status", "");
                long docsCountLucene = MapUtil.getValueAsLong(indexMetaData, "docs.count", -1L);
                long docsDeletedLucene = MapUtil.getValueAsLong(indexMetaData, "docs.deleted", -1L);
                long storeSizeInBytes = MapUtil.getValueAsLong(indexMetaData, "store.size", -1L);
                long primaryStoreSizeInBytes = MapUtil.getValueAsLong(indexMetaData, "pri.store.size", -1L);
                int numberOfShards = MapUtil.getValueAsInt(indexMetaData, "pri", -1);
                int numberOfReplicas = MapUtil.getValueAsInt(indexMetaData, "rep", -1);
                long docsCount = this.getDocsCount(index);
                Set<String> aliases = this.extractAliases(index, aliasesResponseOfAllIndices);
                boolean bpcConformIndex = this.isBpcConformIndex(index, aliases);
                boolean indexWithHiddenFlag = this.managedIndicesHandler.isIndexWithHiddenFlag(aliases);
                IndexInfo indexInfo = new IndexInfo(index);
                indexInfo.setHealth(health);
                indexInfo.setState(state);
                indexInfo.setDocsCount(docsCount);
                indexInfo.setDocsCountLucene(docsCountLucene);
                indexInfo.setDocsDeletedLucene(docsDeletedLucene);
                indexInfo.setStoreSizeInBytes(storeSizeInBytes);
                indexInfo.setPrimaryStoreSizeInBytes(primaryStoreSizeInBytes);
                indexInfo.setNumberOfShards(numberOfShards);
                indexInfo.setNumberOfReplicas(numberOfReplicas);
                indexInfo.setAliases(aliases);
                indexInfo.setBpcConform(bpcConformIndex);
                indexInfo.setHidden(indexWithHiddenFlag);
                indexInfos.put(index, indexInfo);
            }
            return indexInfos;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private Set<String> extractAliases(String indexName, GetAliasesResponse aliasesResponseOfAllIndices) {
        Map<String, Set<AliasMetadata>> indexNamesWithAliases;
        HashSet<String> result = new HashSet<String>();
        if (aliasesResponseOfAllIndices != null && (indexNamesWithAliases = aliasesResponseOfAllIndices.getAliases()) != null) {
            for (AliasMetadata aliasMetaData : indexNamesWithAliases.get(indexName)) {
                result.add(aliasMetaData.alias());
            }
        }
        return result;
    }

    private boolean isBpcConformIndex(String indexName, Set<String> aliases) {
        return aliases != null && aliases.size() == 1 && aliases.iterator().next().equals(this.aliasFromBpcIndexName(indexName));
    }

    @Override
    public boolean isOpen(String indexName) throws OpenSearchRelatedException {
        LOGGER.debug("isOpen indexName={}", (Object)indexName);
        Map<String, Object> indexMetaData = this.getIndexMetaData(indexName);
        return "open".equals(indexMetaData.get("status"));
    }

    @Override
    public boolean isClosed(String indexName) throws OpenSearchRelatedException {
        LOGGER.debug("isClosed indexName={}", (Object)indexName);
        Map<String, Object> indexMetaData = this.getIndexMetaData(indexName);
        return "close".equals(indexMetaData.get("status"));
    }

    private Map<String, Object> getIndexMetaData(String indexName) throws OpenSearchRelatedException {
        Map map;
        block8: {
            InputStream inputStream = this.openOpenSearchGetEndpointAsJsonInputStream("/_cat/indices/" + indexName.trim(), null);
            try {
                ObjectMapper mapper = new ObjectMapper();
                List indexMetaDatas = (List)mapper.readValue(inputStream, List.class);
                map = (Map)indexMetaDatas.get(0);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new OpenSearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getIndexCatalog() throws OpenSearchRelatedException {
        List list;
        block8: {
            InputStream inputStream = this.openOpenSearchGetEndpointAsJsonInputStream("/_cat/indices", Map.of("bytes", "b"));
            try {
                ObjectMapper mapper = new ObjectMapper();
                list = (List)mapper.readValue(inputStream, List.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new OpenSearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return list;
    }

    private long getDocsCount(String indexName) {
        LOGGER.info("getDocsCount indexName={}", (Object)indexName);
        long result = -1L;
        try {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.query(QueryBuilders.matchAllQuery());
            CountRequest countRequest = new CountRequest(indexName);
            countRequest.source(searchSourceBuilder);
            CountResponse countResponse = this.getClient().count(countRequest, RequestOptions.DEFAULT);
            if (countResponse.status() == RestStatus.OK) {
                result = countResponse.getCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Map<String, Object> getFilesystemStats() throws OpenSearchRelatedException {
        Map map;
        block8: {
            InputStream inputStream = this.openOpenSearchGetEndpointAsJsonInputStream("/_nodes/stats/fs", null);
            try {
                ObjectMapper mapper = new ObjectMapper();
                map = (Map)mapper.readValue(inputStream, Map.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new OpenSearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getInstalledPlugins() throws OpenSearchRelatedException {
        List list;
        block8: {
            InputStream inputStream = this.openOpenSearchGetEndpointAsJsonInputStream("/_cat/plugins", null);
            try {
                ObjectMapper mapper = new ObjectMapper();
                list = (List)mapper.readValue(inputStream, List.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new OpenSearchRelatedException(ex);
                }
            }
            inputStream.close();
        }
        return list;
    }

    private InputStream openOpenSearchGetEndpointAsJsonInputStream(String endpoint, Map<String, String> additionalParameters) throws OpenSearchRelatedException {
        try {
            Request req = new Request("GET", endpoint);
            req.addParameter("format", "json");
            if (additionalParameters != null) {
                for (String name : additionalParameters.keySet()) {
                    String value = additionalParameters.get(name);
                    req.addParameter(name, value);
                }
            }
            return this.getClient().getLowLevelClient().performRequest(req).getEntity().getContent();
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public String getAttachmentsPipelineName(String indexAlias) {
        return "bpc-attachments-" + indexAlias;
    }

    @Override
    public void prepareAttachmentsPipeline(String indexAlias) throws OpenSearchRelatedException {
        LOGGER.info("prepareAttachmentsPipeline indexAlias={}", (Object)indexAlias);
        String pipelineName = this.getAttachmentsPipelineName(indexAlias);
        try {
            Set<String> binaryFields = this.getFieldNamesOfType(indexAlias, "binary");
            XContentBuilder pipelineBuilder = XContentFactory.jsonBuilder().prettyPrint();
            pipelineBuilder.startObject();
            pipelineBuilder.field("description", "BPC attachment pipeline for index '" + indexAlias + "'.");
            pipelineBuilder.startArray("processors");
            for (String binaryField : binaryFields) {
                pipelineBuilder.startObject();
                pipelineBuilder.startObject("attachment");
                pipelineBuilder.field("field", binaryField);
                pipelineBuilder.field("target_field", "bpc-attachment-" + binaryField);
                pipelineBuilder.field("ignore_missing", true);
                pipelineBuilder.endObject();
                pipelineBuilder.endObject();
            }
            pipelineBuilder.endArray();
            pipelineBuilder.endObject();
            PutPipelineRequest request = new PutPipelineRequest(pipelineName, BytesReference.bytes(pipelineBuilder), XContentType.JSON);
            AcknowledgedResponse response = this.getClient().ingest().putPipeline(request, RequestOptions.DEFAULT);
            LOGGER.info("prepareAttachmentsPipeline : Pipeline '{}' creation acknowledged? {}", (Object)pipelineName, (Object)response.isAcknowledged());
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean existsAttachmentsPipeline(String indexAlias) throws OpenSearchRelatedException {
        LOGGER.info("existsAttachmentsPipeline indexAlias={}", (Object)indexAlias);
        if (indexAlias == null) {
            return false;
        }
        String pipelineName = this.getAttachmentsPipelineName(indexAlias);
        try {
            GetPipelineRequest getPipelineRequest = new GetPipelineRequest(pipelineName);
            GetPipelineResponse getPipelineResponse = this.getClient().ingest().getPipeline(getPipelineRequest, RequestOptions.DEFAULT);
            boolean exists = getPipelineResponse.isFound();
            LOGGER.info("existsAttachmentsPipeline indexAlias={} exists? {}", (Object)indexAlias, (Object)exists);
            return exists;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public boolean deleteAttachmentsPipeline(String indexAlias) throws OpenSearchRelatedException {
        LOGGER.info("deleteAttachmentsPipeline indexAlias={}", (Object)indexAlias);
        String pipelineName = this.getAttachmentsPipelineName(indexAlias);
        try {
            DeletePipelineRequest deletePipelineRequest = new DeletePipelineRequest(pipelineName);
            AcknowledgedResponse deletePipelineResponse = this.getClient().ingest().deletePipeline(deletePipelineRequest, RequestOptions.DEFAULT);
            if (!deletePipelineResponse.isAcknowledged()) {
                LOGGER.warn("Deleting the pipeline '{}' of the index '{}' has not been acknowledged.", (Object)pipelineName, (Object)indexAlias);
                return false;
            }
            return true;
        }
        catch (OpenSearchStatusException ex) {
            if (ex.status().equals((Object)RestStatus.NOT_FOUND)) {
                LOGGER.info("deleteAttachmentsPipeline : Pipeline '{}' does not exist!", (Object)pipelineName);
                return true;
            }
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public String formatForOpenSearch(Date dateValue) {
        if (dateValue != null) {
            return this.formatForOpenSearch(dateValue.toInstant());
        }
        return null;
    }

    @Override
    public String formatForOpenSearch(java.sql.Date dateValue) {
        if (dateValue != null) {
            return dateValue.toString();
        }
        return null;
    }

    @Override
    public String formatForOpenSearch(Timestamp timestampValue) {
        if (timestampValue != null) {
            return this.formatForOpenSearch(timestampValue.toInstant());
        }
        return null;
    }

    @Override
    public String formatForOpenSearch(Instant instantValue) {
        if (instantValue != null) {
            return XContentOpenSearchExtension.DEFAULT_FORMATTER.format(ZonedDateTime.ofInstant(instantValue, ZoneOffset.UTC));
        }
        return null;
    }

    @Override
    public boolean removeAllReadOnlyFlags() throws OpenSearchRelatedException {
        try {
            Settings.Builder settings = Settings.builder().put("index.blocks.read_only_allow_delete", (String)null);
            AcknowledgedResponse updateSettingsResponse = this.getClient().indices().putSettings(new UpdateSettingsRequest("_all").settings(settings), RequestOptions.DEFAULT);
            if (!updateSettingsResponse.isAcknowledged()) {
                LOGGER.warn("Removing the read only flag of all indices has not been acknowledged.");
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public BpcIndexInfo getBpcIndexInfoUsingIndexName(String indexName) throws OpenSearchRelatedException {
        if (this.existsIndex(indexName)) {
            String indexAlias = this.aliasFromBpcIndexName(indexName);
            Map<String, Object> indexSettings = this.getSettings(indexName);
            Map<String, Object> indexMappings = this.getMapping(indexName);
            return new BpcIndexInfoImpl(indexAlias, indexName, indexSettings, indexMappings);
        }
        return null;
    }

    @Override
    public BpcIndexInfo getBpcIndexInfoUsingIndexAlias(String indexAlias) throws OpenSearchRelatedException {
        if (this.existsIndex(indexAlias)) {
            String indexName = this.getBpcIndexNameForAlias(indexAlias);
            Map<String, Object> indexSettings = this.getSettings(indexName);
            Map<String, Object> indexMappings = this.getMapping(indexName);
            return new BpcIndexInfoImpl(indexAlias, indexName, indexSettings, indexMappings);
        }
        return null;
    }

    @Override
    public void refreshOpenSearchIndexTemplates(Setting indexTemplatesSetting) throws OpenSearchRelatedException {
        LOGGER.info("refreshOpenSearchIndexTemplates indexTemplatesSetting={}", (Object)indexTemplatesSetting);
        if (!indexTemplatesSetting.getName().equals("indexTemplates")) {
            return;
        }
        Map newIndexTemplates = (Map)indexTemplatesSetting.getValue();
        Set<String> oldTemplateNames = this.getTemplateNamesWithPrefix("bpc:");
        HashSet<String> newTemplateNames = new HashSet<String>();
        for (String templateName : newIndexTemplates.keySet()) {
            if (!templateName.startsWith("bpc:")) continue;
            newTemplateNames.add(templateName);
        }
        for (String oldTemplateName : oldTemplateNames) {
            if (newTemplateNames.contains(oldTemplateName)) continue;
            this.deleteTemplate(oldTemplateName);
        }
        for (String templateName : newTemplateNames) {
            this.createTemplate(templateName, (Map)newIndexTemplates.get(templateName));
        }
    }

    @Override
    public IndexResponse index(IndexRequest indexRequest, RequestOptions options) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("index indexRequest=..., options=...");
        String aliasOfIndex = indexRequest.index();
        try {
            indexRequest.setRequireAlias(true);
            return this.getClient().index(indexRequest, options);
        }
        catch (MapperParsingException ex) {
            LOGGER.warn("{}: OpenSearch mapping mismatch while indexing a document.", (Object)aliasOfIndex);
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                try {
                    this.getManagedIndicesHandler().createManagedIndex(aliasOfIndex);
                    return this.getClient().index(indexRequest, options);
                }
                catch (IOException ex2) {
                    throw new OpenSearchRelatedException(ex2);
                }
                catch (OpenSearchException ex2) {
                    if (ex.status() == RestStatus.NOT_FOUND) {
                        throw new OpenSearchIndexNotFoundException(aliasOfIndex);
                    }
                    LOGGER.error("{}: Unhandled exception in retry index(..., ...). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)aliasOfIndex, (Object)ex.status(), (Object)ex);
                    throw new OpenSearchRelatedException(ex2);
                }
            }
            LOGGER.error("{}: Unhandled exception in index(..., ...). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)aliasOfIndex, (Object)ex.status(), (Object)ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public BulkResponse bulk(BulkRequest bulkRequest, RequestOptions options) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("bulk bulkRequest=..., options=...");
        Set<String> aliasesOfIndices = bulkRequest.getIndices();
        try {
            bulkRequest.requireAlias(true);
            BulkResponse bulkResponse = this.getClient().bulk(bulkRequest, options);
            if (!bulkResponse.hasFailures()) {
                return bulkResponse;
            }
            Set<String> missingIndices = this.extractMissingIndices(bulkResponse);
            if (missingIndices.isEmpty()) {
                return bulkResponse;
            }
            this.getManagedIndicesHandler().createManagedIndices(missingIndices);
            return this.getClient().bulk(bulkRequest, options);
        }
        catch (MapperParsingException ex) {
            LOGGER.warn("{}: OpenSearch mapping mismatch while indexing a document.", aliasesOfIndices);
            throw new OpenSearchRelatedException(ex);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    private Set<String> extractMissingIndices(BulkResponse bulkResponse) {
        HashSet<String> missingIndices = new HashSet<String>();
        for (BulkItemResponse bulkItemResponse : bulkResponse) {
            if (!bulkItemResponse.isFailed() || bulkItemResponse.getFailure().getStatus() != RestStatus.NOT_FOUND) continue;
            missingIndices.add(bulkItemResponse.getFailure().getIndex());
        }
        return missingIndices;
    }

    @Override
    public DeleteResponse delete(DeleteRequest deleteRequest, RequestOptions options) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("delete deleteRequest=..., options=...");
        try {
            return this.getClient().delete(deleteRequest, options);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new OpenSearchIndexNotFoundException(deleteRequest.index());
            }
            LOGGER.error("Unhandled exception in delete(..., ...). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)ex.status(), (Object)ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public BulkByScrollResponse deleteByQuery(DeleteByQueryRequest deleteByQueryRequest, RequestOptions options) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("delete deleteByQueryRequest=..., options=...");
        try {
            return this.getClient().deleteByQuery(deleteByQueryRequest, options);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new OpenSearchIndexNotFoundException(Objects.toString(deleteByQueryRequest.indices()));
            }
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public GetResponse get(GetRequest getRequest, RequestOptions options) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("get getRequest=..., options=...");
        try {
            return this.getClient().get(getRequest, options);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new OpenSearchIndexNotFoundException(getRequest.index());
            }
            LOGGER.error("Unhandled exception in get(..., ....). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)ex.status(), (Object)ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public MultiGetResponse mget(MultiGetRequest multiGetReq, RequestOptions options) throws OpenSearchRelatedException {
        LOGGER.info("mget multiGetReq=..., options=...");
        try {
            return this.getClient().mget(multiGetReq, options);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public SearchResponse search(SearchRequest searchRequest, RequestOptions options) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("search searchRequest=..., options=...");
        try {
            return this.getClient().search(searchRequest, options);
        }
        catch (IOException ex) {
            throw new OpenSearchRelatedException(ex);
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new OpenSearchIndexNotFoundException(Objects.toString(searchRequest.indices()));
            }
            LOGGER.error("Unhandled exception in search(..., ....). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)ex.status(), (Object)ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    @Override
    public void search(SearchRequest searchRequest, Consumer<SearchHit> searchHitConsumer) throws OpenSearchRelatedException, OpenSearchIndexNotFoundException {
        LOGGER.info("search searchRequest=..., searchHitConsumer=...");
        try (SearchScrollIterator searchScrollIterator = new SearchScrollIterator(this, searchRequest);){
            while (searchScrollIterator.hasNext()) {
                SearchHits searchHits = searchScrollIterator.next();
                for (SearchHit searchHit : searchHits) {
                    searchHitConsumer.accept(searchHit);
                }
            }
        }
        catch (OpenSearchException ex) {
            if (ex.status() == RestStatus.NOT_FOUND) {
                throw new OpenSearchIndexNotFoundException(Objects.toString(searchRequest.indices()));
            }
            LOGGER.error("Unhandled exception in search(..., ....). Please report the occurred RestStatus '{}' to the BPC developers.", (Object)ex.status(), (Object)ex);
            throw new OpenSearchRelatedException(ex);
        }
    }

    public static class OpenSearchHosts {
        public static List<OpenSearchHost> create(String multipleHostsString) {
            ArrayList<OpenSearchHost> osHosts = new ArrayList<OpenSearchHost>();
            for (String host : StringUtil.explode(multipleHostsString, ",")) {
                OpenSearchHost osHost = OpenSearchHostImpl.create(host);
                osHosts.add(osHost);
            }
            return osHosts;
        }

        public static HttpHost[] asHttpHosts(List<OpenSearchHost> entries) {
            HttpHost[] result = new HttpHost[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                OpenSearchHost openSearchHost = entries.get(i);
                result[i] = new HttpHost(openSearchHost.getSchemeName(), openSearchHost.getHostName(), openSearchHost.getPort());
            }
            return result;
        }

        public static boolean usesHttps(HttpHost[] httpsHosts) {
            if (httpsHosts != null) {
                for (HttpHost host : httpsHosts) {
                    if (!"https".equalsIgnoreCase(host.getSchemeName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum OpenSearchServiceStatus {
        Starting,
        Active,
        ShuttingDown,
        ShutDown;

    }

    private class DefaultIndexCreationSettingsSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultIndexCreationSettingsSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting indexCreationSettingsSetting) {
            LOGGER.info("{}.processSetting indexCreationSettingsSetting=...", (Object)this.getClass().getSimpleName());
            OpenSearchServiceImpl.this.setDefaultIndexCreationSettings(indexCreationSettingsSetting.getSettingValue().asMap(null));
        }
    }

    private class DefaultDynamicTemplatesSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private DefaultDynamicTemplatesSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting dynamicTemplatesSetting) {
            LOGGER.info("{}.processSetting dynamicTemplatesSetting=...", (Object)this.getClass().getSimpleName());
            OpenSearchServiceImpl.this.setDefaultDynamicTemplates(dynamicTemplatesSetting.getSettingValue().asList(null));
        }
    }

    private class IndexTemplatesSettingUpdatedEventHandler
    extends AbstractSettingUpdatedEventHandler {
        private IndexTemplatesSettingUpdatedEventHandler() {
        }

        @Override
        public void processSetting(Setting indexTemplatesSetting) {
            LOGGER.info("{}.processSetting indexTemplatesSetting=...", (Object)this.getClass().getSimpleName());
            try {
                OpenSearchServiceImpl.this.refreshOpenSearchIndexTemplates(indexTemplatesSetting);
            }
            catch (OpenSearchRelatedException ex) {
                LOGGER.error("Failed to set the index templates.", (Throwable)ex);
            }
        }
    }
}

