/*
 * Decompiled with CFR 0.152.
 */
package de.virtimo.bpc.core.websocket;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.virtimo.bpc.api.ClientSessionManager;
import de.virtimo.bpc.api.EventManager;
import de.virtimo.bpc.api.apikey.APIKeyException;
import de.virtimo.bpc.api.auth.UserSession;
import de.virtimo.bpc.api.exception.ServiceNotFoundException;
import de.virtimo.bpc.core.auth.IpPinningService;
import de.virtimo.bpc.util.ObjectMapperPool;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;

@WebSocket
public class BpcWebsocket {
    private static final Logger LOGGER = LogManager.getLogger(BpcWebsocket.class);
    public static final String CLIENT_EVENT_DOMAIN = "de/virtimo/bpc/client/";
    private final ClientSessionManager clientSessionManager;
    private final EventManager eventManager;
    private final IpPinningService ipPinningService;

    public BpcWebsocket(ClientSessionManager clientSessionManager, EventManager eventManager, IpPinningService ipPinningService) {
        LOGGER.info("BpcWebsocket clientSessionManager=..., eventManager=..., ipPinningService=...");
        this.clientSessionManager = clientSessionManager;
        this.eventManager = eventManager;
        this.ipPinningService = ipPinningService;
    }

    private boolean allowedToOpen(Session websocketSession) {
        LOGGER.debug("allowedToOpen websocketSession={}", (Object)websocketSession);
        try {
            String sessionId = this.getSessionId(websocketSession);
            if (sessionId == null) {
                return false;
            }
            if (!this.clientSessionManager.existsSession(sessionId)) {
                return false;
            }
            HttpServletRequest httpServletRequest = BpcWebsocket.getHttpServletRequest(websocketSession);
            if (httpServletRequest == null) {
                LOGGER.error("Skipping the IP pinning check. Was not able to get the http servlet request from the websocket session. Please inform the BPC developers that there is something broken, maybe due to a Karaf update. Thanks!");
                return true;
            }
            UserSession userSession = this.clientSessionManager.getUserSession(httpServletRequest);
            return this.ipPinningService.isValidRequest(httpServletRequest, userSession);
        }
        catch (APIKeyException ex) {
            LOGGER.error("Failed to get the API key related user session.", (Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error("Failed to check if it is allowed to open a websocket connection.", (Throwable)ex);
            return false;
        }
    }

    @OnWebSocketConnect
    public void onOpen(Session session) {
        LOGGER.info("onOpen session={}", (Object)session);
        if (this.allowedToOpen(session)) {
            String sessionId = this.getSessionId(session);
            if (sessionId != null) {
                this.clientSessionManager.addSession(sessionId, session);
            }
        } else {
            session.close(1008, "No valid session found");
        }
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        LOGGER.info("onClose session={}, statusCode={}, reason={}", (Object)session, (Object)statusCode, (Object)reason);
        String sessionId = this.getSessionId(session);
        if (sessionId != null) {
            this.clientSessionManager.removeSession(sessionId, session);
        }
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        LOGGER.info("onError (can be correct when the websocket connection timed out)", cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onText(Session session, String message) {
        LOGGER.info("onText session={}, message={}", (Object)session, (Object)message);
        ObjectMapper mapper = (ObjectMapper)ObjectMapperPool.getInstance().take();
        try {
            Map eventData = (Map)mapper.readValue(message, Map.class);
            if (this.isPingEventFromFrontend(eventData)) {
                LOGGER.info("Ignoring the websocket 'ping' event from frontend. Gets not broad casted to other frontends and not to other active/active servers.");
                return;
            }
            if (eventData.containsKey("event")) {
                this.eventManager.fireEvent(CLIENT_EVENT_DOMAIN + String.valueOf(eventData.get("event")), "data", eventData.get("data"));
                this.eventManager.broadcast().clientEvent(eventData);
            }
        }
        catch (ServiceNotFoundException e) {
            LOGGER.error("Failed to broadcast the received message due to missing service.", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse the JSON message.", (Throwable)e);
        }
        finally {
            if (mapper != null) {
                ObjectMapperPool.getInstance().restore((Object)mapper);
            }
        }
    }

    private String getSessionId(Session websocketSession) {
        if (websocketSession != null) {
            List httpCookies = websocketSession.getUpgradeRequest().getCookies();
            return this.clientSessionManager.getSessionId(httpCookies);
        }
        return null;
    }

    public static HttpServletRequest getHttpServletRequest(Session session) {
        UpgradeRequest upgradeRequest = session.getUpgradeRequest();
        if (upgradeRequest instanceof ServletUpgradeRequest) {
            ServletUpgradeRequest servletUpgradeRequest = (ServletUpgradeRequest)upgradeRequest;
            return servletUpgradeRequest.getHttpServletRequest();
        }
        return null;
    }

    private boolean isPingEventFromFrontend(Map<String, Object> eventData) {
        Object eventNameObject;
        LOGGER.debug("isPingEventFromFrontend eventData={}", eventData);
        if (eventData != null && eventData.containsKey("event") && (eventNameObject = eventData.get("event")) instanceof String) {
            String eventName = (String)eventNameObject;
            return "ping".equalsIgnoreCase(eventName);
        }
        return false;
    }
}

